/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ToolHarvestContext {
    private final ServerLevel world;
    private final LivingEntity living;
    @Nullable
    private final ServerPlayer player;
    @Nullable
    private final Projectile projectile;
    private final BlockState state;
    private final BlockPos pos;
    private final Direction sideHit;
    private final boolean canHarvest;
    private final boolean isEffective;
    private final boolean isAOE;
    private final BlockPos targetedPos;
    private final BlockState targetedState;

    public ToolHarvestContext(ServerLevel world, ServerPlayer player, @Nullable Projectile projectile, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective) {
        this(world, (LivingEntity)player, player, projectile, state, pos, sideHit, canHarvest, isEffective, false, pos, state);
    }

    public ToolHarvestContext(ServerLevel world, ServerPlayer player, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective) {
        this(world, player, null, state, pos, sideHit, canHarvest, isEffective);
    }

    public ToolHarvestContext(ServerLevel world, LivingEntity living, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective) {
        this.world = world;
        this.living = living;
        this.player = living instanceof ServerPlayer ? (ServerPlayer)living : null;
        this.projectile = null;
        this.state = state;
        this.pos = pos;
        this.canHarvest = canHarvest;
        this.isEffective = isEffective;
        this.sideHit = sideHit;
        this.isAOE = false;
        this.targetedPos = pos;
        this.targetedState = state;
    }

    public ToolHarvestContext forPosition(BlockPos pos, BlockState state) {
        return new ToolHarvestContext(this.world, this.living, this.player, this.projectile, state, pos, this.sideHit, state.canHarvestBlock((BlockGetter)this.world, pos, (Player)this.player), true, true, this.targetedPos, this.targetedState);
    }

    public boolean isProjectile() {
        return this.projectile != null;
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    public LivingEntity getLiving() {
        return this.living;
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return this.player;
    }

    @Nullable
    public Projectile getProjectile() {
        return this.projectile;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSideHit() {
        return this.sideHit;
    }

    public boolean canHarvest() {
        return this.canHarvest;
    }

    public boolean isEffective() {
        return this.isEffective;
    }

    public boolean isAOE() {
        return this.isAOE;
    }

    public BlockPos getTargetedPos() {
        return this.targetedPos;
    }

    public BlockState getTargetedState() {
        return this.targetedState;
    }

    private ToolHarvestContext(ServerLevel world, LivingEntity living, @Nullable ServerPlayer player, @Nullable Projectile projectile, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective, boolean isAOE, BlockPos targetedPos, BlockState targetedState) {
        this.world = world;
        this.living = living;
        this.player = player;
        this.projectile = projectile;
        this.state = state;
        this.pos = pos;
        this.sideHit = sideHit;
        this.canHarvest = canHarvest;
        this.isEffective = isEffective;
        this.isAOE = isAOE;
        this.targetedPos = targetedPos;
        this.targetedState = targetedState;
    }
}

