/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.TippingCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class PotionCastingRecipeBuilder
extends AbstractRecipeBuilder<PotionCastingRecipeBuilder> {
    private final Item result;
    @Nullable
    private final ModifierId modifier;
    private final TypeAwareRecipeSerializer<? extends PotionCastingRecipe> recipeSerializer;
    private Ingredient bottle = Ingredient.f_43901_;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = 5;

    public static PotionCastingRecipeBuilder castingRecipe(ItemLike result, TypeAwareRecipeSerializer<PotionCastingRecipe> serializer) {
        return new PotionCastingRecipeBuilder(result.m_5456_(), null, serializer);
    }

    public static PotionCastingRecipeBuilder basinRecipe(ItemLike result) {
        return PotionCastingRecipeBuilder.castingRecipe(result, (TypeAwareRecipeSerializer<PotionCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinPotionRecipeSerializer.get()));
    }

    public static PotionCastingRecipeBuilder tableRecipe(ItemLike result) {
        return PotionCastingRecipeBuilder.castingRecipe(result, (TypeAwareRecipeSerializer<PotionCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tablePotionRecipeSerializer.get()));
    }

    public static PotionCastingRecipeBuilder tippingRecipe(ModifierId modifier, TypeAwareRecipeSerializer<? extends PotionCastingRecipe> serializer) {
        return new PotionCastingRecipeBuilder(Items.f_41852_, modifier, serializer);
    }

    public static PotionCastingRecipeBuilder basinTipping(ModifierId modifier) {
        return PotionCastingRecipeBuilder.tippingRecipe(modifier, (TypeAwareRecipeSerializer<? extends PotionCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinTippingRecipeSerializer.get()));
    }

    public static PotionCastingRecipeBuilder tableTipping(ModifierId modifier) {
        return PotionCastingRecipeBuilder.tippingRecipe(modifier, (TypeAwareRecipeSerializer<? extends PotionCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableTippingRecipeSerializer.get()));
    }

    public PotionCastingRecipeBuilder setFluid(TagKey<Fluid> tagIn, int amount) {
        return this.setFluid((FluidIngredient)FluidIngredient.of(tagIn, (int)amount));
    }

    public PotionCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public PotionCastingRecipeBuilder setBottle(TagKey<Item> tagIn) {
        return this.setBottle(Ingredient.m_204132_(tagIn));
    }

    public PotionCastingRecipeBuilder setBottle(ItemLike itemIn) {
        return this.setBottle(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public PotionCastingRecipeBuilder setBottle(Ingredient ingredient) {
        this.bottle = ingredient;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, BuiltInRegistries.f_257033_.m_7981_((Object)this.result));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        if (this.modifier != null) {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new TippingCastingRecipe(this.recipeSerializer, id, this.group, this.bottle, this.fluid, this.coolingTime, this.modifier), TippingCastingRecipe.LOADER, advancementId));
        } else {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new PotionCastingRecipe(this.recipeSerializer, id, this.group, this.bottle, this.fluid, this.result, this.coolingTime), PotionCastingRecipe.LOADER, advancementId));
        }
    }

    private PotionCastingRecipeBuilder(Item result, @Nullable ModifierId modifier, TypeAwareRecipeSerializer<? extends PotionCastingRecipe> recipeSerializer) {
        this.result = result;
        this.modifier = modifier;
        this.recipeSerializer = recipeSerializer;
    }

    public PotionCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }
}

