/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.entity.ToolProjectile;

public class ModifiableArrow
extends AbstractArrow
implements ToolProjectile {
    protected static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(ModifiableArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Float> WATER_INERTIA = SynchedEntityData.m_135353_(ModifiableArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private ItemStack stack = ItemStack.f_41583_;
    private IToolStackView tool = null;
    private boolean reclaim = false;
    private boolean dealtDamage = false;
    private CaptureDiscard captureDiscard = CaptureDiscard.NOT_CAPTURING;
    private static final String KEY_STACK = "stack";
    private static final String KEY_WATER_INERTIA = "water_inertia";
    private static final String KEY_DEALT_DAMAGE = "dealt_damage";

    public ModifiableArrow(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public ModifiableArrow(Level level, double pX, double pY, double pZ) {
        super((EntityType)TinkerTools.materialArrow.get(), pX, pY, pZ, level);
    }

    public ModifiableArrow(Level level, LivingEntity shooter) {
        super((EntityType)TinkerTools.materialArrow.get(), shooter, level);
    }

    public ItemStack m_7941_() {
        return this.stack.m_41777_();
    }

    private void setStack(ItemStack stack) {
        this.stack = stack;
        this.f_19804_.m_135381_(STACK, (Object)stack);
        this.reclaim = ModifierUtil.checkVolatileFlag(stack, IndestructibleItemEntity.INDESTRUCTIBLE_ENTITY);
    }

    private IToolStackView getTool() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.stack);
        }
        return this.tool;
    }

    public void onCreate(ItemStack stack, @Nullable LivingEntity shooter) {
        if (stack.m_41619_()) {
            this.setStack(ItemStack.f_41583_);
            return;
        }
        stack = stack.m_255036_(1);
        this.setStack(stack);
        IToolStackView tool = this.getTool();
        EntityModifierCapability.getCapability((Entity)this).addModifiers(tool.getModifiers());
        this.m_36781_(ConditionalStatModifierHook.getModifiedStat(tool, shooter, ToolStats.PROJECTILE_DAMAGE));
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(ConditionalStatModifierHook.getModifiedStat(tool, shooter, ToolStats.WATER_INERTIA)));
    }

    public void m_6686_(double pX, double pY, double pZ, float velocity, float inaccuracy) {
        if (!this.stack.m_41619_()) {
            IToolStackView tool = this.getTool();
            LivingEntity shooter = ModifierUtil.asLiving(this.m_19749_());
            super.m_6686_(pX, pY, pZ, velocity, inaccuracy *= ModifierUtil.getInaccuracy(tool, shooter));
            ModDataNBT arrowData = PersistentDataCapability.getOrWarn((Entity)this);
            for (ModifierEntry entry : tool.getModifiers()) {
                entry.getHook(ModifierHooks.PROJECTILE_SHOT).onProjectileShoot(tool, entry, shooter, this.stack, (Projectile)this, this, arrowData, true);
            }
        } else {
            super.m_6686_(pX, pY, pZ, velocity, inaccuracy);
        }
    }

    protected float m_6882_() {
        return ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue();
    }

    public void m_36735_(int knockback) {
        super.m_36735_(this.m_150123_() + knockback);
    }

    public void m_36767_(byte pierceLevel) {
        super.m_36767_((byte)(this.m_36796_() + pierceLevel));
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || !this.reclaim) {
            super.m_6901_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        if (this.reclaim) {
            this.captureDiscard = CaptureDiscard.CAPTURING;
        }
        super.m_5790_(result);
        if (this.captureDiscard == CaptureDiscard.DISCARDED) {
            this.dealtDamage = true;
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        }
        this.captureDiscard = CaptureDiscard.NOT_CAPTURING;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED && this.captureDiscard != CaptureDiscard.NOT_CAPTURING && this.m_20184_().m_82556_() >= 1.0E-7) {
            this.captureDiscard = CaptureDiscard.DISCARDED;
        } else {
            super.m_142687_(reason);
        }
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(WATER_INERTIA, (Object)Float.valueOf(0.6f));
    }

    @Override
    public ItemStack getDisplayTool() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public Component m_5446_() {
        return this.getDisplayTool().m_41611_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_(KEY_STACK, (Tag)this.stack.m_41739_(new CompoundTag()));
        tag.m_128350_(KEY_WATER_INERTIA, ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue());
        tag.m_128379_(KEY_DEALT_DAMAGE, this.dealtDamage);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_(KEY_STACK, 10)) {
            this.setStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_(KEY_STACK)));
        }
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(tag.m_128457_(KEY_WATER_INERTIA)));
        this.dealtDamage = tag.m_128471_(KEY_DEALT_DAMAGE);
    }

    private static enum CaptureDiscard {
        NOT_CAPTURING,
        CAPTURING,
        DISCARDED;

    }
}

