/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

public class TinkerEffect
extends MobEffect {
    private final boolean show;

    public TinkerEffect(MobEffectCategory typeIn, boolean show) {
        this(typeIn, 0xFFFFFF, show);
    }

    public TinkerEffect(MobEffectCategory typeIn, int color, boolean show) {
        super(typeIn, color);
        this.show = show;
    }

    public TinkerEffect addAttributeModifier(Attribute pAttribute, String pUuid, double pAmount, AttributeModifier.Operation pOperation) {
        super.m_19472_(pAttribute, pUuid, pAmount, pOperation);
        return this;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return TinkerEffect.this.show;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return TinkerEffect.this.show;
            }
        });
    }

    public MobEffectInstance apply(LivingEntity entity, int duration) {
        return this.apply(entity, duration, 0);
    }

    public MobEffectInstance apply(LivingEntity entity, int duration, int level) {
        return this.apply(entity, duration, level, false);
    }

    public MobEffectInstance apply(LivingEntity entity, int duration, int amplifier, boolean showIcon) {
        MobEffectInstance effect = new MobEffectInstance((MobEffect)this, duration, amplifier, false, false, showIcon);
        entity.m_7292_(effect);
        return effect;
    }

    public static int getLevel(LivingEntity entity, MobEffect effect) {
        return TinkerEffect.getAmplifier(entity, effect) + 1;
    }

    public static int getLevel(LivingEntity entity, Supplier<? extends MobEffect> effect) {
        return TinkerEffect.getAmplifier(entity, effect.get()) + 1;
    }

    public static int getAmplifier(LivingEntity entity, MobEffect effect) {
        MobEffectInstance instance = entity.m_21124_(effect);
        if (instance != null) {
            return instance.m_19564_();
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int getLevel(LivingEntity entity) {
        return TinkerEffect.getAmplifier(entity, this);
    }
}

