/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.LauncherHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.recipe.SingleItemContainer;
import slimeknights.tconstruct.library.tools.capability.inventory.InventoryModule;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record SmeltingModule(RecipeType<? extends AbstractCookingRecipe> recipeType, float multiplier, InventoryModule inventory) implements ModifierModule,
MeleeHitModifierHook,
LauncherHitModifierHook,
BlockHarvestModifierHook,
ProjectileLaunchModifierHook,
OnAttackedModifierHook,
PlantHarvestModifierHook,
ShearsModifierHook
{
    private static final String TAG_TIME = "tic_remaining_time";
    private static final SingleItemContainer CONTAINER = new SingleItemContainer();
    private static AbstractCookingRecipe lastRecipe = null;
    private static final int DONE_COOKING = -1;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.LAUNCHER_HIT, ModifierHooks.BLOCK_HARVEST, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.ON_ATTACKED, ModifierHooks.PLANT_HARVEST, ModifierHooks.SHEAR_ENTITY);
    public static final RecordLoadable<SmeltingModule> LOADER = RecordLoadable.create((RecordField)TinkerLoadables.RECIPE_TYPE.flatXmap(t -> t, t -> t).requiredField("recipe_type", SmeltingModule::recipeType), (RecordField)FloatLoadable.FROM_ZERO.requiredField("multiplier", SmeltingModule::multiplier), (RecordField)InventoryModule.LOADER.directField(SmeltingModule::inventory), SmeltingModule::new);

    public RecordLoadable<SmeltingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addModules(ModuleHookMap.Builder builder) {
        builder.addModule(this.inventory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static AbstractCookingRecipe findRecipe(RecipeType<? extends AbstractCookingRecipe> recipeType, ItemStack stack, Level level, ModifierId modifier) {
        if (stack.m_41613_() != 1) {
            return null;
        }
        CONTAINER.setStack(stack);
        try {
            if (lastRecipe != null && lastRecipe.m_5818_((Container)CONTAINER, level)) {
                AbstractCookingRecipe abstractCookingRecipe = lastRecipe;
                return abstractCookingRecipe;
            }
            AbstractCookingRecipe recipe = level.m_7465_().m_44015_(recipeType, (Container)CONTAINER, level).orElse(null);
            if (recipe != null) {
                lastRecipe = recipe;
            }
            AbstractCookingRecipe abstractCookingRecipe = recipe;
            return abstractCookingRecipe;
        }
        catch (Exception e) {
            TConstruct.LOG.error("Error fetching recipe for {} on modifier {}, this usually indicates a broken modifier or a broken recipe", (Object)stack, (Object)modifier, (Object)e);
            AbstractCookingRecipe abstractCookingRecipe = null;
            return abstractCookingRecipe;
        }
        finally {
            CONTAINER.setStack(ItemStack.f_41583_);
        }
    }

    private void cookItems(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, float amount) {
        this.cookItems(tool, modifier, holder.m_9236_(), holder, amount);
    }

    private void cookItems(IToolStackView tool, ModifierEntry modifier, Level level, @Nullable LivingEntity holder, float amount) {
        ResourceLocation key;
        if (!this.inventory.condition().matches(tool, modifier) || amount < 0.0f) {
            return;
        }
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(key = this.inventory.getKey(modifier.getModifier()), 9)) {
            ListTag list = tool.getPersistentData().get(key, InventoryModule.GET_COMPOUND_LIST);
            float cookingPower = amount * this.multiplier;
            for (int i = 0; i < list.size(); ++i) {
                AbstractCookingRecipe recipe = null;
                ItemStack stack = null;
                CompoundTag entry = list.m_128728_(i);
                int time = entry.m_128451_(TAG_TIME);
                if (time == 0) {
                    time = -1;
                    stack = ItemStack.m_41712_((CompoundTag)entry);
                    recipe = SmeltingModule.findRecipe(this.recipeType, stack, level, modifier.getId());
                    if (recipe != null) {
                        time = recipe.m_43753_();
                    }
                    entry.m_128405_(TAG_TIME, time);
                }
                if (time < 0) continue;
                if ((float)time > cookingPower) {
                    time = (int)((float)time - cookingPower);
                    entry.m_128405_(TAG_TIME, time);
                    break;
                }
                cookingPower -= (float)time;
                if (recipe == null && !(stack = ItemStack.m_41712_((CompoundTag)entry)).m_41619_()) {
                    recipe = SmeltingModule.findRecipe(this.recipeType, stack, level, modifier.getId());
                }
                if (recipe != null) {
                    CONTAINER.setStack(stack);
                    try {
                        ItemStack result = recipe.m_5874_((Container)CONTAINER, level.m_9598_());
                        if (result.m_41619_()) {
                            list.remove(i);
                            --i;
                        } else {
                            int slot = entry.m_128451_("Slot");
                            entry.m_128431_().clear();
                            if (result.m_41613_() > 1) {
                                result.m_41764_(1);
                            }
                            InventoryModule.writeStack(result, slot, entry);
                            if (holder != null) {
                                level.m_6263_(null, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), SoundEvents.f_11914_, holder.m_5720_(), 1.0f, 1.0f);
                                float experience = recipe.m_43750_();
                                if (experience > 0.0f && level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    int floored = Mth.m_14143_((float)experience);
                                    float fraction = Mth.m_14187_((float)experience);
                                    if (fraction != 0.0f && level.m_213780_().m_188501_() < fraction) {
                                        ++floored;
                                    }
                                    ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)holder.m_20182_(), (int)floored);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        TConstruct.LOG.error("Error getting result of recipe {} on modifier {}, this usually indicates a broken recipe", (Object)recipe.m_6423_(), (Object)modifier, (Object)e);
                    }
                    CONTAINER.setStack(ItemStack.f_41583_);
                }
                entry.m_128405_(TAG_TIME, -1);
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.cookItems(tool, modifier, context.getAttacker(), damageDealt);
    }

    @Override
    public void onLauncherHitEntity(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity attacker, Entity target, @Nullable LivingEntity livingTarget, float damageDealt) {
        this.cookItems(tool, modifier, attacker, damageDealt);
    }

    @Override
    public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, int harvested) {
        this.cookItems(tool, modifier, context.getLiving(), harvested);
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        this.cookItems(tool, modifier, shooter, arrow == null ? ToolStats.PROJECTILE_DAMAGE.getDefaultValue().floatValue() : (float)arrow.m_36789_());
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            this.cookItems(tool, modifier, context.getEntity(), amount);
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        this.cookItems(tool, modifier, context.m_43725_(), (LivingEntity)context.m_43723_(), 1.0f);
    }

    @Override
    public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
        this.cookItems(tool, modifier, (LivingEntity)player, 1.0f);
    }
}

