/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.events.teleport.FluidEffectTeleportEvent;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.utils.TeleportHelper;

public record RandomTeleportFluidEffect(LevelingInt diameter, LevelingInt chances) implements FluidEffect<FluidEffectContext.Entity>
{
    private static final LevelingInt DEFAULT = LevelingInt.flat(16);
    public static final RecordLoadable<RandomTeleportFluidEffect> LOADER = RecordLoadable.create((RecordField)LevelingInt.LOADABLE.defaultField("diameter", (Object)DEFAULT, true, RandomTeleportFluidEffect::diameter), (RecordField)LevelingInt.LOADABLE.defaultField("chances", (Object)DEFAULT, true, RandomTeleportFluidEffect::chances), RandomTeleportFluidEffect::new);

    @Override
    public RecordLoadable<RandomTeleportFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        boolean isFlat;
        LivingEntity target = context.getLivingTarget();
        boolean bl = isFlat = this.diameter.eachLevel() == 0 && this.chances.eachLevel() == 0;
        if (target != null && (level.isFull() || !isFlat)) {
            float value = level.value();
            if (action.execute()) {
                TeleportHelper.randomNearbyTeleport(target, FluidEffectTeleportEvent.TELEPORT_FACTORY, this.diameter.compute(value), this.chances.compute(value));
            }
            return isFlat ? 1.0f : value;
        }
        return 0.0f;
    }
}

