/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.power;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.power.PowerVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public record PowerFormula(ModifierFormula formula, List<PowerVariable> variables, String[] variableNames, boolean percent) implements VariableFormula<PowerVariable>
{
    public static final String[] VARIABLES = new String[]{"level", "damage", "multiplier"};
    public static final RecordLoadable<PowerFormula> LOADER = new VariableFormulaLoadable<PowerVariable, PowerFormula>(PowerVariable.LOADER, VARIABLES, (formula, variables, percent) -> new PowerFormula((ModifierFormula)formula, (List<PowerVariable>)variables, EMPTY_STRINGS, (boolean)percent));

    public PowerFormula(ModifierFormula formula, Map<String, PowerVariable> variables, boolean percent) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables), percent);
    }

    private float[] getArguments(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, @Nullable Projectile projectile, @Nullable EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, double damage, float multiplier) {
        int size = this.variables.size();
        float[] arguments = new float[3 + size];
        arguments[0] = this.formula.processLevel(modifier);
        arguments[1] = (float)damage;
        arguments[2] = multiplier;
        for (int i = 0; i < size; ++i) {
            arguments[3 + i] = this.variables.get(i).getValue(modifiers, persistentData, modifier, projectile, hit, attacker, target);
        }
        return arguments;
    }

    public float apply(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, @Nullable Projectile projectile, @Nullable EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, double damage, float multiplier) {
        return this.formula.apply(this.getArguments(modifiers, persistentData, modifier, projectile, hit, attacker, target, damage, multiplier));
    }
}

