/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.IRecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class FramesSpriteTransformer
implements IRecolorSpriteTransformer {
    public static final ResourceLocation NAME = TConstruct.getResource("frames");
    private final List<IRecolorSpriteTransformer> frames;
    private final ResourceLocation metaPath;
    private JsonObject meta;
    public static final JsonDeserializer<FramesSpriteTransformer> DESERIALIZER = (json, type, context) -> {
        JsonObject object = json.getAsJsonObject();
        JsonArray array = GsonHelper.m_13933_((JsonObject)object, (String)"frames");
        ArrayList<IRecolorSpriteTransformer> frames = new ArrayList<IRecolorSpriteTransformer>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement element = array.get(i);
            ISpriteTransformer frame = (ISpriteTransformer)SERIALIZER.deserialize(element, ISpriteTransformer.class, context);
            if (!(frame instanceof IRecolorSpriteTransformer)) {
                throw new JsonSyntaxException("Expected frames[" + i + "] to be of type IRecolorSpriteTransformer");
            }
            IRecolorSpriteTransformer recoloring = (IRecolorSpriteTransformer)frame;
            frames.add(recoloring);
        }
        return new FramesSpriteTransformer(List.copyOf(frames), JsonHelper.getResourceLocation((JsonObject)object, (String)"meta"));
    };

    public FramesSpriteTransformer(List<IRecolorSpriteTransformer> frames, ResourceLocation metaPath) {
        this.frames = frames;
        this.metaPath = metaPath;
    }

    public FramesSpriteTransformer(ResourceLocation metaPath, IRecolorSpriteTransformer ... frames) {
        this(List.of(frames), metaPath);
    }

    @Override
    public int getFrames() {
        return this.frames.size();
    }

    @Override
    public int getNewColor(int color, int x, int y, int frame) {
        IRecolorSpriteTransformer transformer = this.frames.get(frame);
        return transformer.getNewColor(color, x, y, frame % transformer.getFrames());
    }

    @Override
    public void transform(NativeImage image, boolean allowAnimated) {
        if (!allowAnimated) {
            this.frames.get(0).transform(image, false);
            return;
        }
        int width = image.m_84982_();
        int frames = this.getFrames();
        int height = image.m_85084_() / frames;
        for (int f = frames - 1; f >= 0; --f) {
            IRecolorSpriteTransformer transformer = this.frames.get(f);
            int maxFrame = transformer.getFrames();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.m_84988_(x, y + f * height, transformer.getNewColor(image.m_84985_(x, y), x, y, f % maxFrame));
                }
            }
        }
    }

    @Override
    public NativeImage copyImage(NativeImage image, boolean allowAnimated) {
        return ISpriteTransformer.copyImage(image, allowAnimated ? this.getFrames() : 1);
    }

    @Override
    @Nullable
    public JsonObject animationMeta(NativeImage image) {
        if (this.meta == null) {
            if (GreyToSpriteTransformer.READER == null) {
                throw new IllegalStateException("Cannot get image for a sprite without reader");
            }
            try {
                this.meta = GreyToSpriteTransformer.READER.readMetadata(this.metaPath);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load required metadata", ex);
            }
        }
        return this.meta;
    }

    @Override
    public int getFallbackColor() {
        return this.frames.get(0).getFallbackColor();
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(NAME);
        JsonArray frames = new JsonArray();
        for (IRecolorSpriteTransformer transformer : this.frames) {
            frames.add((JsonElement)transformer.serialize(context));
        }
        json.add("frames", (JsonElement)frames);
        json.addProperty("meta", this.metaPath.toString());
        return json;
    }
}

