/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.build;

import java.util.List;
import net.minecraft.world.item.ArmorItem;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolStatsHook;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public record MultiplyStatsModule(MultiplierNBT multipliers) implements ToolStatsHook,
ToolModule
{
    public static final RecordLoadable<MultiplyStatsModule> LOADER = RecordLoadable.create((RecordField)MultiplierNBT.LOADABLE.requiredField("multipliers", MultiplyStatsModule::multipliers), MultiplyStatsModule::new);
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_STATS);

    public RecordLoadable<MultiplyStatsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addToolStats(IToolContext context, ModifierStatsBuilder builder) {
        for (INumericToolStat<?> stat : this.multipliers.getContainedStats()) {
            stat.multiplyAll(builder, this.multipliers.get(stat));
        }
    }

    public static ArmorBuilder armor(List<ArmorItem.Type> slots) {
        return new ArmorBuilder(slots);
    }

    public static class ArmorBuilder
    implements ArmorModuleBuilder<MultiplyStatsModule> {
        private final List<ArmorItem.Type> slotTypes;
        private final MultiplierNBT.Builder[] builders = new MultiplierNBT.Builder[4];

        private ArmorBuilder(List<ArmorItem.Type> slotTypes) {
            this.slotTypes = slotTypes;
            for (ArmorItem.Type slotType : slotTypes) {
                this.builders[slotType.ordinal()] = MultiplierNBT.builder();
            }
        }

        protected MultiplierNBT.Builder getBuilder(ArmorItem.Type slotType) {
            MultiplierNBT.Builder builder = this.builders[slotType.ordinal()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType);
            }
            return builder;
        }

        public ArmorBuilder set(ArmorItem.Type slotType, INumericToolStat<?> stat, float value) {
            this.getBuilder(slotType).set(stat, value);
            return this;
        }

        public ArmorBuilder setAll(INumericToolStat<?> stat, float value) {
            for (ArmorItem.Type slotType : this.slotTypes) {
                this.set(slotType, stat, value);
            }
            return this;
        }

        public final ArmorBuilder setInOrder(INumericToolStat<?> stat, float ... values) {
            if (values.length != this.slotTypes.size()) {
                throw new IllegalStateException("Wrong number of stats set");
            }
            for (int i = 0; i < values.length; ++i) {
                this.set(this.slotTypes.get(i), stat, values[i]);
            }
            return this;
        }

        @Override
        public MultiplyStatsModule build(ArmorItem.Type slot) {
            return new MultiplyStatsModule(this.getBuilder(slot).build());
        }
    }
}

