/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.RomanNumeralHelper;

public enum TippedModule implements ModifierModule,
ProjectileLaunchModifierHook.NoShooter,
ProjectileHitModifierHook,
ModifierRemovalHook,
DisplayNameModifierHook,
TooltipModifierHook
{
    INSTANCE;

    private static final String FORMAT;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final RecordLoadable<TippedModule> LOADER;

    public RecordLoadable<TippedModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onProjectileShoot(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity shooter, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        ModifierId key = modifier.getId();
        ModDataNBT toolData = tool.getPersistentData();
        if (toolData.contains(key, 8)) {
            persistentData.putString(key, toolData.getString(key));
        }
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(modifier.getId());
        return null;
    }

    private static int getDivisor(ModifierEntry modifier) {
        return 1 << Math.max(4 - modifier.intEffectiveLevel(), 0);
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        ResourceLocation id;
        ModifierId key = modifier.getId();
        if (target != null && persistentData.contains(key, 8) && (id = ResourceLocation.m_135820_((String)persistentData.getString(key))) != null) {
            Entity source = projectile.m_150173_();
            int divisor = TippedModule.getDivisor(modifier);
            int oldHurtTime = target.f_19802_;
            target.f_19802_ = 0;
            for (MobEffectInstance instance : ((Potion)BuiltInRegistries.f_256980_.m_7745_(id)).m_43488_()) {
                MobEffect effect = instance.m_19544_();
                if (effect.m_8093_()) {
                    effect.m_19461_(source, (Entity)projectile, target, instance.m_19564_(), (double)(1.0f / ((float)divisor * 0.75f)));
                    continue;
                }
                target.m_147207_(new MobEffectInstance(instance.m_19544_(), Math.max(instance.m_267696_(i -> i / divisor), 1), instance.m_19564_(), instance.m_19571_(), instance.m_19572_()), source);
            }
            target.f_19802_ = oldHurtTime;
        }
        return false;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        Potion potion;
        ResourceLocation id;
        ModifierId key = modifier.getId();
        ModDataNBT toolData = tool.getPersistentData();
        if (toolData.contains(key, 8) && (id = ResourceLocation.m_135820_((String)toolData.getString(key))) != null && (potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(id)) != Potions.f_43598_) {
            PotionUtils.m_43559_((Potion)potion);
            PotionUtils.m_257410_((List)potion.m_43488_(), tooltip, (float)(1.0f / (float)TippedModule.getDivisor(modifier)));
        }
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        Potion potion;
        ResourceLocation id;
        ModifierId key = entry.getId();
        ModDataNBT toolData = tool.getPersistentData();
        if (toolData.contains(key, 8) && (id = ResourceLocation.m_135820_((String)toolData.getString(key))) != null && (potion = (Potion)BuiltInRegistries.f_256980_.m_7745_(id)) != Potions.f_43598_) {
            return Component.m_237110_((String)FORMAT, (Object[])new Object[]{RomanNumeralHelper.getNumeral(entry.getLevel()), Component.m_237115_((String)potion.m_43492_("item.minecraft.potion.effect."))}).m_130938_(style -> style.m_178520_(PotionUtils.m_43559_((Potion)potion)));
        }
        return name;
    }

    static {
        FORMAT = TConstruct.makeTranslationKey("modifier", "tipped.format");
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.PROJECTILE_THROWN, ModifierHooks.PROJECTILE_HIT, ModifierHooks.DISPLAY_NAME, ModifierHooks.TOOLTIP, ModifierHooks.REMOVE);
        LOADER = new SingletonLoader((Object)INSTANCE);
    }
}

