/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.display.ToolNameHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.entity.ToolProjectile;

public class ThrownTool
extends ThrownTrident
implements ToolProjectile {
    protected static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(ThrownTool.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Float> WATER_INERTIA = SynchedEntityData.m_135353_(ThrownTool.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final ResourceLocation LOYALTY = TConstruct.getResource("loyalty");
    @Nullable
    private IToolStackView tool = null;
    private float charge = 1.0f;
    private float multiplier = 1.0f;
    private boolean noDespawn = false;
    private int originalSlot = -1;
    private static final String KEY_CHARGE = "charge";
    private static final String KEY_MULTIPLIER = "multiplier";
    private static final String KEY_WATER_INERTIA = "water_inertia";
    private static final String KEY_ORIGINAL_SLOT = "original_slot";

    public ThrownTool(EntityType<? extends ThrownTrident> type, Level level) {
        super(type, level);
    }

    public ThrownTool(Level level, LivingEntity shooter, ItemStack stack, float charge, float multiplier, float waterInertia) {
        this((EntityType<? extends ThrownTrident>)((EntityType)TinkerTools.thrownTool.get()), level);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        this.f_37555_ = stack.m_255036_(1);
        this.charge = charge;
        this.multiplier = multiplier;
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(waterInertia));
        this.updateFromStack();
    }

    private void updateFromStack() {
        this.f_19804_.m_135381_(STACK, (Object)this.f_37555_);
        this.f_19804_.m_135381_(f_37558_, (Object)((byte)ModifierUtil.getVolatileInt(this.f_37555_, LOYALTY)));
        this.f_19804_.m_135381_(f_37554_, (Object)ModifierUtil.checkVolatileFlag(this.f_37555_, ModifiableItem.SHINY));
        this.noDespawn = ModifierUtil.checkVolatileFlag(this.f_37555_, IndestructibleItemEntity.INDESTRUCTIBLE_ENTITY);
    }

    protected float m_6882_() {
        return ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue();
    }

    public boolean m_150194_() {
        return !this.f_37555_.m_41619_() && this.getTool().getModifiers().getLevel(ModifierIds.channeling) > 0;
    }

    public Component m_5446_() {
        if (this.f_37555_.m_41619_()) {
            return super.m_5446_();
        }
        IToolStackView tool = this.getTool();
        return ToolNameHook.getName(tool.getDefinition(), this.f_37555_, tool);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || this.f_37555_.m_41619_()) {
            ++this.f_36697_;
            if (this.f_36697_ >= 1200) {
                this.m_146870_();
            }
        } else if (!this.noDespawn && (Byte)this.f_19804_.m_135370_(f_37558_) == 0) {
            ++this.f_36697_;
            if (this.f_36697_ >= 6000) {
                this.m_146870_();
            }
        }
    }

    protected void m_6088_() {
        if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED && (Byte)this.f_19804_.m_135370_(f_37558_) != 0) {
            this.f_37556_ = true;
            if (!this.f_37555_.m_41619_()) {
                LivingEntity l;
                Entity entity;
                ToolDamageUtil.damage(this.getTool(), 1, (entity = this.m_19749_()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null, this.f_37555_);
            }
        } else {
            super.m_6088_();
        }
    }

    private IToolStackView getTool() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.f_37555_);
        }
        return this.tool;
    }

    public void m_8119_() {
        if (!this.f_37556_ && this.f_36704_ > 4) {
            if (!this.f_37555_.m_41619_()) {
                LivingEntity l;
                Entity entity;
                ToolDamageUtil.damage(this.getTool(), 1, (entity = this.m_19749_()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null, this.f_37555_);
            }
            this.f_37556_ = true;
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity;
        this.f_37556_ = true;
        if (!this.f_37555_.m_41619_() && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Entity target = pResult.m_82443_();
            ItemStack offhand = owner.m_21206_();
            IToolStackView tool = this.getTool();
            if (ToolAttackUtil.canPerformAttack(tool) && ToolAttackUtil.isAttackable(owner, target)) {
                owner.m_21008_(InteractionHand.OFF_HAND, this.f_37555_);
                if (ToolAttackUtil.performAttack(tool, ToolAttackContext.attacker(owner).target(target).hand(InteractionHand.OFF_HAND).baseDamage(tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue() * this.multiplier).cooldown(this.charge).projectile((Projectile)this).build())) {
                    if (target.m_6095_() == EntityType.f_20566_ && tool.getModifiers().getLevel(TinkerModifiers.enderference.getId()) == 0) {
                        owner.m_21008_(InteractionHand.OFF_HAND, offhand);
                        return;
                    }
                    if (target instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)target;
                        this.m_7761_(living);
                    }
                }
                owner.m_21008_(InteractionHand.OFF_HAND, offhand);
            }
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
            if (!this.m_9236_().f_46443_ && tool.getModifiers().getLevel(ModifierIds.channeling) == 0) {
                this.m_5496_(tool.isBroken() ? SoundEvents.f_12018_ : SoundEvents.f_12514_, 1.0f, 1.0f);
            }
        }
    }

    private boolean addToInventory(Player player) {
        ItemStack pickup = this.m_7941_();
        Inventory inventory = player.m_150109_();
        if (this.originalSlot != -1) {
            ItemStack current = inventory.m_8020_(this.originalSlot);
            if (current.m_41619_()) {
                inventory.m_6836_(this.originalSlot, pickup);
                return true;
            }
            if (current.m_41613_() < current.m_41741_() && ItemStack.m_150942_((ItemStack)current, (ItemStack)pickup)) {
                current.m_41769_(1);
                return true;
            }
        }
        return inventory.m_36054_(pickup);
    }

    protected boolean m_142470_(Player player) {
        return switch (this.f_36705_) {
            case AbstractArrow.Pickup.ALLOWED -> this.addToInventory(player);
            case AbstractArrow.Pickup.CREATIVE_ONLY -> player.m_150110_().f_35937_;
            default -> this.m_36797_() && this.m_150171_((Entity)player) && this.addToInventory(player);
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(WATER_INERTIA, (Object)Float.valueOf(0.6f));
    }

    @Override
    public ItemStack getDisplayTool() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_(KEY_CHARGE, this.charge);
        tag.m_128350_(KEY_MULTIPLIER, this.multiplier);
        tag.m_128350_(KEY_WATER_INERTIA, ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue());
        if (this.originalSlot != -1) {
            tag.m_128405_(KEY_ORIGINAL_SLOT, this.originalSlot);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Trident", 10)) {
            this.updateFromStack();
        }
        this.charge = tag.m_128457_(KEY_CHARGE);
        this.multiplier = tag.m_128457_(KEY_MULTIPLIER);
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(tag.m_128457_(KEY_WATER_INERTIA)));
        this.originalSlot = tag.m_128425_(KEY_ORIGINAL_SLOT, 99) ? tag.m_128451_(KEY_ORIGINAL_SLOT) : -1;
    }

    public void setOriginalSlot(int originalSlot) {
        this.originalSlot = originalSlot;
    }
}

