/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackPredicate;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.power.PowerFormula;
import slimeknights.tconstruct.library.json.variable.power.PowerVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ConditionalStatTooltip;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ConditionalPowerModule(IJsonPredicate<LivingEntity> target, IJsonPredicate<LivingEntity> holder, PowerFormula formula, IntRange modifierLevel) implements ModifierModule,
ProjectileLaunchModifierHook.NoShooter,
ProjectileHitModifierHook,
ConditionalStatTooltip
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<ConditionalPowerModule> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("target", ConditionalPowerModule::target), (RecordField)LivingEntityPredicate.LOADER.defaultField("holder", ConditionalPowerModule::holder), (RecordField)PowerFormula.LOADER.directField(ConditionalPowerModule::formula), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", ConditionalPowerModule::modifierLevel), ConditionalPowerModule::new);
    private static final ResourceLocation AMMO_MULTIPLIER = ToolStats.PROJECTILE_DAMAGE.getName().m_266382_("_ammo_multiplier");
    private static final ResourceLocation BOW_MULTIPLIER = ToolStats.PROJECTILE_DAMAGE.getName().m_266382_("_bow_multiplier");

    @Override
    public boolean percent() {
        return this.formula.percent();
    }

    @Override
    @Nullable
    public Integer getPriority() {
        return this.percent() ? Integer.valueOf(75) : null;
    }

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onProjectileShoot(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity shooter, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        persistentData.putFloat(tool.hasTag(TinkerTags.Items.AMMO) ? AMMO_MULTIPLIER : BOW_MULTIPLIER, tool.getMultiplier(ToolStats.PROJECTILE_DAMAGE));
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        ModifierId key = modifier.getId();
        if (this.modifierLevel.test(modifier.getLevel()) && !persistentData.getBoolean(key)) {
            persistentData.putBoolean(key, true);
            if (TinkerPredicate.matches(this.target, target) && TinkerPredicate.matches(this.holder, attacker)) {
                float multiplier = 1.0f;
                if (persistentData.contains(AMMO_MULTIPLIER, 99)) {
                    multiplier *= persistentData.getFloat(AMMO_MULTIPLIER);
                }
                if (persistentData.contains(BOW_MULTIPLIER, 99)) {
                    multiplier *= persistentData.getFloat(BOW_MULTIPLIER);
                }
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)projectile;
                    arrow.m_36781_((double)this.formula.apply(modifiers, persistentData, modifier, projectile, hit, attacker, target, arrow.m_36789_(), multiplier));
                } else if (projectile instanceof ProjectileWithPower) {
                    ProjectileWithPower withPower = (ProjectileWithPower)projectile;
                    withPower.setPower(this.formula.apply(modifiers, persistentData, modifier, projectile, hit, attacker, target, withPower.getPower(), multiplier));
                }
            }
        }
        return false;
    }

    @Override
    public INumericToolStat<?> stat() {
        return ToolStats.PROJECTILE_DAMAGE;
    }

    @Override
    public ModifierCondition<IToolStackView> condition() {
        return new ModifierCondition<IToolStackView>(ToolStackPredicate.ANY, this.modifierLevel);
    }

    @Override
    public boolean matchesTool(IToolStackView tool, ModifierEntry entry) {
        return this.modifierLevel.test(entry.getLevel());
    }

    @Override
    public float computeTooltipValue(IToolStackView tool, ModifierEntry entry, @Nullable Player player) {
        return this.formula.apply(tool.getModifiers(), tool.getPersistentData(), entry, null, null, (LivingEntity)player, null, 1.0, tool.getMultiplier(ToolStats.PROJECTILE_DAMAGE));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ConditionalPowerModule, PowerVariable> {
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;

        private Builder() {
            super(PowerFormula.VARIABLES);
        }

        @Override
        protected ConditionalPowerModule build(ModifierFormula formula) {
            return new ConditionalPowerModule(this.target, this.holder, new PowerFormula(formula, this.variables, this.percent), this.condition.modifierLevel());
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }
    }
}

