/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.mantle.util.typed.TypedMapBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.UpdateModifiersPacket;
import slimeknights.tconstruct.library.modifiers.impl.ComposableModifier;
import slimeknights.tconstruct.library.utils.GenericTagUtil;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class ModifierManager
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierManager.class);
    public static final String FOLDER = "tinkering/modifiers";
    public static final String TAG_FOLDER = "tinkering/tags/modifiers";
    public static final ResourceLocation ENCHANTMENT_MAP = TConstruct.getResource("tinkering/enchantments_to_modifiers.json");
    public static final ResourceKey<? extends Registry<Modifier>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)TConstruct.getResource("modifiers"));
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ModifierId EMPTY = new ModifierId("tconstruct", "empty");
    public static final ModifierManager INSTANCE = new ModifierManager();
    private final Modifier defaultValue;
    private boolean modifiersRegistered = false;
    @VisibleForTesting
    final Map<ModifierId, Modifier> staticModifiers = new HashMap<ModifierId, Modifier>();
    private final Set<ModifierId> expectedDynamicModifiers = new HashSet<ModifierId>();
    private Map<ModifierId, Modifier> dynamicModifiers = Collections.emptyMap();
    private Map<TagKey<Modifier>, List<Modifier>> tags = Collections.emptyMap();
    private Map<ModifierId, Set<TagKey<Modifier>>> reverseTags = Collections.emptyMap();
    private Map<TagKey<Enchantment>, Modifier> enchantmentTagMap = Collections.emptyMap();
    private Map<Enchantment, Modifier> enchantmentMap = Collections.emptyMap();
    boolean dynamicModifiersLoaded = false;
    private ICondition.IContext conditionContext = ICondition.IContext.EMPTY;

    private ModifierManager() {
        super(GSON, FOLDER);
        this.defaultValue = new EmptyModifier();
        this.defaultValue.setId(EMPTY);
        this.staticModifiers.put(EMPTY, this.defaultValue);
    }

    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, e -> e.enqueueWork(this::fireRegistryEvent));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, this::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, OnDatapackSyncEvent.class, e -> JsonUtils.syncPackets(e, new ISimplePacket[]{new UpdateModifiersPacket(this.dynamicModifiers, this.tags, this.enchantmentMap, this.enchantmentTagMap)}));
    }

    private void fireRegistryEvent() {
        ModLoader.get().runEventGenerator(x$0 -> new ModifierRegistrationEvent((ModContainer)x$0));
        this.modifiersRegistered = true;
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
        this.conditionContext = event.getConditionContext();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        HashMap redirects = new HashMap();
        this.dynamicModifiers = splashList.entrySet().stream().map(entry -> this.loadModifier((ResourceLocation)entry.getKey(), (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), redirects)).filter(Objects::nonNull).collect(Collectors.toMap(Modifier::getId, mod -> mod));
        HashMap<ModifierId, Modifier> resolvedRedirects = new HashMap<ModifierId, Modifier>();
        for (Map.Entry entry2 : redirects.entrySet()) {
            ModifierId from = (ModifierId)((Object)entry2.getKey());
            ModifierId to = (ModifierId)((Object)entry2.getValue());
            if (!this.contains(to)) {
                log.error("Invalid modifier redirect {} as modifier {} does not exist", (Object)from, (Object)to);
                continue;
            }
            resolvedRedirects.put(from, this.get(to));
        }
        int modifierSize = this.dynamicModifiers.size();
        this.dynamicModifiers.putAll(resolvedRedirects);
        for (ModifierId id2 : this.expectedDynamicModifiers) {
            if (this.dynamicModifiers.containsKey((Object)id2)) continue;
            log.error("Missing expected modifier '{}'", (Object)id2);
        }
        for (ModifierId id2 : this.staticModifiers.keySet()) {
            if (!this.dynamicModifiers.containsKey((Object)id2)) continue;
            if (FMLLoader.isProduction()) {
                log.warn("Dynamic modifier {} is replacing static modifier with the same ID. The ability to do this may be removed in a future version, so if this is intentional please open an issue report with reasoning..", (Object)id2);
                continue;
            }
            log.error("Dynamic modifier {} is replacing static modifier with the same ID. This is likely a bug with your mod, but on the chance its intentional this error does become just a warning at runtime.", (Object)id2);
        }
        this.dynamicModifiersLoaded = true;
        long l = System.nanoTime();
        log.info("Loaded {} dynamic modifiers and {} modifier redirects in {} ms", (Object)modifierSize, (Object)redirects.size(), (Object)Float.valueOf((float)(l - time) / 1000000.0f));
        time = l;
        TagLoader tagLoader = new TagLoader(id -> {
            Modifier modifier = ModifierManager.getValue(new ModifierId((ResourceLocation)id));
            if (modifier == this.defaultValue) {
                return Optional.empty();
            }
            return Optional.of(modifier);
        }, TAG_FOLDER);
        this.tags = GenericTagUtil.mapLoaderResults(REGISTRY_KEY, tagLoader.m_203900_(pResourceManager));
        this.reverseTags = GenericTagUtil.reverseTags(Modifier::getId, this.tags);
        l = System.nanoTime();
        log.info("Loaded {} modifier tags for {} modifiers in {} ms", (Object)this.tags.size(), (Object)this.reverseTags.size(), (Object)Float.valueOf((float)(l - time) / 1000000.0f));
        this.enchantmentMap = new HashMap<Enchantment, Modifier>();
        this.enchantmentTagMap = new LinkedHashMap<TagKey<Enchantment>, Modifier>();
        for (Resource resource : pResourceManager.m_213829_(ENCHANTMENT_MAP)) {
            JsonObject enchantmentJson = JsonHelper.getJson((Resource)resource, (ResourceLocation)ENCHANTMENT_MAP);
            if (enchantmentJson == null) continue;
            for (Map.Entry entry2 : enchantmentJson.entrySet()) {
                try {
                    Enchantment enchantment;
                    ModifierId modifierId;
                    Modifier modifier;
                    boolean optional;
                    String key = (String)entry2.getKey();
                    String modifierStr = GsonHelper.m_13805_((JsonElement)((JsonElement)entry2.getValue()), (String)key);
                    boolean bl = optional = modifierStr.charAt(modifierStr.length() - 1) == '?';
                    if (optional) {
                        modifierStr = modifierStr.substring(0, modifierStr.length() - 1);
                    }
                    if ((modifier = this.get(modifierId = (ModifierId)((Object)ModifierId.PARSER.parseString(modifierStr, key)))) == this.defaultValue) {
                        if (optional) {
                            TConstruct.LOG.debug("Skipping unknown optional modifier " + modifierId + " for enchantment " + key);
                            continue;
                        }
                        throw new JsonSyntaxException("Unknown modifier " + modifierId + " for enchantment " + key);
                    }
                    if (key.charAt(0) == '#') {
                        ResourceLocation tagId = ResourceLocation.m_135820_((String)key.substring(1));
                        if (tagId == null) {
                            throw new JsonSyntaxException("Invalid enchantment tag ID " + key.substring(1));
                        }
                        this.enchantmentTagMap.put((TagKey<Enchantment>)TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)tagId), modifier);
                        continue;
                    }
                    boolean bl2 = optional = key.charAt(key.length() - 1) == '?';
                    if (optional) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if ((enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(key))) == null) {
                        if (optional) {
                            TConstruct.LOG.debug("Skipping modifier " + modifierId + " due to unknown optional enchantment " + key);
                            continue;
                        }
                        throw new JsonSyntaxException("Invalid enchantment ID " + key + " for modifier " + modifierId);
                    }
                    this.enchantmentMap.put(enchantment, modifier);
                }
                catch (RuntimeException e) {
                    log.info("Invalid enchantment to modifier mapping", (Throwable)e);
                }
            }
        }
        log.info("Loaded {} enchantment to modifier mappings in {} ms", (Object)(this.enchantmentMap.size() + this.enchantmentTagMap.size()), (Object)Float.valueOf((float)(System.nanoTime() - l) / 1000000.0f));
        MinecraftForge.EVENT_BUS.post((Event)new ModifiersLoadedEvent());
    }

    public static TypedMap createContext(ResourceLocation modifier) {
        return TypedMapBuilder.builder().put((TypedMap.Key)ContextKey.ID, (Object)modifier).put((TypedMap.Key)ContextKey.DEBUG, (Object)("Modifier " + modifier)).build();
    }

    @Nullable
    private Modifier loadModifier(ResourceLocation key, JsonElement element, Map<ModifierId, ModifierId> redirects) {
        try {
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"modifier");
            if (json.has("redirects")) {
                for (JsonRedirect redirect : JsonHelper.parseList((JsonObject)json, (String)"redirects", JsonRedirect::fromJson)) {
                    ICondition redirectCondition = redirect.getCondition();
                    if (redirectCondition != null && !redirectCondition.test(this.conditionContext)) continue;
                    ModifierId redirectTarget = new ModifierId(redirect.getId());
                    log.debug("Redirecting modifier {} to {}", (Object)key, (Object)redirectTarget);
                    redirects.put(new ModifierId(key), redirectTarget);
                    return null;
                }
            }
            if (json.has("condition") && !CraftingHelper.getCondition((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"condition")).test(this.conditionContext)) {
                return null;
            }
            Modifier modifier = (Modifier)ComposableModifier.LOADER.deserialize(json, ModifierManager.createContext(key));
            modifier.setId(new ModifierId(key));
            return modifier;
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load modifier {}", (Object)key, (Object)e);
            return null;
        }
    }

    void updateModifiersFromServer(Map<ModifierId, Modifier> modifiers, Map<TagKey<Modifier>, List<Modifier>> tags, Map<Enchantment, Modifier> enchantmentMap, Map<TagKey<Enchantment>, Modifier> enchantmentTagMappings) {
        this.dynamicModifiers = modifiers;
        this.dynamicModifiersLoaded = true;
        this.tags = tags;
        this.reverseTags = GenericTagUtil.reverseTags(Modifier::getId, tags);
        this.enchantmentMap = enchantmentMap;
        this.enchantmentTagMap = enchantmentTagMappings;
        MinecraftForge.EVENT_BUS.post((Event)new ModifiersLoadedEvent());
    }

    public Modifier getStatic(ModifierId id) {
        return this.staticModifiers.getOrDefault((Object)id, this.defaultValue);
    }

    public boolean containsStatic(ModifierId id) {
        return this.staticModifiers.containsKey((Object)id) || this.expectedDynamicModifiers.contains((Object)id);
    }

    public boolean contains(ModifierId id) {
        return this.staticModifiers.containsKey((Object)id) || this.dynamicModifiers.containsKey((Object)id);
    }

    public Modifier get(ModifierId id) {
        Modifier modifier = this.staticModifiers.get((Object)id);
        if (modifier != null) {
            return modifier;
        }
        return this.dynamicModifiers.getOrDefault((Object)id, this.defaultValue);
    }

    @Nullable
    public Modifier get(Enchantment enchantment) {
        if (this.enchantmentMap.containsKey(enchantment)) {
            return this.enchantmentMap.get(enchantment);
        }
        for (Map.Entry<TagKey<Enchantment>, Modifier> mapping : this.enchantmentTagMap.entrySet()) {
            if (!RegistryHelper.contains((Registry)BuiltInRegistries.f_256876_, mapping.getKey(), (Object)enchantment)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public boolean hasEnchantment(Modifier modifier) {
        return this.enchantmentMap.containsValue(modifier) || this.enchantmentTagMap.containsValue(modifier);
    }

    public Stream<Enchantment> getEquivalentEnchantments(Predicate<ModifierId> modifiers) {
        Predicate<Map.Entry> predicate = entry -> modifiers.test(((Modifier)entry.getValue()).getId());
        return Stream.concat(this.enchantmentMap.entrySet().stream().filter(predicate).map(Map.Entry::getKey), this.enchantmentTagMap.entrySet().stream().filter(predicate).flatMap(entry -> RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_256876_, (TagKey)((TagKey)entry.getKey())))).distinct().sorted(Comparator.comparing(enchantment -> Objects.requireNonNull(BuiltInRegistries.f_256876_.m_7981_(enchantment))));
    }

    public Stream<ResourceLocation> getAllLocations() {
        return Stream.concat(this.staticModifiers.entrySet().stream(), this.dynamicModifiers.entrySet().stream()).filter(entry -> ((ModifierId)((Object)((Object)entry.getKey()))).equals((Object)((Modifier)entry.getValue()).getId())).map(Map.Entry::getKey);
    }

    public Stream<Modifier> getAllValues() {
        return Stream.concat(this.staticModifiers.values().stream(), this.dynamicModifiers.values().stream()).distinct();
    }

    public static Modifier getValue(ModifierId name) {
        return INSTANCE.get(name);
    }

    public static TagKey<Modifier> getTag(ResourceLocation id) {
        return TagKey.m_203882_(REGISTRY_KEY, (ResourceLocation)id);
    }

    public static Stream<TagKey<Modifier>> getTagKeys(ModifierId modifier) {
        return ModifierManager.INSTANCE.reverseTags.getOrDefault((Object)modifier, Set.of()).stream();
    }

    public static boolean isInTag(ModifierId modifier, TagKey<Modifier> tag) {
        return ModifierManager.INSTANCE.reverseTags.getOrDefault((Object)modifier, Set.of()).contains(tag);
    }

    @Nullable
    public static List<Modifier> getTagOrNull(TagKey<Modifier> tag) {
        return ModifierManager.INSTANCE.tags.get(tag);
    }

    public static List<Modifier> getTagValues(TagKey<Modifier> tag) {
        return ModifierManager.INSTANCE.tags.getOrDefault(tag, List.of());
    }

    public static Stream<Map.Entry<TagKey<Modifier>, List<Modifier>>> getAllTags() {
        return ModifierManager.INSTANCE.tags.entrySet().stream();
    }

    public Modifier getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isModifiersRegistered() {
        return this.modifiersRegistered;
    }

    public boolean isDynamicModifiersLoaded() {
        return this.dynamicModifiersLoaded;
    }

    private static class EmptyModifier
    extends Modifier {
        private EmptyModifier() {
        }

        @Override
        public boolean shouldDisplay(boolean advanced) {
            return false;
        }
    }

    public static class ModifiersLoadedEvent
    extends Event {
    }

    public class ModifierRegistrationEvent
    extends Event
    implements IModBusEvent {
        private final ModContainer container;

        private void checkModNamespace(ResourceLocation name) {
            String activeMod = this.container.getNamespace();
            if (!name.m_135827_().equals(activeMod)) {
                TConstruct.LOG.warn("Potentially Dangerous alternative prefix for name `{}`, expected `{}`. This could be a intended override, but in most cases indicates a broken mod.", (Object)name, (Object)activeMod);
            }
        }

        public void registerStatic(ModifierId name, Modifier modifier) {
            this.checkModNamespace(name);
            if (ModifierManager.this.expectedDynamicModifiers.contains((Object)name)) {
                throw new IllegalArgumentException(name + " is already expected as a dynamic modifier");
            }
            modifier.setId(name);
            Modifier existing = ModifierManager.this.staticModifiers.putIfAbsent(name, modifier);
            if (existing != null) {
                throw new IllegalArgumentException("Attempting to register a duplicate static modifier, this is not supported. Original value " + existing);
            }
        }

        public void registerExpected(ModifierId name) {
            this.checkModNamespace(name);
            if (ModifierManager.this.staticModifiers.containsKey((Object)name)) {
                throw new IllegalArgumentException(name + " is already registered as a static modifier");
            }
            ModifierManager.this.expectedDynamicModifiers.add(name);
        }

        protected ModifierRegistrationEvent(ModContainer container) {
            this.container = container;
        }
    }
}

