/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import slimeknights.mantle.data.loadable.LegacyLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;

public abstract class RandomMaterial
implements GenericLoaderRegistry.IHaveLoader {
    public static final GenericLoaderRegistry<RandomMaterial> LOADER = new GenericLoaderRegistry("Random Material", false);
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        LOADER.register(TConstruct.getResource("fixed"), Fixed.LOADER);
        LOADER.register(TConstruct.getResource("first"), First.LOADER);
        LOADER.register(TConstruct.getResource("random"), Randomized.LOADER);
        LOADER.register(TConstruct.getResource("random_variant"), RandomVariant.LOADER);
        LOADER.register(TConstruct.getResource("ancient"), Randomized.ANCIENT.getLoader());
    }

    public static RandomMaterial fixed(MaterialVariantId materialId) {
        return new Fixed(materialId);
    }

    public static RandomMaterial firstWithStat() {
        return First.INSTANCE;
    }

    public static RandomBuilder random() {
        return new RandomBuilder();
    }

    public static RandomMaterial randomVariant(IJsonPredicate<MaterialVariantId> materials) {
        return new RandomVariant(materials);
    }

    public static RandomMaterial ancient() {
        return Randomized.ANCIENT;
    }

    public abstract MaterialVariantId getMaterial(MaterialStatsId var1, RandomSource var2);

    public abstract RecordLoadable<? extends RandomMaterial> getLoader();

    public void clearCache() {
    }

    public static MaterialNBT build(List<MaterialStatsId> statTypes, List<RandomMaterial> materials, RandomSource random) {
        int i;
        MaterialNBT.Builder builder = MaterialNBT.builder();
        int max = Math.min(materials.size(), statTypes.size());
        for (i = 0; i < max; ++i) {
            builder.add(materials.get(i).getMaterial(statTypes.get(i), random));
        }
        for (i = max; i < statTypes.size(); ++i) {
            builder.add(MaterialRegistry.firstWithStatType(statTypes.get(i)));
        }
        return builder.build();
    }

    private static class Fixed
    extends RandomMaterial {
        private static final RecordLoadable<Fixed> LOADER = RecordLoadable.create((RecordField)MaterialVariantId.LOADABLE.requiredField("material", r -> r.material), Fixed::new);
        private final MaterialVariantId material;

        @Override
        public MaterialVariantId getMaterial(MaterialStatsId statType, RandomSource random) {
            return this.material;
        }

        public RecordLoadable<Fixed> getLoader() {
            return LOADER;
        }

        public Fixed(MaterialVariantId material) {
            this.material = material;
        }
    }

    private static class First
    extends RandomMaterial {
        private static final First INSTANCE = new First();
        public static final SingletonLoader<First> LOADER = new SingletonLoader((Object)INSTANCE);

        @Override
        public MaterialVariantId getMaterial(MaterialStatsId statType, RandomSource random) {
            return MaterialRegistry.firstWithStatType(statType).getIdentifier();
        }

        public SingletonLoader<First> getLoader() {
            return LOADER;
        }

        private First() {
        }
    }

    private static class Randomized
    extends RandomMaterial
    implements Function<MaterialStatsId, List<MaterialId>> {
        public static final IntRange TIER_RANGE = new IntRange(0, Integer.MAX_VALUE);
        public static final RecordLoadable<Randomized> LOADER = new LegacyLoadable<Randomized>(RecordLoadable.create(TIER_RANGE.defaultField("tier", r -> r.tier), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_hidden", (Object)false, false, r -> r.allowHidden), (RecordField)MaterialPredicate.LOADER.defaultField("material", r -> r.material), Randomized::new)){

            public Randomized deserialize(JsonObject json, TypedMap context) {
                if (json.has("tag")) {
                    Object debug = (String)context.get((TypedMap.Key)ContextKey.DEBUG);
                    debug = debug != null ? " while parsing " + (String)debug : "";
                    TConstruct.LOG.warn("Using deprecated randomized material key 'tag' in {}, use 'material' instead", debug);
                    IntRange tier = TIER_RANGE.getOrDefault(json, "tier");
                    boolean allowHidden = GsonHelper.m_13855_((JsonObject)json, (String)"allow_hidden", (boolean)false);
                    TagKey tag = (TagKey)TinkerLoadables.MATERIAL_TAGS.getIfPresent(json, "tag");
                    return new Randomized(tier, allowHidden, MaterialPredicate.tag((TagKey<IMaterial>)tag));
                }
                return (Randomized)this.base.deserialize(json, context);
            }
        };
        private final IntRange tier;
        private final boolean allowHidden;
        private final IJsonPredicate<MaterialVariantId> material;
        private final Map<MaterialStatsId, List<MaterialId>> materialChoices = new ConcurrentHashMap<MaterialStatsId, List<MaterialId>>();
        public static final RandomMaterial ANCIENT = (RandomMaterial)SingletonLoader.singleton(loader -> new Randomized(TIER_RANGE, true, MaterialPredicate.tag(TinkerTags.Materials.EXCLUDE_FROM_LOOT).inverted(), (RecordLoadable)loader){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
                super(tier, allowHidden, (IJsonPredicate<MaterialVariantId>)material);
            }

            @Override
            public RecordLoadable<? extends RandomMaterial> getLoader() {
                return this.val$loader;
            }
        });

        @Override
        public List<MaterialId> apply(MaterialStatsId statType) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            List<MaterialId> choices = MaterialRegistry.getInstance().getAllMaterials().stream().filter(material -> {
                MaterialId id = material.getIdentifier();
                return this.tier.test(material.getTier()) && (this.allowHidden || !material.isHidden()) && this.material.matches((Object)material.getIdentifier()) && registry.getMaterialStats(id, statType).isPresent();
            }).map(IMaterial::getIdentifier).toList();
            if (choices.isEmpty()) {
                TConstruct.LOG.warn("Random material found no options for statType={}, tier={}, allowHidden={}, predicate={}", (Object)statType, (Object)this.tier, (Object)this.allowHidden, this.material);
            }
            return choices;
        }

        @Override
        public void clearCache() {
            this.materialChoices.clear();
        }

        @Override
        public MaterialId getMaterial(MaterialStatsId statType, RandomSource random) {
            List<MaterialId> materialChoices = this.materialChoices.computeIfAbsent(statType, this);
            if (materialChoices.isEmpty()) {
                return MaterialRegistry.firstWithStatType(statType).getIdentifier();
            }
            return materialChoices.get(random.m_188503_(materialChoices.size()));
        }

        @Override
        public RecordLoadable<? extends RandomMaterial> getLoader() {
            return LOADER;
        }

        public Randomized(IntRange tier, boolean allowHidden, IJsonPredicate<MaterialVariantId> material) {
            this.tier = tier;
            this.allowHidden = allowHidden;
            this.material = material;
        }
    }

    private static class RandomVariant
    extends RandomMaterial
    implements Function<MaterialStatsId, List<List<MaterialVariantId>>> {
        public static final RecordLoadable<RandomVariant> LOADER = RecordLoadable.create((RecordField)MaterialPredicate.LOADER.defaultField("material", r -> r.material), RandomVariant::new);
        private final IJsonPredicate<MaterialVariantId> material;
        private final Map<MaterialStatsId, List<List<MaterialVariantId>>> materialChoices = new ConcurrentHashMap<MaterialStatsId, List<List<MaterialVariantId>>>();

        @Override
        public List<List<MaterialVariantId>> apply(MaterialStatsId statType) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            List<List<MaterialVariantId>> choices = MaterialRegistry.getInstance().getAllMaterials().stream().map(material -> {
                MaterialId id = material.getIdentifier();
                if (registry.getMaterialStats(id, statType).isEmpty()) {
                    return List.of();
                }
                return MaterialRecipeCache.getVariants(material.getIdentifier()).stream().filter(arg_0 -> this.material.matches(arg_0)).toList();
            }).filter(list -> !list.isEmpty()).toList();
            if (choices.isEmpty()) {
                TConstruct.LOG.warn("Random variant found no options for statType={}, predicate={}", (Object)statType, this.material);
            }
            return choices;
        }

        @Override
        public void clearCache() {
            this.materialChoices.clear();
        }

        @Override
        public MaterialVariantId getMaterial(MaterialStatsId statType, RandomSource random) {
            List<List<MaterialVariantId>> materialChoices = this.materialChoices.computeIfAbsent(statType, this);
            if (materialChoices.isEmpty()) {
                return MaterialRegistry.firstWithStatType(statType).getIdentifier();
            }
            List<MaterialVariantId> variantChoices = materialChoices.get(random.m_188503_(materialChoices.size()));
            return variantChoices.get(random.m_188503_(variantChoices.size()));
        }

        public RecordLoadable<RandomVariant> getLoader() {
            return LOADER;
        }

        public RandomVariant(IJsonPredicate<MaterialVariantId> material) {
            this.material = material;
        }
    }

    public static class RandomBuilder {
        private IntRange tier = Randomized.TIER_RANGE;
        private boolean allowHidden = false;
        private IJsonPredicate<MaterialVariantId> material = MaterialPredicate.ANY;

        public RandomBuilder tier(int tier) {
            this.tier = Randomized.TIER_RANGE.exactly(tier);
            return this;
        }

        public RandomBuilder tier(int min, int max) {
            this.tier = Randomized.TIER_RANGE.range(min, max);
            return this;
        }

        public RandomBuilder minTier(int min) {
            this.tier = Randomized.TIER_RANGE.min(min);
            return this;
        }

        public RandomBuilder maxTier(int max) {
            this.tier = Randomized.TIER_RANGE.max(max);
            return this;
        }

        public RandomBuilder allowHidden() {
            this.allowHidden = true;
            return this;
        }

        public RandomBuilder tag(TagKey<IMaterial> tag) {
            this.material = MaterialPredicate.tag(tag);
            return this;
        }

        public RandomMaterial build() {
            return new Randomized(this.tier, this.allowHidden, this.material);
        }

        private RandomBuilder() {
        }

        public RandomBuilder material(IJsonPredicate<MaterialVariantId> material) {
            this.material = material;
            return this;
        }
    }
}

