/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class AmmoMaterialContent
extends AbstractMaterialContent {
    public static final ResourceLocation ID = TConstruct.getResource("ammo_material");

    public AmmoMaterialContent(MaterialVariantId materialVariant, boolean detailed) {
        super(materialVariant, detailed);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    protected MaterialStatsId getStatType(int index) {
        return switch (index) {
            case 0 -> StatlessMaterialStats.ARROW_HEAD.getIdentifier();
            case 1 -> StatlessMaterialStats.ARROW_SHAFT.getIdentifier();
            default -> null;
        };
    }

    @Override
    protected int getStatRows() {
        return 1;
    }

    @Override
    protected String getTextKey(MaterialId material) {
        if (this.detailed) {
            String primaryKey = String.format("material.%s.%s.ammo", material.m_135827_(), material.m_135815_());
            if (Util.canTranslate(primaryKey)) {
                return primaryKey;
            }
            return String.format("material.%s.%s.encyclopedia", material.m_135827_(), material.m_135815_());
        }
        return String.format("material.%s.%s.flavor", material.m_135827_(), material.m_135815_());
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)StatlessMaterialStats.ARROW_HEAD.getIdentifier()) || statsId.equals((Object)StatlessMaterialStats.ARROW_SHAFT.getIdentifier());
    }
}

