/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import javax.annotation.Nullable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface CapacitySourceModule {
    public static final LoadableField<ModifierId, CapacitySourceModule> OWNER_FIELD = ModifierId.PARSER.nullableField("owner", CapacitySourceModule::owner);

    @Nullable
    public ModifierId owner();

    default public ModifierEntry barModifier(IToolStackView tool, ModifierEntry entry) {
        ModifierId owner = this.owner();
        if (owner != null) {
            return tool.getModifier(owner);
        }
        return entry;
    }

    public static void apply(IToolStackView tool, ModifierEntry modifier, int amount, int grant) {
        CapacityBarHook bar = modifier.getHook(ModifierHooks.CAPACITY_BAR);
        if (grant == 0) {
            bar.setAmount(tool, modifier, 0);
        } else if (grant > 0) {
            bar.addAmount(tool, modifier, amount * grant);
        } else {
            bar.removeAmount(tool, modifier, -amount * grant);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends ModuleBuilder.Stack<B> {
        @Nullable
        protected ModifierId owner = null;

        public Builder<B> owner(@Nullable ModifierId owner) {
            this.owner = owner;
            return this;
        }
    }
}

