/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.SimpleFinishedRecipe;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.modifier.SlotTypeModifierPredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.ingredient.NoContainerIngredient;
import slimeknights.tconstruct.library.recipe.ingredient.ToolHookIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.OverslimeModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.recipe.EnchantmentConvertingRecipeBuilder;
import slimeknights.tconstruct.tools.recipe.ModifierRemovalRecipeBuilder;
import slimeknights.tconstruct.tools.recipe.ModifierSortingRecipeBuilder;
import slimeknights.tconstruct.tools.recipe.ToggleInteractionWorktableRecipeBuilder;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;

public class ModifierRecipeProvider
extends BaseRecipeProvider {
    public ModifierRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Modifier Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addItemRecipes(consumer);
        this.addModifierRecipes(consumer);
        this.addTextureRecipes(consumer);
        this.addHeadRecipes(consumer);
    }

    private void addItemRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/modifiers/";
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.emeraldReinforcement).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenEmerald, 25).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.emeraldReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.slimesteelReinforcement).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenSlimesteel, 30).setCast((ItemLike)TinkerCommons.obsidianPane, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.slimesteelReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.ironReinforcement).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenIron, 90).setCast((ItemLike)TinkerTables.pattern, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.ironReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.searedReinforcement).setFluid(FluidIngredient.of((FluidIngredient[])new FluidIngredient[]{TinkerFluids.searedStone.ingredient(250), TinkerFluids.scorchedStone.ingredient(250)})).setCoolingTime(IMeltingRecipe.getTemperature(TinkerFluids.searedStone), 250).setCast((ItemLike)TinkerTables.pattern, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.searedReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.goldReinforcement).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenGold, 90).setCast((ItemLike)TinkerTables.pattern, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.goldReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.obsidianReinforcement).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenObsidian, 1000).setCast((ItemLike)TinkerTables.pattern, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.obsidianReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.cobaltReinforcement).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenCobalt, 90).setCast((ItemLike)TinkerTables.pattern, true).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.cobaltReinforcement, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.jeweledApple).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenDiamond, 200).setCast((ItemLike)Items.f_42410_, true).save(consumer, this.prefix((IdAwareObject)TinkerCommons.jeweledApple, folder));
        ItemCastingRecipeBuilder.tableRecipe(TinkerModifiers.silkyCloth).setCast((ItemLike)Items.f_41863_, true).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenRoseGold, 90).save(consumer, this.prefix((IdAwareObject)TinkerModifiers.silkyCloth, folder));
        ModifierRepairRecipeBuilder.repair(TinkerModifiers.tasty, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.bacon}), 25).save(consumer, this.prefix(TinkerModifiers.tasty, folder));
    }

    private void addModifierRecipes(Consumer<FinishedRecipe> consumer) {
        String upgradeFolder = "tools/modifiers/upgrade/";
        String abilityFolder = "tools/modifiers/ability/";
        String slotlessFolder = "tools/modifiers/slotless/";
        String defenseFolder = "tools/modifiers/defense/";
        String compatFolder = "tools/modifiers/compat/";
        String worktableFolder = "tools/modifiers/worktable/";
        String salvageFolder = "tools/modifiers/salvage/";
        String upgradeSalvage = salvageFolder + "upgrade/";
        String abilitySalvage = salvageFolder + "ability/";
        String defenseSalvage = salvageFolder + "defense/";
        String compatSalvage = salvageFolder + "compat/";
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.reinforced).setInput((ItemLike)TinkerModifiers.emeraldReinforcement, 1, 4).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.DURABILITY))).saveSalvage(consumer, this.prefix(ModifierIds.reinforced, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.reinforced, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.overforced).setInput((ItemLike)TinkerModifiers.slimesteelReinforcement, 1, 4).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.DURABILITY))).saveSalvage(consumer, this.prefix(ModifierIds.overforced, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.overforced, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.emerald).setTools(TinkerTags.Items.DURABILITY))).addInput((TagKey<Item>)Tags.Items.GEMS_EMERALD).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.emerald, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.emerald, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.diamond).setTools(TinkerTags.Items.DURABILITY))).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.diamond, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.diamond, upgradeFolder));
        DifferenceIngredient multiuse = DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(TinkerTags.Items.MODIFIABLE), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.SINGLE_USE));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.worldbound).setTools((Ingredient)multiuse))).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.worldbound, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.worldbound).setTools(TinkerTags.Items.SINGLE_USE))).addInput(TinkerTags.Items.NUGGETS_NETHERITE_SCRAP).setMaxLevel(1))).save(consumer, this.wrap(ModifierIds.worldbound, slotlessFolder, "_ammo"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.soulbound).setTools((Ingredient)multiuse))).addInput((ItemLike)Items.f_220224_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(1))).saveSalvage(consumer, this.prefix(ModifierIds.soulbound, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.soulbound, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.soulbound).setTools(TinkerTags.Items.SINGLE_USE))).addInput((ItemLike)Items.f_42735_).setMaxLevel(1))).save(consumer, this.wrap(ModifierIds.soulbound, slotlessFolder, "_ammo"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.netherite).setTools(TinkerTags.Items.DURABILITY))).addInput((ItemLike)Items.f_265918_).addInput((TagKey<Item>)Tags.Items.INGOTS_NETHERITE).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.netherite, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.netherite, upgradeFolder));
        block6: for (SlimeType type2 : SlimeType.values()) {
            int amount;
            Ingredient tool = Ingredient.m_204132_(TinkerTags.Items.DURABILITY);
            switch (type2) {
                case EARTH: {
                    amount = 20;
                    break;
                }
                case SKY: {
                    amount = 50;
                    break;
                }
                case ICHOR: {
                    amount = 100;
                    break;
                }
                case ENDER: {
                    amount = 80;
                    tool = DifferenceIngredient.of((Ingredient)tool, (Ingredient)Ingredient.m_43929_((ItemLike[])((ItemLike[])TinkerTools.slimesuit.values().toArray(Item[]::new))));
                    break;
                }
                default: {
                    continue block6;
                }
            }
            String name = type2.m_7912_();
            OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerCommons.slimeball.get((Enum)type2), amount).setTools(tool).save(consumer, this.location(slotlessFolder + "overslime/" + name + "_ball"));
            OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerFluids.slimeBottle.get((Enum)type2), amount).saveCrafting(consumer, this.location(slotlessFolder + "overslime/" + name + "_bottle_crafting_table")).save(consumer, this.location(slotlessFolder + "overslime/" + name + "_bottle"));
            OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.congealedSlime.get((Enum)type2), amount * 4).setTools(tool).save(consumer, this.location(slotlessFolder + "overslime/" + name + "_congealed"));
            OverslimeModifierRecipeBuilder.modifier((ItemLike)TinkerWorld.slime.get((Enum)type2), amount * 9).setTools(tool).save(consumer, this.location(slotlessFolder + "overslime/" + name + "_block"));
        }
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.experienced).addInput((ItemLike)Items.f_42612_).addInput((ItemLike)Items.f_42612_).addInput((ItemLike)Items.f_42612_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.LAUNCHERS, TinkerTags.Items.LEGGINGS)))).saveSalvage(consumer, this.prefix(ModifierIds.experienced, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.experienced, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.magnetic).addInput((ItemLike)Items.f_42522_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.HARVEST)))).save(consumer, this.prefix(TinkerModifiers.magnetic, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.magnetic).addInput((ItemLike)Items.f_42522_).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.WORN_ARMOR))).save(consumer, this.wrap(TinkerModifiers.magnetic, upgradeFolder, "_armor"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.magnetic).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.HARVEST, TinkerTags.Items.WORN_ARMOR)))).saveSalvage(consumer, this.prefix(TinkerModifiers.magnetic, upgradeSalvage));
        ((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.shiny).addInput((ItemLike)Items.f_42437_).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.shiny, slotlessFolder));
        Ingredient sighted = ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELD, TinkerTags.Items.ARMOR);
        ((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.farsighted).setTools(sighted))).setInput((TagKey<Item>)Tags.Items.CROPS_CARROT, 1, 45).save(consumer, this.prefix(TinkerModifiers.farsighted, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.nearsighted).setTools(sighted))).setInput((ItemLike)Items.f_42532_, 1, 45).save(consumer, this.prefix(TinkerModifiers.nearsighted, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.offhanded).setTools(TinkerTags.Items.INTERACTABLE_RIGHT))).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42613_).addInput(SlimeType.ICHOR.getSlimeballTag()).setMaxLevel(2))).save(consumer, this.prefix(ModifierIds.offhanded, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.smelting).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.INTERACTABLE, TinkerTags.Items.WORN_ARMOR)))).addInput((ItemLike)Blocks.f_50683_).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.smelting, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.smelting, upgradeFolder));
        this.hasteRecipes(consumer, ModifierIds.haste, ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST, TinkerTags.Items.CHESTPLATES), 5, upgradeFolder, upgradeSalvage);
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.blasting).setTools(TinkerTags.Items.STONE_HARVEST))).setInput((TagKey<Item>)Tags.Items.GUNPOWDER, 1, 20).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.blasting, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.blasting, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.hydraulic).setTools(TinkerTags.Items.HARVEST))).setInput((TagKey<Item>)Tags.Items.DUSTS_PRISMARINE, 1, 36).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.hydraulic, upgradeSalvage)))).save(consumer, this.wrap(ModifierIds.hydraulic, upgradeFolder, "_from_shard"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.hydraulic).setTools(TinkerTags.Items.HARVEST))).setInput((ItemLike)Blocks.f_50377_, 4, 36).setLeftover((ItemLike)Items.f_42695_).setMaxLevel(5))).disallowCrystal())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.hydraulic, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.hydraulic).setTools(TinkerTags.Items.HARVEST))).setInput((ItemLike)Blocks.f_50378_, 9, 36).setLeftover((ItemLike)Items.f_42695_).setMaxLevel(5))).disallowCrystal())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.hydraulic, upgradeFolder, "_from_bricks"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.lightspeed).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST, TinkerTags.Items.BOOTS)))).setInput((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, 1, 64).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.lightspeed, upgradeSalvage)))).save(consumer, this.wrap(ModifierIds.lightspeed, upgradeFolder, "_from_dust"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.lightspeed).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST, TinkerTags.Items.BOOTS)))).setInput((ItemLike)Blocks.f_50141_, 4, 64).setLeftover((ItemLike)Items.f_42525_).setMaxLevel(5))).disallowCrystal())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.lightspeed, upgradeFolder, "_from_block"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.knockback).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.EARTH)).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.CHESTPLATES)))).saveSalvage(consumer, this.prefix(TinkerModifiers.knockback, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.knockback, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.padded).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)ItemTags.f_13167_).addInput((ItemLike)Items.f_42454_).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE))).saveSalvage(consumer, this.prefix(TinkerModifiers.padded, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.padded, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.severing).addInput(TinkerTags.Items.WITHER_BONES).addInput((ItemLike)Items.f_151041_).addInput(TinkerTags.Items.WITHER_BONES).addInput((ItemLike)Items.f_41996_).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.LAUNCHERS)))).saveSalvage(consumer, this.prefix(TinkerModifiers.severing, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.severing, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.fiery).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.BOWS, TinkerTags.Items.FISHING_RODS, TinkerTags.Items.WORN_ARMOR, TinkerTags.Items.SHIELDS)))).setInput((ItemLike)Items.f_42593_, 1, 25).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.fiery, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.fiery, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.necrotic).addInput((ItemLike)TinkerMaterials.necroticBone).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).addInput((ItemLike)Items.f_42586_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.BOWS, TinkerTags.Items.FISHING_RODS)))).saveSalvage(consumer, this.prefix(TinkerModifiers.necrotic, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.necrotic, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.pierce).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.LAUNCHERS)))).setInput((ItemLike)TinkerGadgets.punji, 1, 10).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.pierce, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.pierce, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.piercing).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.BOWS)))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.piercing, upgradeSalvage));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.smite).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42546_, 1, 5).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.smite, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.smite, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.baneOfSssss).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42592_, 1, 15).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.baneOfSssss, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.baneOfSssss, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.antiaquatic).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42529_, 1, 5).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.antiaquatic, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.antiaquatic, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.cooling).setTools(TinkerTags.Items.MELEE))).setInput((ItemLike)Items.f_42696_, 1, 25).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.cooling, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.cooling, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.killager).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.GEMS_LAPIS, 1, 45).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.killager, upgradeSalvage)))).save(consumer, this.wrap(ModifierIds.killager, upgradeFolder, "_from_dust"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.killager).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, 9, 45).setMaxLevel(5))).disallowCrystal())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.killager, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.sharpness).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.GEMS_QUARTZ, 1, 36).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.sharpness, upgradeSalvage)))).save(consumer, this.wrap(ModifierIds.sharpness, upgradeFolder, "_from_shard"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.sharpness).setTools(TinkerTags.Items.MELEE))).setInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_QUARTZ, 4, 36).setLeftover(new ItemStack((ItemLike)Items.f_42692_)).setMaxLevel(5))).disallowCrystal())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.sharpness, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(TinkerModifiers.sweeping).setTools(TinkerTags.Items.SWORD))).setInput((ItemLike)Blocks.f_50184_, 1, 5).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.sweeping, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.sweeping, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.swiftstrike).setTools(TinkerTags.Items.MELEE_WEAPON))).setInput((ItemLike)Items.f_151049_, 1, 72).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.swiftstrike, upgradeSalvage)))).save(consumer, this.wrap(ModifierIds.swiftstrike, upgradeFolder, "_from_shard"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.swiftstrike).setTools(TinkerTags.Items.MELEE_WEAPON))).setInput((ItemLike)Blocks.f_152490_, 4, 72).setLeftover(new ItemStack((ItemLike)Items.f_151049_)).setMaxLevel(5))).disallowCrystal())).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.wrap(ModifierIds.swiftstrike, upgradeFolder, "_from_block"));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.power).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.LONGBOWS, TinkerTags.Items.STAFFS, TinkerTags.Items.FISHING_RODS)))).setInput((ItemLike)TinkerWorld.ichorGeode.m_5456_(), 1, 72).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(5))).saveSalvage(consumer, this.prefix(ModifierIds.power, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.power, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.underbowed).setTools(TinkerTags.Items.LAUNCHERS))).setInput((TagKey<Item>)ItemTags.f_13167_, 1, 10).save(consumer, this.prefix(ModifierIds.underbowed, slotlessFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.quickCharge).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.CROSSBOWS, TinkerTags.Items.STAFFS, TinkerTags.Items.FISHING_RODS)))).setInput((ItemLike)Items.f_42542_, 1, 5).setMaxLevel(4))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.quickCharge, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.quickCharge, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.trueshot).setInput((ItemLike)Items.f_42793_, 1, 10).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).setTools(TinkerTags.Items.RANGED))).saveSalvage(consumer, this.prefix(ModifierIds.trueshot, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.trueshot, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.blindshot).setInput((ItemLike)Items.f_42329_, 1, 10).setTools(TinkerTags.Items.RANGED))).save(consumer, this.prefix(ModifierIds.blindshot, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.punch).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.LAUNCHERS))).saveSalvage(consumer, this.prefix(ModifierIds.punch, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.punch, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.arrowPierce).addInput((ItemLike)Items.f_151087_).addInput((ItemLike)Items.f_151087_).addInput((ItemLike)Items.f_151087_).setMaxLevel(4))).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.BOWS))).saveSalvage(consumer, this.prefix(ModifierIds.arrowPierce, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.arrowPierce, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.freezing).addInput((ItemLike)Items.f_151055_).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.BOWS, TinkerTags.Items.FISHING_RODS, TinkerTags.Items.WORN_ARMOR, TinkerTags.Items.SHIELDS)))).saveSalvage(consumer, this.prefix(ModifierIds.freezing, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.freezing, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.bulkQuiver).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)TinkerWorld.skySlimeVine).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)TinkerWorld.skySlimeVine).addInput((ItemLike)TinkerWorld.skySlimeVine).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.BOWS))).saveSalvage(consumer, this.prefix(ModifierIds.bulkQuiver, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.bulkQuiver, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.trickQuiver).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerWorld.skySlimeVine).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerWorld.skySlimeVine).addInput((ItemLike)TinkerWorld.skySlimeVine).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.BOWS))).saveSalvage(consumer, this.prefix(ModifierIds.trickQuiver, abilitySalvage)))).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.BOWS), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE)})))).save(consumer, this.prefix(ModifierIds.trickQuiver, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.ballista).addInput((TagKey<Item>)TinkerMaterials.hepatizon.getIngotTag()).addInput((ItemLike)Items.f_42026_).addInput((TagKey<Item>)TinkerMaterials.hepatizon.getIngotTag()).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).setTools(TinkerTags.Items.BALLISTAS))).saveSalvage(consumer, this.prefix(ModifierIds.ballista, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.ballista, abilityFolder));
        BiConsumer<ItemLike, String> crystalshotRecipe = (item, variant) -> ((ModifierRecipeBuilder)((Object)((Object)((Object)((ModifierRecipeBuilder)((Object)((Object)((Object)SwappableModifierRecipeBuilder.modifier(ModifierIds.crystalshot, variant).addInput((ItemLike)item).addInput((ItemLike)Items.f_42585_).addInput((ItemLike)item).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).setTools(TinkerTags.Items.BOWS))))).setSlots(SlotType.ABILITY, 1))))).save(consumer, this.wrap(ModifierIds.crystalshot, abilityFolder, "_" + variant));
        crystalshotRecipe.accept((ItemLike)Items.f_151086_, "amethyst");
        crystalshotRecipe.accept((ItemLike)TinkerWorld.earthGeode.getBud(GeodeItemObject.BudSize.CLUSTER), "earthslime");
        crystalshotRecipe.accept((ItemLike)TinkerWorld.skyGeode.getBud(GeodeItemObject.BudSize.CLUSTER), "skyslime");
        crystalshotRecipe.accept((ItemLike)TinkerWorld.ichorGeode.getBud(GeodeItemObject.BudSize.CLUSTER), "ichor");
        crystalshotRecipe.accept((ItemLike)TinkerWorld.enderGeode.getBud(GeodeItemObject.BudSize.CLUSTER), "enderslime");
        crystalshotRecipe.accept((ItemLike)Items.f_42154_, "quartz");
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(ModifierIds.crystalshot, "random").addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.earthGeode.getBud(GeodeItemObject.BudSize.CLUSTER), TinkerWorld.skyGeode.getBud(GeodeItemObject.BudSize.CLUSTER)})).addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151086_, Items.f_42154_})).addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.ichorGeode.getBud(GeodeItemObject.BudSize.CLUSTER), TinkerWorld.enderGeode.getBud(GeodeItemObject.BudSize.CLUSTER)})).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getIngotTag()).setTools(TinkerTags.Items.BOWS))).setSlots(SlotType.ABILITY, 1))).allowCrystal())).save(consumer, this.wrap(ModifierIds.crystalshot, abilityFolder, "_random"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.crystalshot).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.BOWS))).saveSalvage(consumer, this.prefix(ModifierIds.crystalshot, abilitySalvage));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.barebow).setTools(TinkerTags.Items.BOWS))).addInput((TagKey<Item>)Tags.Items.STRING).addInput((TagKey<Item>)Tags.Items.RODS_WOODEN).addInput((TagKey<Item>)Tags.Items.STRING).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.barebow, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.multishot).addInput((ItemLike)Items.f_41869_).addInput((TagKey<Item>)TinkerMaterials.amethystBronze.getIngotTag()).addInput((ItemLike)Items.f_41869_).addInput(SlimeType.ICHOR.getSlimeballTag()).addInput(SlimeType.ICHOR.getSlimeballTag()).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.BOWS))).saveSalvage(consumer, this.prefix(TinkerModifiers.multishot, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.multishot, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.sinistral).addInput((TagKey<Item>)TinkerMaterials.slimesteel.getIngotTag()).addInput((ItemLike)Items.f_42715_).addInput((TagKey<Item>)TinkerMaterials.slimesteel.getIngotTag()).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.UPGRADE, 1))).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.CROSSBOWS), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_LEFT)})))).saveSalvage(consumer, this.prefix(TinkerModifiers.sinistral, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.sinistral, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.scope).setTools(TinkerTags.Items.INTERACTABLE_CHARGE))).addInput((ItemLike)Items.f_42501_).addInput((ItemLike)Items.f_151059_).addInput((ItemLike)Items.f_42501_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.scope, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.scope, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.lure).setTools(TinkerTags.Items.FISHING_RODS))).addInput((ItemLike)TinkerCommons.cheeseIngot).addInput((ItemLike)TinkerCommons.cheeseIngot).addInput((ItemLike)TinkerCommons.cheeseIngot).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage(consumer, this.prefix(ModifierIds.lure, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.lure, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.grapple).setTools(TinkerTags.Items.FISHING_RODS))).addInput((ItemLike)Items.f_42026_).addInput((ItemLike)Items.f_42026_).addInput((TagKey<Item>)TinkerMaterials.cinderslime.getIngotTag()).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.grapple, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.grapple, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.collecting).setTools(TinkerTags.Items.FISHING_RODS))).addInput((ItemLike)Blocks.f_50332_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.collecting, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.collecting, abilityFolder));
        MaterialIngredient bowLimb = MaterialIngredient.of(TinkerToolParts.bowLimb.get());
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.throwing).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.MELEE_WEAPON), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_CHARGE)})))).addInput((Ingredient)bowLimb).addInput((TagKey<Item>)TinkerMaterials.cinderslime.getIngotTag()).addInput((Ingredient)MaterialIngredient.of(TinkerToolParts.bowGrip.get())).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.throwing, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.throwing, abilityFolder));
        MultilevelModifierRecipeBuilder.modifier(ModifierIds.returning).setTools(TinkerTags.Items.MELEE_WEAPON).addInput((ItemLike)Items.f_42584_).addInput((ItemLike)Items.f_42524_).addInput((ItemLike)Items.f_42584_).addLevel(SlotType.ABILITY, 1, 1).addLevelRange(SlotType.UPGRADE, 1, 2, 4).saveSalvage(consumer, this.prefix(ModifierIds.returning, abilitySalvage)).save(consumer, this.prefix(ModifierIds.returning, abilityFolder));
        Ingredient protectableTools = ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.ARMOR, TinkerTags.Items.HELD);
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.meleeProtection).setInput((ItemLike)TinkerModifiers.cobaltReinforcement, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(protectableTools))).saveSalvage(consumer, this.prefix(ModifierIds.meleeProtection, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.meleeProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.projectileProtection).setInput((ItemLike)TinkerModifiers.ironReinforcement, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(protectableTools))).saveSalvage(consumer, this.prefix(ModifierIds.projectileProtection, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.projectileProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.blastProtection).setInput((ItemLike)TinkerModifiers.obsidianReinforcement, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(protectableTools))).saveSalvage(consumer, this.prefix(ModifierIds.blastProtection, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.blastProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.magicProtection).setInput((ItemLike)TinkerModifiers.goldReinforcement, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(protectableTools))).saveSalvage(consumer, this.prefix(ModifierIds.magicProtection, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.magicProtection, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.fireProtection).setInput((ItemLike)TinkerModifiers.searedReinforcement, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(protectableTools))).saveSalvage(consumer, this.prefix(ModifierIds.fireProtection, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.fireProtection, defenseFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.protection).addInput((ItemLike)TinkerModifiers.goldReinforcement).addInput((ItemLike)TinkerModifiers.searedReinforcement).addInput((ItemLike)TinkerModifiers.obsidianReinforcement).addInput((ItemLike)TinkerModifiers.ironReinforcement).addInput((ItemLike)TinkerModifiers.cobaltReinforcement).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.ARMOR))).setMaxLevel(1))).saveSalvage(consumer, this.prefix(ModifierIds.protection, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.protection, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.boundless).addInput((ItemLike)TinkerCommons.obsidianPane, 4).addInput((ItemLike)Items.f_42614_).addInput((ItemLike)TinkerCommons.obsidianPane, 4).addInput((ItemLike)TinkerWorld.ichorGeode, 2).addInput((ItemLike)TinkerWorld.ichorGeode, 2).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.SHIELDS))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.boundless, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.boundless, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.knockbackResistance).setTools(TinkerTags.Items.ARMOR))).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_})).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(1))).saveSalvage(consumer, this.prefix(ModifierIds.knockbackResistance, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.knockbackResistance, defenseFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.golden).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).setSlots(SlotType.DEFENSE, 1))).setMaxLevel(1))).checkTraitLevel())).setTools(TinkerTags.Items.WORN_ARMOR))).saveSalvage(consumer, this.prefix(TinkerModifiers.golden, defenseSalvage)))).setTools(TinkerTags.Items.GOLDEN_ARMOR))).save(this.withCondition(consumer, new ICondition[]{new TagFilledCondition(TinkerTags.Items.GOLDEN_ARMOR)}), this.prefix(TinkerModifiers.golden, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.turtleShell).setInput((ItemLike)Items.f_42355_, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage(consumer, this.prefix(ModifierIds.turtleShell, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.turtleShell, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.shulking).setInput((ItemLike)Items.f_42748_, 1, 5).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage(consumer, this.prefix(ModifierIds.shulking, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.shulking, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.dragonborn).setInput((ItemLike)TinkerModifiers.dragonScale, 1, 10).setSlots(SlotType.DEFENSE, 1))).setTools(TinkerTags.Items.ARMOR))).saveSalvage(consumer, this.prefix(ModifierIds.dragonborn, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.dragonborn, defenseFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.revitalizing).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.WORN_ARMOR)))).setInput((ItemLike)TinkerCommons.jeweledApple, 1, 2).setSlots(SlotType.DEFENSE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.revitalizing, defenseSalvage)))).save(consumer, this.prefix(ModifierIds.revitalizing, defenseFolder));
        Ingredient wornOrShield = ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.WORN_ARMOR, TinkerTags.Items.SHIELDS);
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.thorns).setTools(wornOrShield))).setInput((ItemLike)Blocks.f_50128_, 1, 25).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.thorns, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.thorns, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.sticky).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.WORN_ARMOR, TinkerTags.Items.SHIELDS)))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.sticky, upgradeSalvage));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.springy).setTools(wornOrShield))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.ICHOR)).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage(consumer, this.prefix(ModifierIds.springy, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.springy, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.respiration).setTools(TinkerTags.Items.HELMETS))).addInput((TagKey<Item>)ItemTags.f_13156_).addInput((TagKey<Item>)Tags.Items.GLASS_COLORLESS).addInput((TagKey<Item>)ItemTags.f_13156_).addInput((ItemLike)Items.f_41910_).addInput((ItemLike)Items.f_41910_).setMaxLevel(3))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.respiration, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.respiration, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.itemFrame).setTools(TinkerTags.Items.HELMETS))).addInput(Ingredient.m_43921_(Arrays.stream(FrameType.values()).filter(type -> type != FrameType.CLEAR).map(type -> new ItemStack((ItemLike)TinkerGadgets.itemFrame.get((Enum)type))))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.itemFrame, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.itemFrame, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.minimap).setTools(TinkerTags.Items.HELMETS))).addInput((ItemLike)Items.f_42522_).addInput((TagKey<Item>)Tags.Items.SLIMEBALLS).addInput((ItemLike)Items.f_42516_).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.minimap, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.minimap, upgradeFolder));
        this.hasteRecipes(consumer, ModifierIds.speedy, Ingredient.m_204132_(TinkerTags.Items.LEGGINGS), 3, upgradeFolder, upgradeSalvage);
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.leaping).setTools(TinkerTags.Items.LEGGINGS))).setInput((ItemLike)TinkerWorld.skyGeode.m_5456_(), 1, 36).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).save(consumer, this.prefix(ModifierIds.leaping, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.leaping).setTools(TinkerTags.Items.LEGGINGS))).setInput((ItemLike)TinkerWorld.skyGeode.getBlock(), 1, 18).exactLevel(2))).setSlots(SlotType.ABILITY, 1))).save(consumer, this.prefix(ModifierIds.leaping, abilityFolder));
        MultilevelModifierRecipeBuilder.modifier(ModifierIds.leaping).setTools(TinkerTags.Items.LEGGINGS).addLevelRange(SlotType.UPGRADE, 1, 1, 1).addLevelRange(SlotType.ABILITY, 1, 2, 2).saveSalvage(consumer, this.prefix(ModifierIds.leaping, salvageFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.stepUp).setTools(TinkerTags.Items.LEGGINGS))).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42677_).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42340_).addInput((ItemLike)Items.f_42340_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.stepUp, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.stepUp, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.swiftSneak).setTools(TinkerTags.Items.LEGGINGS))).addInput((ItemLike)Blocks.f_152500_).setMaxLevel(5))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(ModifierIds.swiftSneak, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.swiftSneak, upgradeFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.featherFalling).setTools(TinkerTags.Items.BOOTS))).setInput((ItemLike)Items.f_42402_, 1, 15).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(4))).saveSalvage(consumer, this.prefix(ModifierIds.featherFalling, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.featherFalling, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.soulspeed).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_42258_).addInput((ItemLike)Items.f_42754_).addInput((ItemLike)Items.f_42258_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage(consumer, this.prefix(TinkerModifiers.soulspeed, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.soulspeed, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.depthStrider).setTools(TinkerTags.Items.BOOTS))).addInput((TagKey<Item>)ItemTags.f_13156_).addInput((ItemLike)Blocks.f_50378_).addInput((TagKey<Item>)ItemTags.f_13156_).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(3))).saveSalvage(consumer, this.prefix(ModifierIds.depthStrider, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.depthStrider, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.ricochet).setTools(wornOrShield))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.ricochet, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.ricochet, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.zoom).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELMETS, TinkerTags.Items.INTERACTABLE_CHARGE)))).addInput((TagKey<Item>)Tags.Items.STRING).addInput((ItemLike)Items.f_151059_).addInput((TagKey<Item>)Tags.Items.STRING).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.zoom, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.zoom, upgradeFolder));
        NoContainerIngredient tanks = NoContainerIngredient.of(TinkerTags.Items.TANKS);
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.slurping).addInput((ItemLike)Items.f_42590_).addInput((Ingredient)tanks).addInput((ItemLike)Items.f_42590_).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELMETS, TinkerTags.Items.INTERACTABLE_CHARGE)))).saveSalvage(consumer, this.prefix(TinkerModifiers.slurping, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.slurping, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.aquaAffinity).addInput((ItemLike)Blocks.f_50378_).addInput((ItemLike)Items.f_42716_).addInput((ItemLike)Blocks.f_50378_).addInput((ItemLike)Blocks.f_50379_).addInput((ItemLike)Blocks.f_50379_).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HELMETS))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.aquaAffinity, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.aquaAffinity, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.ambidextrous).setTools(TinkerTags.Items.UNARMED))).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)Tags.Items.STRING).addInput((TagKey<Item>)Tags.Items.STRING).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.ambidextrous, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.ambidextrous, abilityFolder));
        ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(ModifierIds.strength).setTools(TinkerTags.Items.CHESTPLATES))).setInput((ItemLike)TinkerWorld.ichorGeode.m_5456_(), 1, 72).setSlots(SlotType.ABILITY, 1))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.strength, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.strength, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.wings).setTools(TinkerTags.Items.CHESTPLATES))).setMaxLevel(1))).checkTraitLevel())).addInput((ItemLike)Items.f_42741_).setSlots(SlotType.ABILITY, 2))).saveSalvage(consumer, this.prefix(ModifierIds.wings, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.wings, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.pockets).setTools(TinkerTags.Items.LEGGINGS))).addInput((ItemLike)Items.f_42748_).addInput((TagKey<Item>)Tags.Items.INGOTS_IRON).addInput((ItemLike)Items.f_42748_).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Items.f_42454_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.pockets, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.pockets, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.shieldStrap).addInput((ItemLike)TinkerWorld.skySlimeVine).addInput((TagKey<Item>)TinkerMaterials.slimesteel.getIngotTag()).addInput((ItemLike)TinkerWorld.skySlimeVine).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.LEGGINGS))).saveSalvage(consumer, this.prefix(TinkerModifiers.shieldStrap, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.shieldStrap, upgradeFolder));
        BiConsumer<Integer, TagKey> toolBeltRecipe = (level, ingot) -> {
            ModifierRecipeBuilder builder = (ModifierRecipeBuilder)((Object)((Object)((Object)((ModifierRecipeBuilder)((Object)((Object)((Object)((ModifierRecipeBuilder)((Object)((Object)((Object)ModifierRecipeBuilder.modifier(ModifierIds.toolBelt).addInput((ItemLike)Items.f_42454_).addInput((TagKey<Item>)ingot).addInput((ItemLike)Items.f_42454_).setTools(TinkerTags.Items.LEGGINGS))))).exactLevel((int)level))))).useSalvageMax())));
            if (level == 1) {
                builder.setSlots(SlotType.ABILITY, 1);
                builder.saveSalvage(consumer, this.prefix(ModifierIds.toolBelt, abilitySalvage));
            } else {
                builder.disallowCrystal();
            }
            builder.save(consumer, this.wrap(ModifierIds.toolBelt, abilityFolder, "_" + level));
        };
        toolBeltRecipe.accept(1, Tags.Items.INGOTS_IRON);
        toolBeltRecipe.accept(2, Tags.Items.INGOTS_GOLD);
        toolBeltRecipe.accept(3, TinkerMaterials.roseGold.getIngotTag());
        toolBeltRecipe.accept(4, TinkerMaterials.cobalt.getIngotTag());
        toolBeltRecipe.accept(5, TinkerMaterials.hepatizon.getIngotTag());
        toolBeltRecipe.accept(6, TinkerMaterials.manyullyn.getIngotTag());
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.soulBelt).addInput((ItemLike)Items.f_42454_).addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220211_})).addInput((ItemLike)Items.f_42454_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).setTools(TinkerTags.Items.LEGGINGS))).saveSalvage(consumer, this.prefix(ModifierIds.soulBelt, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.soulBelt, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.workbench).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)Blocks.f_50091_).addInput((ItemLike)Items.f_42454_).setMaxLevel(1))).checkTraitLevel())).setTools(TinkerTags.Items.LEGGINGS))).save(consumer, this.prefix(ModifierIds.workbench, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.craftingTable).addInput((ItemLike)Items.f_42454_).addInput((ItemLike)TinkerTables.craftingStation).addInput((ItemLike)Items.f_42454_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).setTools(TinkerTags.Items.LEGGINGS))).saveSalvage(consumer, this.prefix(ModifierIds.craftingTable, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.craftingTable, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.wetting).addInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addInput((Ingredient)tanks).addInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.LEGGINGS, TinkerTags.Items.SHIELDS)))).saveSalvage(consumer, this.prefix(TinkerModifiers.wetting, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.wetting, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.doubleJump).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)Items.f_42714_).addInput((ItemLike)Items.f_42714_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.doubleJump, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.doubleJump, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.bouncy).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 4).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.bouncy, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.bouncy, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.frostWalker).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_42363_).addInput((ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.STRAY)).addInput((ItemLike)Items.f_42363_).addInput((ItemLike)Items.f_42363_).addInput((ItemLike)Items.f_42363_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).saveSalvage(consumer, this.prefix(ModifierIds.frostWalker, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.frostWalker, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.snowdrift).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_41981_).addInput((ItemLike)Items.f_42047_).addInput((ItemLike)Items.f_41981_).addInput((ItemLike)Items.f_41981_).addInput((ItemLike)Items.f_41981_).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).saveSalvage(consumer, this.prefix(ModifierIds.snowdrift, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.snowdrift, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.longFall).setTools(TinkerTags.Items.BOOTS))).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)Blocks.f_50109_).addInput((ItemLike)Items.f_41869_).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).addInput((ItemLike)TinkerWorld.slime.get((Enum)SlimeType.SKY)).setSlots(SlotType.ABILITY, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(consumer, this.prefix(ModifierIds.longFall, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.longFall, abilityFolder));
        Ingredient bootsWithDuraibility = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.BOOTS), Ingredient.m_204132_(TinkerTags.Items.DURABILITY)});
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.flamewake).setTools(bootsWithDuraibility))).addInput((ItemLike)Items.f_42484_).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).addInput((ItemLike)Items.f_42484_).addInput((ItemLike)Items.f_42484_).addInput((ItemLike)Items.f_42484_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.flamewake, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.flamewake, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.gilded).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((ItemLike)Blocks.f_50706_).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.gilded, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.gilded, abilityFolder));
        Ingredient luckSupporting = ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.HARVEST, TinkerTags.Items.LAUNCHERS);
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.luck).setTools(luckSupporting))).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{Items.f_41949_, Items.f_41941_})).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).allowCrystal())).save(consumer, this.wrap(ModifierIds.luck, abilityFolder, "_level_1"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.luck).setTools(luckSupporting))).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((ItemLike)Items.f_42677_).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).disallowCrystal())).exactLevel(2))).save(consumer, this.wrap(ModifierIds.luck, abilityFolder, "_level_2"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.luck).setTools(luckSupporting))).addInput((TagKey<Item>)TinkerMaterials.roseGold.getIngotTag()).addInput((ItemLike)Items.f_42648_).addInput((TagKey<Item>)TinkerMaterials.roseGold.getIngotTag()).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addInput((ItemLike)Items.f_42656_).disallowCrystal())).exactLevel(3))).save(consumer, this.wrap(ModifierIds.luck, abilityFolder, "_level_3"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.luck).setTools(TinkerTags.Items.LEGGINGS))).addInput(SizedIngredient.fromItems((ItemLike[])new ItemLike[]{Items.f_41949_, Items.f_41941_})).addInput((ItemLike)Items.f_42648_).addInput((ItemLike)Items.f_42677_).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND).addInput((ItemLike)Items.f_42656_).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).disallowCrystal())).saveSalvage(consumer, this.wrap(ModifierIds.luck, abilitySalvage, "_pants")))).save(consumer, this.wrap(ModifierIds.luck, abilityFolder, "_pants"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.luck).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST, TinkerTags.Items.LAUNCHERS)))).exactLevel(1))).useSalvageMax())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.luck, abilitySalvage));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.silky).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).addInput((ItemLike)TinkerModifiers.silkyCloth).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HARVEST))).saveSalvage(consumer, this.prefix(TinkerModifiers.silky, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.silky, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.exchanging).addInput((ItemLike)Items.f_41862_).addInput((TagKey<Item>)TinkerMaterials.hepatizon.getIngotTag()).addInput((ItemLike)Items.f_41862_).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.HARVEST))).saveSalvage(consumer, this.prefix(TinkerModifiers.exchanging, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.exchanging, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.autosmelt).addInput((TagKey<Item>)Tags.Items.RAW_MATERIALS).addInput((ItemLike)Blocks.f_50620_).addInput((TagKey<Item>)Tags.Items.INGOTS).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL).addInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COAL).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HARVEST, TinkerTags.Items.FISHING_RODS)))).saveSalvage(consumer, this.prefix(TinkerModifiers.autosmelt, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.autosmelt, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.channeling).addInput((ItemLike)Blocks.f_152587_).addInput((ItemLike)Blocks.f_50318_).addInput((ItemLike)Blocks.f_152587_).addInput((ItemLike)Blocks.f_152587_).addInput((ItemLike)Blocks.f_152587_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE_WEAPON, TinkerTags.Items.FISHING_RODS)))).saveSalvage(consumer, this.prefix(ModifierIds.channeling, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.channeling, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.fins).addInput((TagKey<Item>)ItemTags.f_13156_).addInput((ItemLike)Blocks.f_50378_).addInput((TagKey<Item>)ItemTags.f_13156_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.UPGRADE, 1))).setTools(TinkerTags.Items.MELEE_WEAPON))).saveSalvage(consumer, this.prefix(ModifierIds.fins, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.fins, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.melting).addInput((ItemLike)Items.f_42585_).addInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedMelter, TinkerSmeltery.smelteryController, TinkerSmeltery.foundryController})).addInput((ItemLike)Items.f_42585_).addInput((ItemLike)Items.f_42448_).addInput((ItemLike)Items.f_42448_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.MELEE, TinkerTags.Items.HARVEST)))).saveSalvage(consumer, this.prefix(TinkerModifiers.melting, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.melting, abilityFolder));
        SizedIngredient faucets = SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerSmeltery.searedFaucet, TinkerSmeltery.scorchedFaucet});
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.bucketing).addInput(faucets).addInput((ItemLike)Items.f_42446_).addInput(faucets).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).setMaxLevel(1))).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.INTERACTABLE))).saveSalvage(consumer, this.prefix(TinkerModifiers.bucketing, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.bucketing, abilityFolder));
        SizedIngredient channels = SizedIngredient.fromItems((ItemLike[])new ItemLike[]{TinkerSmeltery.searedChannel, TinkerSmeltery.scorchedChannel});
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.spilling).addInput(channels).addInput((Ingredient)tanks).addInput(channels).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.MELEE))).saveSalvage(consumer, this.prefix(ModifierIds.spilling, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.spilling, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.splashing).addInput((TagKey<Item>)MantleTags.Items.SPLASH_BOTTLE).addInput((Ingredient)tanks).addInput((TagKey<Item>)MantleTags.Items.SPLASH_BOTTLE).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE)})))).saveSalvage(consumer, this.prefix(TinkerModifiers.splashing, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.splashing, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.bursting).addInput((ItemLike)Blocks.f_50128_).addInput((Ingredient)tanks).addInput((ItemLike)Blocks.f_50128_).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setSlots(SlotType.ABILITY, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.CHESTPLATES, TinkerTags.Items.SHIELDS)))).saveSalvage(consumer, this.prefix(TinkerModifiers.bursting, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.bursting, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.spitting).addInput((Ingredient)bowLimb).addInput((ItemLike)TinkerSmeltery.searedFluidCannon).addInput((Ingredient)bowLimb).setSlots(SlotType.ABILITY, 1))).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_CHARGE_MODIFIER)})))).saveSalvage(consumer, this.prefix(TinkerModifiers.spitting, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.spitting, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.tank).addInput((Ingredient)tanks).setSlots(SlotType.UPGRADE, 1))).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELD, TinkerTags.Items.ARMOR)))).saveSalvage(consumer, this.prefix(ModifierIds.tank, upgradeSalvage)))).save(consumer, this.prefix(ModifierIds.tank, upgradeFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.expanded).addInput((ItemLike)Items.f_41869_).addInput((TagKey<Item>)TinkerMaterials.amethystBronze.getIngotTag()).addInput((ItemLike)Items.f_41869_).addInput(SlimeType.ICHOR.getSlimeballTag()).addInput(SlimeType.ICHOR.getSlimeballTag()).setSlots(SlotType.ABILITY, 1))).setTools(TinkerTags.Items.AOE))).saveSalvage(consumer, this.prefix(TinkerModifiers.expanded, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.expanded, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.reach).setTools(TinkerTags.Items.CHESTPLATES))).addInput((ItemLike)Items.f_41869_).addInput((TagKey<Item>)TinkerMaterials.queensSlime.getIngotTag()).addInput((ItemLike)Items.f_41869_).addInput(SlimeType.ENDER.getSlimeballTag()).addInput(SlimeType.ENDER.getSlimeballTag()).setSlots(SlotType.ABILITY, 1))).setMaxLevel(2))).saveSalvage(consumer, this.prefix(ModifierIds.reach, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.reach, abilityFolder));
        Ingredient interactableWithDurability = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE)});
        Ingredient interactableBootsWithDurability = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.INTERACTABLE, TinkerTags.Items.BOOTS)});
        SizedIngredient roundPlate = SizedIngredient.of((Ingredient)MaterialIngredient.of(TinkerToolParts.adzeHead.get()));
        SizedIngredient smallBlade = SizedIngredient.of((Ingredient)MaterialIngredient.of(TinkerToolParts.smallBlade.get()));
        SizedIngredient toolBinding = SizedIngredient.of((Ingredient)MaterialIngredient.of(TinkerToolParts.toolBinding.get()));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.pathing).setTools(interactableBootsWithDurability))).addInput(roundPlate).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput(toolBinding).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.pathing, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.pathing, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.stripping).setTools(interactableWithDurability))).addInput(SizedIngredient.of((Ingredient)MaterialIngredient.of(TinkerToolParts.smallAxeHead.get()))).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput(toolBinding).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.stripping, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.stripping, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.tilling).setTools(interactableBootsWithDurability))).addInput(smallBlade).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput(toolBinding).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.tilling, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.tilling, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.brushing).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_RIGHT)})))).addInput((TagKey<Item>)Tags.Items.FEATHERS).addInput((TagKey<Item>)Tags.Items.INGOTS_COPPER).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.brushing, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.brushing, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.glowing).setTools(interactableBootsWithDurability))).addInput((ItemLike)Items.f_42054_).addInput((ItemLike)Items.f_42152_).addInput((ItemLike)Items.f_42783_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(ModifierIds.glowing, abilitySalvage)))).save(consumer, this.prefix(ModifierIds.glowing, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.firestarter).setTools(interactableWithDurability))).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput((ItemLike)Items.f_42484_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.firestarter, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.firestarter, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.fireprimer).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.flintAndBrick})))).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput((ItemLike)Items.f_42484_).setMaxLevel(1))).setSlots(SlotType.UPGRADE, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.fireprimer, upgradeSalvage)))).save(consumer, this.prefix(TinkerModifiers.fireprimer, upgradeFolder));
        Ingredient blockWhileCharging = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DURABILITY), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_CHARGE)});
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.flinging).setTools(blockWhileCharging))).addInput((TagKey<Item>)Tags.Items.STRING).addInput((ItemLike)TinkerWorld.earthGeode.m_5456_()).addInput((TagKey<Item>)Tags.Items.STRING).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH)).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH)).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.flinging, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.flinging, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.springing).setTools(blockWhileCharging))).addInput((TagKey<Item>)Tags.Items.FEATHERS).addInput((ItemLike)TinkerWorld.skyGeode.m_5456_()).addInput((TagKey<Item>)Tags.Items.FEATHERS).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY)).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY)).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.springing, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.springing, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.bonking).setTools(blockWhileCharging))).addInput((TagKey<Item>)Tags.Items.INGOTS_IRON).addInput((ItemLike)TinkerWorld.ichorGeode.m_5456_()).addInput((TagKey<Item>)Tags.Items.INGOTS_IRON).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.bonking, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.bonking, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.warping).setTools(blockWhileCharging))).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((ItemLike)TinkerWorld.enderGeode.m_5456_()).addInput((TagKey<Item>)Tags.Items.ENDER_PEARLS).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ENDER)).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.warping, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.warping, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.unbreakable).setTools(TinkerTags.Items.DURABILITY))).addInput((ItemLike)Items.f_42748_).addInput((ItemLike)Items.f_42735_).addInput((ItemLike)Items.f_42748_).addInput((TagKey<Item>)Tags.Items.INGOTS_NETHERITE).addInput((TagKey<Item>)Tags.Items.INGOTS_NETHERITE).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.unbreakable, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.unbreakable, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.dualWielding).addInput((TagKey<Item>)TinkerMaterials.slimesteel.getIngotTag()).addInput((ItemLike)Items.f_42715_).addInput((TagKey<Item>)TinkerMaterials.slimesteel.getIngotTag()).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).setTools((Ingredient)DifferenceIngredient.of((Ingredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.MELEE_WEAPON), Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_RIGHT)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.dagger}))))).saveSalvage(consumer, this.prefix(TinkerModifiers.dualWielding, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.dualWielding, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.blocking).setTools((Ingredient)DifferenceIngredient.of((Ingredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_CHARGE), Ingredient.m_204132_(TinkerTags.Items.DURABILITY)}), (Ingredient)ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.PARRY, TinkerTags.Items.SHIELDS))))).addInput((TagKey<Item>)ItemTags.f_13168_).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput((TagKey<Item>)ItemTags.f_13168_).addInput((TagKey<Item>)ItemTags.f_13168_).addInput((TagKey<Item>)ItemTags.f_13168_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.blocking, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.blocking, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.parrying).setTools(TinkerTags.Items.PARRY))).addInput((TagKey<Item>)ItemTags.f_13168_).addInput((TagKey<Item>)TinkerMaterials.steel.getIngotTag()).addInput((TagKey<Item>)ItemTags.f_13168_).setMaxLevel(1))).checkTraitLevel())).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.parrying, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.parrying, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(TinkerModifiers.reflecting).setTools(TinkerTags.Items.SHIELDS))).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.SKY), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 4).addInput((ItemLike)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH), 4).setSlots(SlotType.ABILITY, 1))).saveSalvage(consumer, this.prefix(TinkerModifiers.reflecting, abilitySalvage)))).save(consumer, this.prefix(TinkerModifiers.reflecting, abilityFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.writable).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((ItemLike)Items.f_42614_).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.writable, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.harmonious).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((TagKey<Item>)ItemTags.f_13158_).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.harmonious, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.recapitated).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput(SizedIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.HEADS), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42683_})))).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.recapitated, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.forecast).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput(ModifierRecipeProvider.ingredientFromTags(Tags.Items.ORES_DIAMOND, Tags.Items.ORES_EMERALD, TinkerTags.Items.ORES_COBALT)).setMaxLevel(1))).save(consumer, this.prefix(ModifierIds.forecast, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.embossed).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput(TinkerTags.Items.BOSS_TROPHIES).setMaxLevel(1))).save(this.withCondition(consumer, new ICondition[]{new TagFilledCondition(TinkerTags.Items.BOSS_TROPHIES)}), this.prefix(ModifierIds.embossed, slotlessFolder));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.draconic).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((ItemLike)Items.f_42683_).setMaxLevel(1))).save(consumer, this.wrap(ModifierIds.draconic, slotlessFolder, "_from_head"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.draconic).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((ItemLike)Items.f_42735_).addInput((ItemLike)TinkerModifiers.dragonScale).addInput((ItemLike)Items.f_42735_).addInput((ItemLike)TinkerModifiers.dragonScale).addInput((ItemLike)TinkerModifiers.dragonScale).setMaxLevel(1))).disallowCrystal())).save(consumer, this.wrap(ModifierIds.draconic, slotlessFolder, "_from_scales"));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(ModifierIds.rebalanced, SlotType.UPGRADE.getName()).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((TagKey<Item>)TinkerMaterials.roseGold.getNuggetTag()).addInput((ItemLike)Items.f_42729_).addInput((TagKey<Item>)TinkerMaterials.roseGold.getNuggetTag()).addInput((ItemLike)TinkerWorld.skyGeode.getBlock()).addInput((ItemLike)TinkerWorld.skyGeode.getBlock()).disallowCrystal())).save(consumer, this.wrap(ModifierIds.rebalanced, slotlessFolder, "_" + SlotType.UPGRADE.getName()));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(ModifierIds.rebalanced, SlotType.DEFENSE.getName()).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.ARMOR, TinkerTags.Items.HELD), Ingredient.m_204132_(TinkerTags.Items.BONUS_SLOTS)})))).addInput((TagKey<Item>)TinkerMaterials.cobalt.getNuggetTag()).addInput((ItemLike)Items.f_42729_).addInput((TagKey<Item>)TinkerMaterials.cobalt.getNuggetTag()).addInput((ItemLike)TinkerWorld.earthGeode.getBlock()).addInput((ItemLike)TinkerWorld.earthGeode.getBlock()).disallowCrystal())).save(consumer, this.wrap(ModifierIds.rebalanced, slotlessFolder, "_" + SlotType.DEFENSE.getName()));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(ModifierIds.rebalanced, SlotType.ABILITY.getName()).setTools(TinkerTags.Items.BONUS_SLOTS))).addInput((TagKey<Item>)TinkerMaterials.queensSlime.getNuggetTag()).addInput((ItemLike)Items.f_42729_).addInput((TagKey<Item>)TinkerMaterials.queensSlime.getNuggetTag()).addInput((ItemLike)TinkerWorld.ichorGeode.getBlock()).addInput((ItemLike)TinkerWorld.ichorGeode.getBlock()).disallowCrystal())).save(consumer, this.wrap(ModifierIds.rebalanced, slotlessFolder, "_" + SlotType.ABILITY.getName()));
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(ModifierIds.rebalanced, "traits").setTools((Ingredient)ToolHookIngredient.of(TinkerTags.Items.BONUS_SLOTS, ToolHooks.REBALANCED_TRAIT)))).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getNuggetTag()).addInput((ItemLike)Items.f_42729_).addInput((TagKey<Item>)TinkerMaterials.manyullyn.getNuggetTag()).addInput((ItemLike)TinkerWorld.enderGeode.getBlock()).addInput((ItemLike)TinkerWorld.enderGeode.getBlock()).disallowCrystal())).save(consumer, this.wrap(ModifierIds.rebalanced, slotlessFolder, "_traits"));
        PotionCastingRecipeBuilder.tableRecipe(ModifierIds.tipped).setBottle(TinkerTags.Items.AMMO).setCoolingTime(20).setFluid(TinkerFluids.potion.ingredient(25)).save(consumer, this.location(slotlessFolder + "ammo_tipping"));
        ((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.removal().addInput((ItemLike)Blocks.f_50057_))).addLeftover((ItemLike)Blocks.f_50056_).save(consumer, this.location(worktableFolder + "remove_modifier_sponge"));
        ((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.removal().addInput(CompoundIngredient.of((Ingredient[])new Ingredient[]{FluidContainerIngredient.fromFluid(TinkerFluids.venom), FluidContainerIngredient.fromIngredient((FluidIngredient)TinkerFluids.venom.ingredient(250), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerFluids.venomBottle}))})))).save(consumer, this.location(worktableFolder + "remove_modifier_venom"));
        IJsonPredicate extractBlacklist = ModifierPredicate.tag(TinkerTags.Modifiers.EXTRACT_MODIFIER_BLACKLIST).inverted();
        for (boolean bl : new boolean[]{false, true}) {
            String suffix = bl ? "_dagger" : "";
            SizedIngredient tools = bl ? SizedIngredient.fromItems((int)2, (ItemLike[])new ItemLike[]{TinkerTools.dagger}) : SizedIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(TinkerTags.Items.MODIFIABLE), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.UNSALVAGABLE)));
            ((ModifierRemovalRecipeBuilder)((Object)((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.extract().setTools(tools).setName("slotless").addInput((ItemLike)Items.f_151049_))).addInput((ItemLike)Items.f_41903_))).addLeftover((ItemLike)Items.f_41902_).modifierPredicate(ModifierPredicate.and(extractBlacklist, new SlotTypeModifierPredicate(null), ModifierPredicate.tag(TinkerTags.Modifiers.EXTRACT_SLOTLESS_BLACKLIST).inverted())).save(consumer, this.location(worktableFolder + "extract/slotless" + suffix));
            ((ModifierRemovalRecipeBuilder)((Object)((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.extract().setTools(tools).slotName(SlotType.UPGRADE).addInput((ItemLike)TinkerWorld.skyGeode))).addInput((ItemLike)Items.f_41903_))).addLeftover((ItemLike)Items.f_41902_).modifierPredicate(ModifierPredicate.and(extractBlacklist, new SlotTypeModifierPredicate(SlotType.UPGRADE))).save(consumer, this.location(worktableFolder + "extract/upgrade" + suffix));
            ((ModifierRemovalRecipeBuilder)((Object)((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.extract().setTools(tools).slotName(SlotType.DEFENSE).addInput((ItemLike)TinkerWorld.earthGeode))).addInput((ItemLike)Items.f_41903_))).addLeftover((ItemLike)Items.f_41902_).modifierPredicate(ModifierPredicate.and(extractBlacklist, new SlotTypeModifierPredicate(SlotType.DEFENSE))).save(consumer, this.location(worktableFolder + "extract/defense" + suffix));
            ((ModifierRemovalRecipeBuilder)((Object)((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.extract().setTools(tools).slotName(SlotType.ABILITY).addInput((ItemLike)TinkerWorld.ichorGeode))).addInput((ItemLike)Items.f_41903_))).addLeftover((ItemLike)Items.f_41902_).modifierPredicate(ModifierPredicate.and(extractBlacklist, new SlotTypeModifierPredicate(SlotType.ABILITY))).save(consumer, this.location(worktableFolder + "extract/ability" + suffix));
            ((ModifierRemovalRecipeBuilder)((Object)((ModifierRemovalRecipeBuilder)((Object)ModifierRemovalRecipeBuilder.extract().setTools(tools).addInput((ItemLike)TinkerWorld.enderGeode))).addInput((ItemLike)Items.f_41903_))).addLeftover((ItemLike)Items.f_41902_).modifierPredicate((IJsonPredicate<ModifierId>)extractBlacklist).save(consumer, this.location(worktableFolder + "extract/modifier" + suffix));
        }
        ((ModifierSortingRecipeBuilder)((Object)ModifierSortingRecipeBuilder.sorting().addInput((ItemLike)Items.f_42522_))).save(consumer, this.location(worktableFolder + "modifier_sorting"));
        ResourceLocation hiddenModifiers = TConstruct.getResource("invisible_modifiers");
        IJsonPredicate blacklist = ModifierPredicate.tag(TinkerTags.Modifiers.INVISIBLE_INK_BLACKLIST).inverted();
        ((ModifierSetWorktableRecipeBuilder)((Object)ModifierSetWorktableRecipeBuilder.setAdding(hiddenModifiers).modifierPredicate((IJsonPredicate<ModifierId>)blacklist).addInput((Ingredient)FluidContainerIngredient.fromIngredient((FluidIngredient)TinkerFluids.skySlime.ingredient(250), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerFluids.slimeBottle.get((Enum)SlimeType.SKY)}))))).save(consumer, this.location(worktableFolder + "invisible_ink_adding"));
        ((ModifierSetWorktableRecipeBuilder)((Object)ModifierSetWorktableRecipeBuilder.setRemoving(hiddenModifiers).modifierPredicate((IJsonPredicate<ModifierId>)blacklist).addInput((Ingredient)FluidContainerIngredient.fromIngredient((FluidIngredient)FluidIngredient.of((TagKey)Tags.Fluids.MILK, (int)1000), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42455_}))))).save(consumer, this.location(worktableFolder + "invisible_ink_removing"));
        ((ToggleInteractionWorktableRecipeBuilder)((Object)ToggleInteractionWorktableRecipeBuilder.builder().tools(Ingredient.m_204132_(TinkerTags.Items.INTERACTABLE_DUAL)).addInput((ItemLike)Items.f_41966_))).save(consumer, this.location(worktableFolder + "toggle_interaction_modifier"));
        for (boolean matchBook : new boolean[]{false, true}) {
            String suffix = matchBook ? "_book" : "_tool";
            ((EnchantmentConvertingRecipeBuilder)((Object)EnchantmentConvertingRecipeBuilder.converting("slotless", matchBook).addInput((ItemLike)Items.f_151049_))).modifierPredicate(ModifierPredicate.and(new SlotTypeModifierPredicate(null), ModifierPredicate.tag(TinkerTags.Modifiers.EXTRACT_SLOTLESS_BLACKLIST).inverted())).save(consumer, this.location(worktableFolder + "enchantment_converting/slotless" + suffix));
            ((EnchantmentConvertingRecipeBuilder)((Object)((EnchantmentConvertingRecipeBuilder)((Object)EnchantmentConvertingRecipeBuilder.converting("upgrades", matchBook).addInput((ItemLike)TinkerWorld.skyGeode.m_5456_()))).addInput((TagKey<Item>)Tags.Items.GEMS_LAPIS, 3))).modifierPredicate(ModifierPredicate.and(new SlotTypeModifierPredicate(SlotType.UPGRADE), ModifierPredicate.tag(TinkerTags.Modifiers.EXTRACT_UPGRADE_BLACKLIST).inverted())).save(consumer, this.location(worktableFolder + "enchantment_converting/upgrade" + suffix));
            ((EnchantmentConvertingRecipeBuilder)((Object)((EnchantmentConvertingRecipeBuilder)((Object)EnchantmentConvertingRecipeBuilder.converting("defense", matchBook).addInput((ItemLike)TinkerWorld.earthGeode.m_5456_()))).addInput((TagKey<Item>)Tags.Items.INGOTS_GOLD, 1))).modifierPredicate(new SlotTypeModifierPredicate(SlotType.DEFENSE)).save(consumer, this.location(worktableFolder + "enchantment_converting/defense" + suffix));
            ((EnchantmentConvertingRecipeBuilder)((Object)((EnchantmentConvertingRecipeBuilder)((Object)EnchantmentConvertingRecipeBuilder.converting("abilities", matchBook).addInput((ItemLike)TinkerWorld.ichorGeode.m_5456_()))).addInput((TagKey<Item>)Tags.Items.GEMS_DIAMOND))).modifierPredicate(new SlotTypeModifierPredicate(SlotType.ABILITY)).save(consumer, this.location(worktableFolder + "enchantment_converting/ability" + suffix));
            ((EnchantmentConvertingRecipeBuilder)((Object)((EnchantmentConvertingRecipeBuilder)((Object)EnchantmentConvertingRecipeBuilder.converting("modifiers", matchBook).addInput((ItemLike)TinkerWorld.enderGeode))).addInput((ItemLike)Items.f_42735_, 5))).returnInput().save(consumer, this.location(worktableFolder + "enchantment_converting/unenchant" + suffix));
        }
        String theOneProbe = "theoneprobe";
        ResourceLocation resourceLocation = new ResourceLocation(theOneProbe, "probe");
        Consumer topConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded(theOneProbe)});
        ((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)((ModifierRecipeBuilder)((Object)ModifierRecipeBuilder.modifier(ModifierIds.theOneProbe).setTools(ModifierRecipeProvider.ingredientFromTags(TinkerTags.Items.HELMETS, TinkerTags.Items.HELD)))).addInput((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{resourceLocation})).setSlots(SlotType.UPGRADE, 1))).setMaxLevel(1))).checkTraitLevel())).saveSalvage(topConsumer, this.prefix(ModifierIds.theOneProbe, compatSalvage)))).save(topConsumer, this.prefix(ModifierIds.theOneProbe, compatFolder));
        Consumer headlightConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("headlight")});
        BiConsumer<Ingredient, String> headlight = (ingredient, light) -> {
            SwappableModifierRecipeBuilder builder = SwappableModifierRecipeBuilder.modifier(ModifierIds.headlight, light);
            ((ModifierRecipeBuilder)((Object)((Object)((Object)((ModifierRecipeBuilder)((Object)((Object)((Object)builder.variantFormatter(SwappableModifierRecipe.VariantFormatter.PARAMETER).setTools(TinkerTags.Items.HELMETS))))).addInput((ItemLike)Items.f_42454_).addInput((Ingredient)ingredient).addInput((ItemLike)Items.f_42454_).setSlots(SlotType.UPGRADE, 1))))).disallowCrystal();
            if ("10".equals(light)) {
                builder.saveSalvage(headlightConsumer, this.prefix(ModifierIds.headlight, compatSalvage));
            } else {
                builder.disallowCrystal();
            }
            builder.save(headlightConsumer, this.wrap(ModifierIds.headlight, compatFolder, "_" + light));
        };
        headlight.accept(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50681_}), "15");
        headlight.accept(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50682_}), "10");
        headlight.accept(Ingredient.m_204132_((TagKey)ItemTags.f_144319_), "5");
    }

    private void addTextureRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/modifiers/slotless/";
        this.woodTexture(consumer, MaterialIds.crimson, (ItemLike)Blocks.f_50655_, folder);
        this.woodTexture(consumer, MaterialIds.warped, (ItemLike)Blocks.f_50656_, folder);
        this.woodTexture(consumer, MaterialIds.greenheart, (ItemLike)TinkerWorld.greenheart, folder);
        this.woodTexture(consumer, MaterialIds.skyroot, (ItemLike)TinkerWorld.skyroot, folder);
        this.woodTexture(consumer, MaterialIds.bloodshroom, (ItemLike)TinkerWorld.bloodshroom, folder);
        this.woodTexture(consumer, MaterialIds.enderbark, (ItemLike)TinkerWorld.enderbark, folder);
        this.woodTexture(consumer, MaterialIds.blazewood, (ItemLike)TinkerMaterials.blazewood, folder);
        this.woodTexture(consumer, MaterialIds.nahuatl, (ItemLike)TinkerMaterials.nahuatl, folder);
        this.woodTexture(consumer, MaterialIds.bamboo, (ItemLike)Blocks.f_50571_, folder);
        this.woodTexture(consumer, MaterialIds.cactus, (ItemLike)Blocks.f_50128_, folder);
        TagKey treatedWood = this.getItemTag("forge", "treated_wood");
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.treatedWood.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_WOOD))).addInput((TagKey<Item>)treatedWood).addInput((ItemLike)TinkerTables.pattern).addInput((TagKey<Item>)treatedWood).save(this.withCondition(consumer, new ICondition[]{new TagFilledCondition(treatedWood)}), this.wrap(TinkerModifiers.embellishment, folder, "/wood/treated"));
        TagKey ironwood = this.getItemTag("forge", "ingots/ironwood");
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.ironwood.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_WOOD))).addInput((TagKey<Item>)ironwood).addInput((ItemLike)TinkerTables.pattern).addInput((TagKey<Item>)ironwood).save(this.withCondition(consumer, new ICondition[]{new TagFilledCondition(ironwood)}), this.wrap(TinkerModifiers.embellishment, folder, "/wood/ironwood"));
        consumer.accept((FinishedRecipe)new SimpleFinishedRecipe(this.location(folder + "dyeing"), (RecipeSerializer)TinkerModifiers.armorDyeingSerializer.get()));
        consumer.accept((FinishedRecipe)new SimpleFinishedRecipe(this.location(folder + "trim"), (RecipeSerializer)TinkerModifiers.armorTrimSerializer.get()));
        this.slimeTexture(consumer, MaterialIds.earthslime, SlimeType.EARTH, folder);
        this.slimeTexture(consumer, MaterialIds.skyslime, SlimeType.SKY, folder);
        this.slimeTexture(consumer, MaterialIds.ichor, SlimeType.ICHOR, folder);
        this.slimeTexture(consumer, MaterialIds.enderslime, SlimeType.ENDER, folder);
        this.slimyWoodTexture(consumer, MaterialIds.earthslime, TinkerWorld.greenheart, FoliageType.EARTH, folder);
        this.slimyWoodTexture(consumer, MaterialIds.skyslime, TinkerWorld.skyroot, FoliageType.SKY, folder);
        this.slimyWoodTexture(consumer, MaterialIds.blood, TinkerWorld.bloodshroom, FoliageType.BLOOD, folder);
        this.slimyWoodTexture(consumer, MaterialIds.enderslime, TinkerWorld.enderbark, FoliageType.ENDER, folder);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.clay.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_SLIME))).addInput((ItemLike)Blocks.f_50129_).addInput((ItemLike)Items.f_42461_).addInput((ItemLike)Blocks.f_50129_).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "/slime/clay"));
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.magma.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_SLIME))).addInput((ItemLike)Blocks.f_50450_).addInput((ItemLike)Items.f_42542_).addInput((ItemLike)Blocks.f_50450_).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "/slime/magma"));
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, MaterialIds.honey.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_SLIME))).addInput((ItemLike)Blocks.f_50719_).addInput((ItemLike)Items.f_42787_).addInput((ItemLike)Blocks.f_50719_).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "/slime/honey"));
    }

    private void addHeadRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/severing/";
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20501_}), (ItemLike)Items.f_42681_).save(consumer, this.location(folder + "zombie_head"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20524_}), (ItemLike)Items.f_42678_).save(consumer, this.location(folder + "skeleton_skull"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20497_, EntityType.f_20496_}), (ItemLike)Items.f_42679_).save(consumer, this.location(folder + "wither_skeleton_skull"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20558_}), (ItemLike)Items.f_42682_).save(consumer, this.location(folder + "creeper_head"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20511_}), (ItemLike)Items.f_260451_).save(consumer, this.location(folder + "piglin_head"));
        consumer.accept((FinishedRecipe)new SimpleFinishedRecipe(this.location(folder + "player_head"), (RecipeSerializer)TinkerModifiers.playerBeheadingSerializer.get()));
        consumer.accept((FinishedRecipe)new SimpleFinishedRecipe(this.location(folder + "snow_golem_head"), (RecipeSerializer)TinkerModifiers.snowGolemBeheadingSerializer.get()));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20460_}), (ItemLike)Blocks.f_50143_).save(consumer, this.location(folder + "iron_golem_head"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20565_}), (ItemLike)Items.f_42683_).save(consumer, this.location(folder + "ender_dragon_head"));
        TinkerWorld.headItems.forEach((type, head) -> SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{type.getType()}), (ItemLike)head).save(consumer, this.location(folder + type.m_7912_() + "_head")));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20479_, EntityType.f_20554_}), (ItemLike)Items.f_42591_).save(consumer, this.location(folder + "spider_eye"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20479_, EntityType.f_20554_}), (ItemLike)Items.f_41863_).save(consumer, this.location(folder + "cobweb"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20558_}), (ItemLike)Blocks.f_50077_).save(consumer, this.location(folder + "creeper_tnt"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20509_}), (ItemLike)Items.f_42714_).save(consumer, this.location(folder + "phantom_membrane"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20521_}), (ItemLike)Items.f_42748_).save(consumer, this.location(folder + "shulker_shell"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20524_, EntityType.f_20525_, EntityType.f_20481_}), ItemOutput.fromItem((ItemLike)Items.f_42500_, (int)2)).save(consumer, this.location(folder + "skeleton_bone"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20497_}), ItemOutput.fromItem(TinkerMaterials.necroticBone, (int)2)).save(consumer, this.location(folder + "wither_skeleton_bone"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20551_}), ItemOutput.fromItem((ItemLike)Items.f_42585_, (int)2)).save(consumer, this.location(folder + "blaze_rod"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20526_}), (ItemLike)Items.f_42518_).save(consumer, this.location(folder + "earthslime_ball"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{TinkerWorld.skySlimeEntity.get()}), (ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.SKY)).save(consumer, this.location(folder + "skyslime_ball"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{TinkerWorld.enderSlimeEntity.get()}), (ItemLike)TinkerCommons.slimeball.get((Enum)SlimeType.ENDER)).save(consumer, this.location(folder + "enderslime_ball"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{TinkerWorld.terracubeEntity.get()}), (ItemLike)Items.f_42461_).save(consumer, this.location(folder + "terracube_clay"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20468_}), (ItemLike)Items.f_42542_).save(consumer, this.location(folder + "magma_cream"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20455_, EntityType.f_20563_}), ItemOutput.fromItem((ItemLike)Items.f_42695_, (int)2)).save(consumer, this.location(folder + "guardian_shard"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20517_}), (ItemLike)Items.f_42648_).noChildOutput().save(consumer, this.location(folder + "rabbit_foot"));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20555_}), ItemOutput.fromItem((ItemLike)Items.f_42402_, (int)2)).noChildOutput().save(consumer, this.location(folder + "chicken_feather"));
        consumer.accept((FinishedRecipe)new SimpleFinishedRecipe(this.location(folder + "mooshroom_shroom"), (RecipeSerializer)TinkerModifiers.mooshroomDemushroomingSerializer.get()));
        SeveringRecipeBuilder.severing(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20490_}), (ItemLike)Items.f_42354_).setChildOutput(ItemOutput.fromItem((ItemLike)Items.f_42355_)).save(consumer, this.location(folder + "turtle_shell"));
        consumer.accept((FinishedRecipe)new SimpleFinishedRecipe(this.location(folder + "sheep_wool"), (RecipeSerializer)TinkerModifiers.sheepShearing.get()));
    }

    private void woodTexture(Consumer<FinishedRecipe> consumer, MaterialVariantId material, ItemLike planks, String folder) {
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, material.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_WOOD))).addInput(planks).addInput((ItemLike)TinkerTables.pattern).addInput(planks).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "/wood/" + material.getLocation('_').m_135815_()));
    }

    private void slimeTexture(Consumer<FinishedRecipe> consumer, MaterialId material, SlimeType slime, String folder) {
        ItemLike congealed = (ItemLike)TinkerWorld.congealedSlime.get((Enum)slime);
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, material.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_SLIME))).addInput(congealed).addInput((ItemLike)TinkerCommons.slimeball.get((Enum)slime)).addInput(congealed).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "/slime/" + slime.m_7912_()));
    }

    private void slimyWoodTexture(Consumer<FinishedRecipe> consumer, MaterialId material, WoodBlockObject wood, FoliageType foliage, String folder) {
        ItemLike planks = wood.get();
        ((ModifierRecipeBuilder)((Object)SwappableModifierRecipeBuilder.modifier(TinkerModifiers.embellishment, material.toString()).variantFormatter(SwappableModifierRecipe.VariantFormatter.MATERIAL).setTools(TinkerTags.Items.EMBELLISHMENT_SLIME))).addInput(planks).addInput((ItemLike)TinkerWorld.slimeSapling.get((Enum)foliage)).addInput(planks).save(consumer, this.wrap(TinkerModifiers.embellishment, folder, "/slime/" + wood.getWoodType().f_61839_().split(":", 2)[1]));
    }

    public void hasteRecipes(Consumer<FinishedRecipe> consumer, ModifierId modifier, Ingredient tools, int maxLevel, @Nullable String recipeFolder, @Nullable String salvageFolder) {
        IncrementalModifierRecipeBuilder builder = (IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(modifier).setTools(tools))).setInput((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, 1, 45).setMaxLevel(maxLevel))).setSlots(SlotType.UPGRADE, 1));
        if (salvageFolder != null) {
            builder.saveSalvage(consumer, this.prefix(modifier, salvageFolder));
        }
        if (recipeFolder != null) {
            builder.save(consumer, this.wrap(modifier, recipeFolder, "_from_dust"));
            ((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)((IncrementalModifierRecipeBuilder)((Object)IncrementalModifierRecipeBuilder.modifier(modifier).setTools(tools))).setInput((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, 9, 45).setLeftover(new ItemStack((ItemLike)Items.f_42451_)).setMaxLevel(maxLevel))).setSlots(SlotType.UPGRADE, 1))).disallowCrystal())).save(consumer, this.wrap(modifier, recipeFolder, "_from_block"));
        }
    }

    public ResourceLocation prefix(LazyModifier modifier, String prefix) {
        return this.prefix(modifier.getId(), prefix);
    }

    public ResourceLocation wrap(LazyModifier modifier, String prefix, String suffix) {
        return this.wrap(modifier.getId(), prefix, suffix);
    }

    @SafeVarargs
    private static Ingredient ingredientFromTags(TagKey<Item> ... tags) {
        Ingredient[] tagIngredients = new Ingredient[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            tagIngredients[i] = Ingredient.m_204132_(tags[i]);
        }
        return CompoundIngredient.of((Ingredient[])tagIngredients);
    }
}

