/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class ToolBuildingRecipe
implements ITinkerStationRecipe {
    public static final int X_OFFSET = -6;
    public static final int Y_OFFSET = -15;
    public static final int SLOT_SIZE = 18;
    protected static final RecipeResult<LazyToolStack> NO_COUNT = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "tool_build.no_count"), new Object[0]);
    public static final RecordLoadable<ToolBuildingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.defaultField("result_count", (Object)1, true, r -> r.outputCount), (RecordField)Loadables.RESOURCE_LOCATION.nullableField("slot_layout", r -> r.layoutSlot), (RecordField)IngredientLoadable.DISALLOW_EMPTY.list(0).defaultField("extra_requirements", List.of(), r -> r.ingredients), (RecordField)TinkerLoadables.TOOL_PART_ITEM.list(0).nullableField("parts_override", r -> r.parts), (RecordField)MaterialVariantId.LOADABLE.list(0).defaultField("extra_materials", List.of(), false, r -> r.materials), ToolBuildingRecipe::new);
    protected final ResourceLocation id;
    protected final String group;
    protected final IModifiable output;
    protected final int outputCount;
    @Nullable
    protected final ResourceLocation layoutSlot;
    protected final List<Ingredient> ingredients;
    @Nullable
    protected final List<IToolPart> parts;
    protected final List<MaterialVariantId> materials;
    protected List<LayoutSlot> layoutSlots;
    protected List<List<ItemStack>> allToolParts;
    protected ItemStack displayOutput;

    @Deprecated(forRemoval=true)
    public ToolBuildingRecipe(ResourceLocation id, String group, IModifiable output, int outputCount, @Nullable ResourceLocation layoutSlot, List<Ingredient> ingredients) {
        this(id, group, output, outputCount, layoutSlot, ingredients, null, List.of());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.toolBuildingRecipeSerializer.get();
    }

    public List<IToolPart> getToolParts() {
        if (this.parts != null) {
            return this.parts;
        }
        return ToolPartsHook.parts(this.output.getToolDefinition());
    }

    public List<Ingredient> getExtraRequirements() {
        return this.ingredients;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level worldIn) {
        int i;
        if (!inv.getTinkerableStack().m_41619_()) {
            return false;
        }
        List<IToolPart> parts = this.getToolParts();
        int requiredInputs = parts.size() + this.ingredients.size();
        int maxInputs = inv.getInputCount();
        if (requiredInputs == 0 || requiredInputs > maxInputs) {
            return false;
        }
        int partSize = parts.size();
        for (i = 0; i < partSize; ++i) {
            if (parts.get(i).m_5456_() == inv.getInput(i).m_41720_()) continue;
            return false;
        }
        while (i < maxInputs) {
            Ingredient ingredient = (Ingredient)LogicHelper.getOrDefault(this.ingredients, (int)(i - partSize), (Object)Ingredient.f_43901_);
            if (!ingredient.test(inv.getInput(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        Component error;
        int materialCount = ToolMaterialHook.stats(this.output.getToolDefinition()).size();
        ArrayList<MaterialVariant> materials = new ArrayList<MaterialVariant>(materialCount);
        int parts = this.getToolParts().size();
        if (materialCount > 0) {
            int i;
            int max = Math.min(parts, materialCount);
            for (i = 0; i < max; ++i) {
                materials.add(MaterialVariant.of(IMaterialItem.getMaterialFromStack(inv.getInput(i))));
            }
            max = Math.min(materialCount - parts, this.materials.size());
            for (i = 0; i < max; ++i) {
                materials.add(MaterialVariant.of(this.materials.get(i)));
            }
        }
        ToolStack tool = ToolStack.createTool(this.output.m_5456_(), this.output.getToolDefinition(), new MaterialNBT(materials));
        int count = this.outputCount;
        if (parts > 0) {
            for (ModifierEntry entry : tool.getModifiers()) {
                count = entry.getHook(ModifierHooks.TOOL_CRAFT).onToolCraft(tool, entry, count);
                if (count > 0) continue;
                return NO_COUNT;
            }
        }
        if ((error = tool.tryValidate()) != null) {
            return RecipeResult.failure(error);
        }
        return LazyToolStack.success(tool, Math.min(this.output.m_5456_().m_41459_(), count));
    }

    public boolean requiresAnvil() {
        return this.getToolParts().size() + this.getExtraRequirements().size() >= 4;
    }

    public ResourceLocation getLayoutSlotId() {
        return Objects.requireNonNullElse(this.layoutSlot, this.output.getToolDefinition().getId());
    }

    public List<List<ItemStack>> getAllToolParts() {
        if (this.allToolParts == null) {
            this.allToolParts = this.getToolParts().stream().map(part -> MaterialRecipeCache.getAllVariants().stream().filter(mat -> part.canUseMaterial(mat.getId())).map(part::withMaterial).toList()).toList();
        }
        return this.allToolParts;
    }

    public List<LayoutSlot> getLayoutSlots() {
        if (this.layoutSlots == null) {
            int missingSlots;
            this.layoutSlots = StationSlotLayoutLoader.getInstance().get(this.getLayoutSlotId()).getInputSlots();
            if (this.layoutSlots.isEmpty()) {
                this.layoutSlots = StationSlotLayoutLoader.getInstance().get(TConstruct.getResource(this.requiresAnvil() ? "tinkers_anvil" : "tinker_station")).getInputSlots();
            }
            if ((missingSlots = this.getAllToolParts().size() + this.getExtraRequirements().size() - this.layoutSlots.size()) > 0) {
                TConstruct.LOG.error(String.format("Tool part count is greater than layout slot count for %s!", this.m_6423_()));
                this.layoutSlots = new ArrayList<LayoutSlot>(this.layoutSlots);
                for (int additionalSlot = 0; additionalSlot < missingSlots; ++additionalSlot) {
                    this.layoutSlots.add(new LayoutSlot(null, null, additionalSlot * 18 - -6, 15, null));
                }
            }
        }
        return this.layoutSlots;
    }

    public ItemStack getDisplayOutput() {
        if (this.displayOutput == null) {
            int materialCount;
            int offset;
            if (!this.materials.isEmpty() && (offset = this.getToolParts().size()) < (materialCount = ToolMaterialHook.stats(this.output.getToolDefinition()).size())) {
                ArrayList<MaterialVariantId> list = new ArrayList<MaterialVariantId>(materialCount);
                for (int i = 0; i < offset; ++i) {
                    list.add(ToolBuildHandler.getRenderMaterial(i));
                }
                int max = Math.min(materialCount - offset, this.materials.size());
                for (int i = 0; i < max; ++i) {
                    list.add(this.materials.get(i));
                }
                if (offset == 0) {
                    this.displayOutput = ToolBuildHandler.buildItemFromMaterials(this.output, new MaterialNBT(list.stream().map(MaterialVariant::of).toList()));
                    this.displayOutput.m_41764_(this.outputCount);
                } else {
                    this.displayOutput = new MaterialIdNBT(list).updateStack(new ItemStack((ItemLike)this.output, this.outputCount));
                    this.displayOutput.m_41784_().m_128379_("tic_display", true);
                }
            }
            if (this.displayOutput == null) {
                IModifiable iModifiable = this.output;
                if (iModifiable instanceof IModifiableDisplay) {
                    IModifiableDisplay modifiable = (IModifiableDisplay)iModifiable;
                    v0 = modifiable.getRenderTool();
                } else {
                    v0 = this.displayOutput = this.output.m_5456_().m_7968_();
                }
                if (this.outputCount > 1) {
                    this.displayOutput = this.displayOutput.m_255036_(this.outputCount);
                }
            }
        }
        return this.displayOutput;
    }

    @Override
    @Deprecated
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.output);
    }

    @Override
    @Deprecated
    public ItemStack assemble(ITinkerStationContainer inv, RegistryAccess access) {
        return this.getValidatedResult(inv, access).getResult().getStack();
    }

    protected ToolBuildingRecipe(ResourceLocation id, String group, IModifiable output, int outputCount, @Nullable ResourceLocation layoutSlot, List<Ingredient> ingredients, @Nullable List<IToolPart> parts, List<MaterialVariantId> materials) {
        this.id = id;
        this.group = group;
        this.output = output;
        this.outputCount = outputCount;
        this.layoutSlot = layoutSlot;
        this.ingredients = ingredients;
        this.parts = parts;
        this.materials = materials;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public IModifiable getOutput() {
        return this.output;
    }
}

