package slimeknights.tconstruct.library.modifiers.hook.build;

import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

import java.util.Collection;

/**
 * Hook for when a tool is crafted.
 * @see ValidateModifierHook
 */
public interface ToolCraftModifierHook {
  /**
   * Called when a tool is crafted to let you change the amount crafted or add persistent data.
   * Note this hook is only called on crafting in the tinker station or anvil. Tools crafted by other means (such as casting) will not call it, nor will tool modifications.
   * Hook is really only intended to be used by ammo, such as arrows.
   * @param tool    Tool instance
   * @param entry   Modifier running the hook
   * @param amount  Amount crafted
   * @return  New amount crafted.
   */
  int onToolCraft(IToolStackView tool, ModifierEntry entry, int amount);

  /** Merger running each hook */
  record ComposeMerger(Collection<ToolCraftModifierHook> modules) implements ToolCraftModifierHook {
    @Override
    public int onToolCraft(IToolStackView tool, ModifierEntry entry, int amount) {
      for (ToolCraftModifierHook module : modules) {
        amount = module.onToolCraft(tool, entry, amount);
        if (amount <= 0) {
          return 0;
        }
      }
      return amount;
    }
  }
}
