/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationPartSwapping
implements ITinkerStationRecipe {
    private static final RecipeResult<LazyToolStack> TOO_MANY_PARTS = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    private static final RecipeResult<LazyToolStack> TOO_FEW_INPUTS = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_few_inputs"), new Object[0]);
    public static final RecordLoadable<TinkerStationPartSwapping> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("tools", r -> r.tools), (RecordField)IntLoadable.FROM_ONE.defaultField("max_stack_size", (Object)16, true, r -> r.maxStackSize), TinkerStationPartSwapping::new);
    protected final ResourceLocation id;
    protected final Ingredient tools;
    protected final int maxStackSize;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        Item item;
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !this.tools.test(tinkerable) || !((item = tinkerable.m_41720_()) instanceof IModifiable)) {
            return false;
        }
        IModifiable modifiable = (IModifiable)item;
        List<IToolPart> parts = ToolPartsHook.parts(modifiable.getToolDefinition());
        if (parts.isEmpty()) {
            return false;
        }
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (foundItem) {
                return false;
            }
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof IToolPart) || parts.stream().noneMatch(p -> p.m_5456_() == item2)) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Override
    public int shrinkToolSlotBy() {
        return this.maxStackSize;
    }

    private static int maxStackSize(IToolStackView tool, int count) {
        for (ModifierEntry entry : tool.getModifiers()) {
            count = entry.getHook(ModifierHooks.TOOL_CRAFT).onToolCraft(tool, entry, count);
            if (count > 0) continue;
            return 0;
        }
        return count;
    }

    private int maxStackSize(IToolStackView tool) {
        return TinkerStationPartSwapping.maxStackSize(tool, this.maxStackSize);
    }

    @Override
    public int shrinkToolSlotBy(LazyToolStack result, ITinkerStationContainer inv) {
        return TinkerStationPartSwapping.maxStackSize(inv.getTinkerable(), result.getSize());
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack original = inv.getTinkerable();
        List<IToolPart> parts = ToolPartsHook.parts(original.getDefinition());
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        int shrink = this.maxStackSize(inv.getTinkerable());
        if (shrink <= 0) {
            return TOO_FEW_INPUTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            Component error;
            int cost;
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (!(item instanceof IToolPart)) {
                return RecipeResult.pass();
            }
            IToolPart part = (IToolPart)item;
            MaterialVariantId partVariant = part.getMaterial(stack);
            if (partVariant.equals(IMaterial.UNKNOWN_ID)) {
                return RecipeResult.pass();
            }
            int index = i;
            if ((i >= parts.size() || parts.get(i).m_5456_() != item) && (index = IntStream.range(0, parts.size()).filter(pi -> ((IToolPart)parts.get(pi)).m_5456_() == item).findFirst().orElse(-1)) == -1) {
                return RecipeResult.pass();
            }
            MaterialVariant toolVariant = original.getMaterial(index);
            boolean didChange = !toolVariant.sameVariant(partVariant);
            float repairDurability = MaterialRepairModule.getDurability(null, partVariant.getId(), part.getStatType());
            if (!(didChange || original.getDamage() != 0 && repairDurability != 0.0f)) {
                return RecipeResult.pass();
            }
            ToolStack tool = original.copy();
            if (didChange) {
                tool.replaceMaterial(index, partVariant);
            }
            if (repairDurability > 0.0f && (cost = MaterialCastingLookup.getItemCost(part)) > 0) {
                if ((repairDurability *= (float)cost / 3.0f) > 0.0f) {
                    ModifierEntry entry;
                    Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                    while (iterator.hasNext() && !((repairDurability = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairDurability)) <= 0.0f)) {
                    }
                }
                if (repairDurability > 0.0f) {
                    ToolDamageUtil.repair(tool, (int)repairDurability);
                }
            }
            if ((error = tool.tryValidate()) != null) {
                return RecipeResult.failure(error);
            }
            if (didChange && (error = ModifierRemovalHook.onRemoved(original, tool)) != null) {
                return RecipeResult.failure(error);
            }
            ItemStack originalStack = inv.getTinkerableStack();
            int outputMax = this.maxStackSize(tool);
            int resultSize = Math.min(originalStack.m_41613_() * outputMax / shrink, outputMax);
            if (resultSize <= 0) {
                return TOO_FEW_INPUTS;
            }
            return LazyToolStack.successCopy(tool, resultSize, originalStack);
        }
        return RecipeResult.pass();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }

    public TinkerStationPartSwapping(ResourceLocation id, Ingredient tools, int maxStackSize) {
        this.id = id;
        this.tools = tools;
        this.maxStackSize = maxStackSize;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

