/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomExplosion
extends Explosion {
    private static final int RAY_COUNT = 16;
    private static final int MAX_RAY = 15;
    public static final Predicate<Entity> DEFAULT_ENTITY_PREDICATE = entity -> entity != null && entity.m_6084_() && !entity.m_6128_() && !entity.m_5833_();
    protected final float damage;
    protected final float knockback;
    protected final Predicate<Entity> entityPredicate;

    public CustomExplosion(Level level, Vec3 location, float radius, @Nullable Entity sourceEntity, @Nullable Predicate<Entity> entityPredicate, float damage, @Nullable DamageSource damageSource, float knockback, @Nullable ExplosionDamageCalculator damageCalculator, boolean placeFire, Explosion.BlockInteraction blockInteraction) {
        super(level, sourceEntity, damageSource, damageCalculator, location.f_82479_, location.f_82480_, location.f_82481_, radius, placeFire, blockInteraction);
        this.entityPredicate = Objects.requireNonNullElse(entityPredicate, DEFAULT_ENTITY_PREDICATE);
        this.damage = damage;
        this.knockback = knockback;
    }

    public void m_46061_() {
        this.f_46012_.m_220400_(this.f_46016_, GameEvent.f_157812_, this.getPosition());
        this.calculateHitBlocks();
        this.damageAndPushEntities();
    }

    protected void calculateHitBlocks() {
        if (!this.m_254884_() && !this.f_46009_) {
            return;
        }
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int rayX = 0; rayX < 16; ++rayX) {
            for (int rayY = 0; rayY < 16; ++rayY) {
                block2: for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    if (rayX != 0 && rayX != 15 && rayY != 0 && rayY != 15 && rayZ != 0 && rayZ != 15) continue;
                    double stepX = (double)rayX * 2.0 / 15.0 - 1.0;
                    double stepY = (double)rayY * 2.0 / 15.0 - 1.0;
                    double stepZ = (double)rayZ * 2.0 / 15.0 - 1.0;
                    double stepScale = (double)0.3f / Math.sqrt(stepX * stepX + stepY * stepY + stepZ * stepZ);
                    stepX *= stepScale;
                    stepY *= stepScale;
                    stepZ *= stepScale;
                    double targetX = this.f_46013_;
                    double targetY = this.f_46014_;
                    double targetZ = this.f_46015_;
                    for (float power = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.m_188501_() * 0.6f); power > 0.0f; power -= 0.225f) {
                        BlockPos target = BlockPos.m_274561_((double)targetX, (double)targetY, (double)targetZ);
                        BlockState block = this.f_46012_.m_8055_(target);
                        FluidState fluid = this.f_46012_.m_6425_(target);
                        if (!this.f_46012_.m_46739_(target)) continue block2;
                        Optional resistance = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, target, block, fluid);
                        if (resistance.isPresent()) {
                            power -= (((Float)resistance.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if ((this.f_46009_ || !block.m_60795_()) && power > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, target, block, power)) {
                            set.add(target);
                        }
                        targetX += stepX;
                        targetY += stepY;
                        targetZ += stepZ;
                    }
                }
            }
        }
        this.f_46020_.addAll(set);
    }

    protected void damageAndPushEntities() {
        if (this.damage <= 0.0f && this.knockback == 0.0f) {
            return;
        }
        float diameter = this.f_46017_ * 2.0f;
        List list = this.f_46012_.m_6249_(this.f_46016_, new AABB(Math.floor(this.f_46013_ - (double)diameter - 1.0), Math.floor(this.f_46014_ - (double)diameter - 1.0), Math.floor(this.f_46015_ - (double)diameter - 1.0), Math.floor(this.f_46013_ + (double)diameter + 1.0), Math.floor(this.f_46014_ + (double)diameter + 1.0), Math.floor(this.f_46015_ + (double)diameter + 1.0)), this.entityPredicate);
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, (List)list, (double)diameter);
        Vec3 center = this.getPosition();
        for (Entity entity : list) {
            Player player;
            Vec3 dir = entity.m_20182_().m_82546_(center);
            double length = dir.m_82553_();
            double distance = length / (double)diameter;
            if (!(distance <= 1.0)) continue;
            if (!(entity instanceof PrimedTnt)) {
                dir = dir.m_82520_(0.0, entity.m_20188_() - entity.m_20186_(), 0.0);
                length = dir.m_82553_();
            }
            if (!(length > 1.0E-4)) continue;
            double strength = (1.0 - distance) * (double)CustomExplosion.m_46064_((Vec3)center, (Entity)entity);
            if (this.damage > 0.0f) {
                entity.m_6469_(this.m_46077_(), (float)((int)((strength * strength + strength) / 2.0 * (double)this.damage + 1.0)));
            }
            if (this.knockback == 0.0f) continue;
            double adjustedStrength = strength * (double)this.knockback;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                adjustedStrength = ProtectionEnchantment.m_45135_((LivingEntity)living, (double)adjustedStrength);
            }
            Vec3 velocity = dir.m_82490_(adjustedStrength / length);
            entity.m_20256_(entity.m_20184_().m_82549_(velocity));
            if (!(entity instanceof Player) || (player = (Player)entity).m_7500_() && player.m_150110_().f_35935_) continue;
            this.f_46021_.put(player, velocity);
        }
    }

    public void handleServer() {
        if (!this.f_46012_.f_46443_ && !ForgeEventFactory.onExplosionStart((Level)this.f_46012_, (Explosion)this)) {
            this.m_46061_();
            this.m_46075_(false);
            this.syncToClient();
        }
    }

    public void doDualSide(Level level, boolean spawnParticles) {
        if (!ForgeEventFactory.onExplosionStart((Level)level, (Explosion)this)) {
            this.m_46061_();
            this.m_46075_(spawnParticles);
        }
    }

    public void syncToClient() {
        Level level;
        if (!this.f_46012_.f_46443_ && (level = this.f_46012_) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            List toBlow = this.m_254884_() ? this.m_46081_() : List.of();
            Vec3 position = this.getPosition();
            for (ServerPlayer player : server.m_6907_()) {
                if (!(player.m_20238_(position) < 4096.0)) continue;
                player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(this.f_46013_, this.f_46014_, this.f_46015_, this.f_46017_, toBlow, (Vec3)this.f_46021_.get(player)));
            }
        }
    }
}

