/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolTierStat;

public class ToolStats {
    public static final StringLoadable<IToolStat<?>> LOADER = ToolStatId.PARSER.comapFlatMap((id, error) -> {
        IToolStat<?> stat = ToolStats.getToolStat(id);
        if (stat != null) {
            return stat;
        }
        throw error.create("Unknown stat type " + id);
    }, IToolStat::getName);
    public static final StringLoadable<INumericToolStat<?>> NUMERIC_LOADER = LOADER.comapFlatMap((stat, error) -> {
        if (stat instanceof INumericToolStat) {
            INumericToolStat numeric = (INumericToolStat)stat;
            return numeric;
        }
        throw error.create("Invalid tool stat " + stat.getName() + ", must be a numeric stat");
    }, stat -> stat);
    private static final Map<ToolStatId, IToolStat<?>> ALL_STATS = new HashMap();
    public static final FloatToolStat DURABILITY = ToolStats.register(new FloatToolStat(ToolStats.name("durability"), -12071865, 1.0f, 1.0f, 2.1474836E9f, TinkerTags.Items.DURABILITY));
    public static final FloatToolStat USE_ITEM_SPEED = ToolStats.register(new FloatToolStat(ToolStats.name("use_item_speed"), -8871731, 0.2f, 0.0f, 1.0f, TinkerTags.Items.HELD));
    public static final FloatToolStat ATTACK_DAMAGE = ToolStats.register(new FloatToolStat(ToolStats.name("attack_damage"), -2661276, 0.0f, 0.0f, 2048.0f, TinkerTags.Items.MELEE));
    public static final FloatToolStat ATTACK_SPEED = ToolStats.register(new FloatToolStat(ToolStats.name("attack_speed"), -8042548, 1.0f, 0.0f, 1024.0f, TinkerTags.Items.MELEE_WEAPON));
    public static final FloatToolStat MINING_SPEED = ToolStats.register(new FloatToolStat(ToolStats.name("mining_speed"), -8871731, 1.0f, 0.1f, 2048.0f, TinkerTags.Items.HARVEST));
    public static final ToolTierStat HARVEST_TIER = ToolStats.register(new ToolTierStat(ToolStats.name("harvest_tier")));
    public static final FloatToolStat ARMOR = ToolStats.register(new FloatToolStat(ToolStats.name("armor"), -8042548, 0.0f, 0.0f, 30.0f, TinkerTags.Items.ARMOR));
    public static final FloatToolStat ARMOR_TOUGHNESS = ToolStats.register(new FloatToolStat(ToolStats.name("armor_toughness"), -8042548, 0.0f, 0.0f, 20.0f, TinkerTags.Items.ARMOR));
    public static final FloatToolStat KNOCKBACK_RESISTANCE = ToolStats.register(new FloatToolStat(ToolStats.name("knockback_resistance"), -8042548, 0.0f, 0.0f, 1.0f, TinkerTags.Items.ARMOR));
    public static final FloatToolStat BLOCK_AMOUNT = ToolStats.register(new FloatToolStat(ToolStats.name("block_amount"), -8871731, 5.0f, 0.0f, 2048.0f, TinkerTags.Items.HELD));
    public static final FloatToolStat BLOCK_ANGLE = ToolStats.register(new FloatToolStat(ToolStats.name("block_angle"), -8871731, 120.0f, 0.0f, 180.0f, TinkerTags.Items.HELD));
    public static final FloatToolStat DRAW_SPEED = ToolStats.register(new FloatToolStat(ToolStats.name("draw_speed"), -8042548, 1.0f, 0.0f, 1024.0f, TinkerTags.Items.RANGED));
    public static final FloatToolStat VELOCITY = ToolStats.register(new FloatToolStat(ToolStats.name("velocity"), -8871731, 1.0f, 0.0f, 1024.0f, TinkerTags.Items.RANGED));
    public static final FloatToolStat ACCURACY = ToolStats.register(new FloatToolStat(ToolStats.name("accuracy"), -8042548, 0.75f, 0.1f, 1.0f, (IJsonPredicate<Item>)ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag(TinkerTags.Items.RANGED), ItemPredicate.tag(TinkerTags.Items.AMMO)})));
    public static final FloatToolStat PROJECTILE_DAMAGE = ToolStats.register(new FloatToolStat(ToolStats.name("projectile_damage"), -2661276, 2.0f, 0.0f, 1024.0f, (IJsonPredicate<Item>)ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag(TinkerTags.Items.LAUNCHERS), ItemPredicate.tag(TinkerTags.Items.AMMO)})));
    public static final FloatToolStat WATER_INERTIA = ToolStats.register(new FloatToolStat(ToolStats.name("water_inertia"), -10845453, 0.6f, 0.01f, 0.99f, (IJsonPredicate<Item>)ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag(TinkerTags.Items.MELEE_WEAPON), ItemPredicate.tag(TinkerTags.Items.AMMO)})));
    public static final FloatToolStat SEA_LUCK = ToolStats.register(new FloatToolStat(ToolStats.name("sea_luck"), -13345085, 0.0f, 0.0f, 1024.0f, TinkerTags.Items.FISHING_RODS));
    public static final FloatToolStat LURE = ToolStats.register(new FloatToolStat(ToolStats.name("lure"), -3421160, 0.0f, 0.0f, 5.0f, TinkerTags.Items.FISHING_RODS));

    @Nullable
    public static IToolStat<?> getToolStat(ToolStatId name) {
        return ALL_STATS.get((Object)name);
    }

    @Deprecated(forRemoval=true)
    public static IToolStat<?> fromJson(String key) {
        IToolStat<?> stat;
        ResourceLocation location = ResourceLocation.m_135820_((String)key);
        if (location != null && (stat = ToolStats.getToolStat(new ToolStatId(location))) != null) {
            return stat;
        }
        throw new JsonSyntaxException("Unknown stat type " + key);
    }

    @Deprecated(forRemoval=true)
    public static INumericToolStat<?> numericFromJson(String key) {
        IToolStat<?> iToolStat = ToolStats.fromJson(key);
        if (iToolStat instanceof INumericToolStat) {
            INumericToolStat stat = (INumericToolStat)iToolStat;
            return stat;
        }
        throw new JsonSyntaxException("Invalid tool stat " + key + ", must be a numeric stat");
    }

    @Deprecated(forRemoval=true)
    public static IToolStat<?> fromNetwork(FriendlyByteBuf buffer) {
        return (IToolStat)LOADER.decode(buffer);
    }

    @Deprecated(forRemoval=true)
    public static INumericToolStat<?> numericFromNetwork(FriendlyByteBuf buffer) {
        return (INumericToolStat)NUMERIC_LOADER.decode(buffer);
    }

    public static <T extends IToolStat<?>> T register(T toolStat) {
        if (ALL_STATS.containsKey((Object)toolStat.getName())) {
            throw new IllegalArgumentException("Attempt to register duplicate tool stat " + toolStat.getName());
        }
        ALL_STATS.put(toolStat.getName(), toolStat);
        return toolStat;
    }

    public static Collection<IToolStat<?>> getAllStats() {
        return ALL_STATS.values();
    }

    private static ToolStatId name(String name) {
        return new ToolStatId("tconstruct", name);
    }
}

