/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data.sprite;

import net.minecraft.world.item.ArmorItem;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class TinkerPartSpriteProvider
extends AbstractPartSpriteProvider {
    public static final MaterialStatsId WOOD = new MaterialStatsId("tconstruct", "wood");
    public static final MaterialStatsId SLIMESUIT = new MaterialStatsId("tconstruct", "slimesuit");
    public static final MaterialStatsId ARMOR_PLATING = new MaterialStatsId("tconstruct", "armor_plating");
    public static final MaterialStatsId ARMOR_MAILLE = new MaterialStatsId("tconstruct", "armor_maille");
    public static final MaterialStatsId ARMOR_CUIRASS = new MaterialStatsId("tconstruct", "armor_cuirass");

    public TinkerPartSpriteProvider() {
        super("tconstruct");
    }

    @Override
    public String getName() {
        return "Tinkers' Construct Parts";
    }

    @Override
    protected void addAllSpites() {
        this.addHead("large_plate");
        this.addHead("small_blade");
        this.addHandle("tool_handle");
        this.addHandle("tough_handle");
        this.addBowstring("bowstring");
        this.addBinding("tool_binding");
        this.addBinding("tough_binding");
        this.addPart("repair_kit", StatlessMaterialStats.REPAIR_KIT.getIdentifier());
        this.addTexture("tinker_armor/travelers/metal_armor", ARMOR_PLATING).disallowAnimated();
        this.addTexture("tinker_armor/travelers/metal_leggings", ARMOR_PLATING).disallowAnimated();
        this.addTexture("tinker_armor/travelers/cuirass_armor", ARMOR_CUIRASS).disallowAnimated();
        this.addTexture("tinker_armor/travelers/cuirass_leggings", ARMOR_CUIRASS).disallowAnimated();
        this.addTexture("tinker_armor/travelers/cuirass_wings", ARMOR_CUIRASS).disallowAnimated();
        this.buildTool("armor/travelers/goggles").disallowAnimated().addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier()).addBreakablePart("metal", PlatingMaterialStats.HELMET.getId());
        this.buildTool("armor/travelers/vest").disallowAnimated().addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier()).addBreakablePart("metal", PlatingMaterialStats.CHESTPLATE.getId());
        this.buildTool("armor/travelers/pants").disallowAnimated().addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier()).addBreakablePart("metal", PlatingMaterialStats.LEGGINGS.getId());
        this.buildTool("armor/travelers/boots").disallowAnimated().addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier()).addBreakablePart("metal", PlatingMaterialStats.BOOTS.getId());
        this.buildTool("armor/travelers/shield").addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier()).addBreakablePart("wood", StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        this.addPart("maille", StatlessMaterialStats.MAILLE.getIdentifier());
        for (ArmorItem.Type slot : ArmorItem.Type.values()) {
            this.buildTool("armor/plate/" + slot.m_266355_()).disallowAnimated().addBreakablePart("plating", PlatingMaterialStats.TYPES.get(slot.ordinal()).getId()).addBreakablePart("maille", StatlessMaterialStats.MAILLE.getIdentifier());
        }
        this.addTexture("tinker_armor/plate/plating_armor", ARMOR_PLATING).disallowAnimated();
        this.addTexture("tinker_armor/plate/plating_leggings", ARMOR_PLATING).disallowAnimated();
        this.addTexture("tinker_armor/plate/maille_armor", ARMOR_MAILLE).disallowAnimated();
        this.addTexture("tinker_armor/plate/maille_leggings", ARMOR_MAILLE).disallowAnimated();
        this.addTexture("tinker_armor/plate/maille_wings", ARMOR_MAILLE).disallowAnimated();
        this.buildTool("armor/plate/shield").addBreakablePart("plating", PlatingMaterialStats.SHIELD.getId()).addBreakablePart("core", StatlessMaterialStats.SHIELD_CORE.getIdentifier()).addBreakablePart("plating_large", PlatingMaterialStats.SHIELD.getId()).addBreakablePart("core_large", StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        this.addSprite("staff/modifiers/tconstruct_embellishment", WOOD);
        this.addSprite("staff/large_modifiers/tconstruct_embellishment", WOOD);
        this.addSprite("armor/slime/skull_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/skull_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/wings_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/wings_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/shell_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/shell_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/boot_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addSprite("armor/slime/boot_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
        this.addTexture("tinker_armor/slime/armor", SLIMESUIT).disallowAnimated();
        this.addTexture("tinker_armor/slime/leggings", SLIMESUIT).disallowAnimated();
        this.addTexture("tinker_armor/slime/wings", SLIMESUIT).disallowAnimated();
        this.buildTool("pickaxe").addBreakableHead("head").addHandle("handle").addBinding("binding");
        this.buildTool("sledge_hammer").withLarge().addBreakableHead("head").addBreakableHead("back").addBreakableHead("front").addHandle("handle");
        this.buildTool("vein_hammer").withLarge().addBreakableHead("head").addBinding("grip").addBreakableHead("front").addHandle("handle");
        this.buildTool("mattock").addBreakableHead("axe").addBreakableHead("pick");
        this.buildTool("pickadze").addBreakableHead("pick").addHead("adze");
        this.buildTool("excavator").withLarge().addBreakableHead("head").addBinding("binding").addHandle("handle").addHandle("grip");
        this.buildTool("hand_axe").addBreakableHead("head").addBinding("binding");
        this.buildTool("broad_axe").withLarge().addBreakableHead("blade").addBreakableHead("back").addHandle("handle").addBinding("binding");
        this.buildTool("kama").addBreakableHead("head").addBinding("binding");
        this.buildTool("scythe").withLarge().addBreakableHead("head").addHandle("handle").addHandle("accessory").addBinding("binding");
        this.buildTool("dagger").addBreakableHead("blade").addHandle("crossguard");
        this.buildTool("sword").addBreakableHead("blade").addHandle("guard").addHandle("handle");
        this.buildTool("cleaver").withLarge().addBreakableHead("head").addBreakableHead("shield").addHandle("handle").addHandle("guard");
        this.buildTool("crossbow").addLimb("limb").addGrip("body").addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
        this.buildTool("longbow").withLarge().addLimb("limb_bottom").addLimb("limb_bottom_1").addLimb("limb_bottom_2").addLimb("limb_bottom_3").addLimb("limb_top").addLimb("limb_top_1").addLimb("limb_top_2").addLimb("limb_top_3").addGrip("grip").addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
        this.buildTool("fishing_rod").addLimb("rod").addBreakableBowstring("string").addBowstring("string_cast");
        this.buildTool("javelin").withLarge().addBreakableHead("head").addLimb("guard").addHandle("handle").addGrip("grip");
        this.buildTool("ammo").addArrowHead("arrow_head").addPart("arrow_shaft", StatlessMaterialStats.ARROW_SHAFT).addArrowHead("shuriken_top").addArrowHead("shuriken_bottom");
        this.buildTool("melting_pan").skipVariants().addBreakablePart("head", PlatingMaterialStats.SHIELD.getId()).addLimb("handle");
        this.buildTool("war_pick").skipVariants().addHead("limb").addLimb("body").addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
        this.buildTool("battlesign").skipVariants().addBreakableHead("head").addPart("handle", PlatingMaterialStats.SHIELD.getId());
        this.buildTool("swasher").skipVariants().addBreakableHead("blade").addHandle("handle").addGrip("barrel").addGrip("barrel_1").addGrip("barrel_2");
        this.buildTool("minotaur_axe").skipVariants().addBreakableHead("front").addHead("back");
    }
}

