/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class ToolBuildingRecipe
implements ITinkerStationRecipe {
    protected static final RecipeResult<LazyToolStack> NO_COUNT = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "tool_build.no_count"), new Object[0]);
    public static final RecordLoadable<ToolBuildingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.defaultField("result_count", (Object)1, true, r -> r.outputCount), (RecordField)Loadables.RESOURCE_LOCATION.nullableField("slot_layout", r -> r.layoutSlot), (RecordField)IngredientLoadable.DISALLOW_EMPTY.list(0).defaultField("extra_requirements", List.of(), r -> r.ingredients), ToolBuildingRecipe::new);
    protected final ResourceLocation id;
    protected final String group;
    protected final IModifiable output;
    protected final int outputCount;
    @Nullable
    protected final ResourceLocation layoutSlot;
    protected final List<Ingredient> ingredients;
    protected List<LayoutSlot> layoutSlots;
    protected List<List<ItemStack>> allToolParts;
    protected ItemStack displayOutput;
    public static final int X_OFFSET = -6;
    public static final int Y_OFFSET = -15;
    public static final int SLOT_SIZE = 18;

    public ResourceLocation getLayoutSlotId() {
        return Objects.requireNonNullElse(this.layoutSlot, this.output.getToolDefinition().getId());
    }

    public List<LayoutSlot> getLayoutSlots() {
        if (this.layoutSlots == null) {
            int missingSlots;
            this.layoutSlots = StationSlotLayoutLoader.getInstance().get(this.getLayoutSlotId()).getInputSlots();
            if (this.layoutSlots.isEmpty()) {
                this.layoutSlots = StationSlotLayoutLoader.getInstance().get(TConstruct.getResource(this.requiresAnvil() ? "tinkers_anvil" : "tinker_station")).getInputSlots();
            }
            if ((missingSlots = this.getAllToolParts().size() + this.getExtraRequirements().size() - this.layoutSlots.size()) > 0) {
                TConstruct.LOG.error(String.format("Tool part count is greater than layout slot count for %s!", this.m_6423_()));
                this.layoutSlots = new ArrayList<LayoutSlot>(this.layoutSlots);
                for (int additionalSlot = 0; additionalSlot < missingSlots; ++additionalSlot) {
                    this.layoutSlots.add(new LayoutSlot(null, null, additionalSlot * 18 - -6, 15, null));
                }
            }
        }
        return this.layoutSlots;
    }

    public List<IToolPart> getToolParts() {
        return ToolPartsHook.parts(this.output.getToolDefinition());
    }

    public List<List<ItemStack>> getAllToolParts() {
        if (this.allToolParts == null) {
            this.allToolParts = this.getToolParts().stream().map(part -> MaterialRecipeCache.getAllVariants().stream().filter(mat -> part.canUseMaterial(mat.getId())).map(part::withMaterial).toList()).toList();
        }
        return this.allToolParts;
    }

    public ItemStack getDisplayOutput() {
        if (this.displayOutput == null) {
            IModifiable iModifiable = this.output;
            if (iModifiable instanceof IModifiableDisplay) {
                IModifiableDisplay modifiable = (IModifiableDisplay)iModifiable;
                v0 = modifiable.getRenderTool();
            } else {
                v0 = this.displayOutput = this.output.m_5456_().m_7968_();
            }
            if (this.outputCount > 1) {
                this.displayOutput = this.displayOutput.m_255036_(this.outputCount);
            }
        }
        return this.displayOutput;
    }

    public List<Ingredient> getExtraRequirements() {
        return this.ingredients;
    }

    public boolean requiresAnvil() {
        return this.getToolParts().size() + this.getExtraRequirements().size() >= 4;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.toolBuildingRecipeSerializer.get();
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level worldIn) {
        int i;
        if (!inv.getTinkerableStack().m_41619_()) {
            return false;
        }
        List<IToolPart> parts = this.getToolParts();
        int requiredInputs = parts.size() + this.ingredients.size();
        int maxInputs = inv.getInputCount();
        if (requiredInputs == 0 || requiredInputs > maxInputs) {
            return false;
        }
        int partSize = parts.size();
        for (i = 0; i < partSize; ++i) {
            if (parts.get(i).m_5456_() == inv.getInput(i).m_41720_()) continue;
            return false;
        }
        while (i < maxInputs) {
            Ingredient ingredient = (Ingredient)LogicHelper.getOrDefault(this.ingredients, (int)(i - partSize), (Object)Ingredient.f_43901_);
            if (!ingredient.test(inv.getInput(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        List<MaterialVariant> materials = IntStream.range(0, ToolPartsHook.parts(this.output.getToolDefinition()).size()).mapToObj(i -> MaterialVariant.of(IMaterialItem.getMaterialFromStack(inv.getInput(i)))).toList();
        ToolStack tool = ToolStack.createTool(this.output.m_5456_(), this.output.getToolDefinition(), new MaterialNBT(materials));
        int count = this.outputCount;
        for (ModifierEntry entry : tool.getModifiers()) {
            count = entry.getHook(ModifierHooks.TOOL_CRAFT).onToolCraft(tool, entry, count);
            if (count > 0) continue;
            return NO_COUNT;
        }
        Component error = tool.tryValidate();
        if (error != null) {
            return RecipeResult.failure(error);
        }
        return LazyToolStack.success(tool, Math.min(this.output.m_5456_().m_41459_(), count));
    }

    @Override
    @Deprecated
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.output);
    }

    @Override
    @Deprecated
    public ItemStack assemble(ITinkerStationContainer inv, RegistryAccess access) {
        return this.getValidatedResult(inv, access).getResult().getStack();
    }

    public ToolBuildingRecipe(ResourceLocation id, String group, IModifiable output, int outputCount, @Nullable ResourceLocation layoutSlot, List<Ingredient> ingredients) {
        this.id = id;
        this.group = group;
        this.output = output;
        this.outputCount = outputCount;
        this.layoutSlot = layoutSlot;
        this.ingredients = ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public IModifiable getOutput() {
        return this.output;
    }
}

