/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.ranged;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public interface BowAmmoModifierHook {
    public static final ResourceLocation SKIP_INVENTORY_AMMO = TConstruct.getResource("skip_inventory_ammo");
    public static final BowAmmoModifierHook EMPTY = (tool, modifier, shooter, standardAmmo, ammoPredicate) -> ItemStack.f_41583_;

    public ItemStack findAmmo(IToolStackView var1, ModifierEntry var2, LivingEntity var3, ItemStack var4, Predicate<ItemStack> var5);

    default public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ammo.m_41774_(needed);
    }

    @Deprecated(forRemoval=true)
    public static boolean hasAmmo(IToolStackView tool, ItemStack bowStack, Player player, Predicate<ItemStack> predicate) {
        return !BowAmmoModifierHook.getAmmo(tool, bowStack, (LivingEntity)player, predicate).m_41619_();
    }

    @Deprecated(forRemoval=true)
    public static boolean hasAmmo(IToolStackView tool, ItemStack bowStack, LivingEntity living, Predicate<ItemStack> predicate) {
        return !BowAmmoModifierHook.getAmmo(tool, bowStack, living, predicate).m_41619_();
    }

    public static ItemStack getAmmo(IToolStackView tool, ItemStack bow, LivingEntity living, @Nullable Predicate<ItemStack> predicate) {
        if (predicate == null) {
            return ForgeHooks.getProjectile((LivingEntity)living, (ItemStack)bow, (ItemStack)ItemStack.f_41583_);
        }
        ItemStack standardAmmo = tool.getVolatileData().getBoolean(SKIP_INVENTORY_AMMO) ? ItemStack.f_41583_ : living.m_6298_(bow);
        for (ModifierEntry entry : tool.getModifierList()) {
            ItemStack ammo = entry.getHook(ModifierHooks.BOW_AMMO).findAmmo(tool, entry, living, standardAmmo, predicate);
            if (ammo.m_41619_()) continue;
            return ammo;
        }
        return standardAmmo;
    }

    private static ItemStack findMatchingAmmo(ItemStack bow, LivingEntity living, Predicate<ItemStack> predicate) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = living.m_21120_(hand);
            if (stack == bow || !predicate.test(stack)) continue;
            return ForgeHooks.getProjectile((LivingEntity)living, (ItemStack)bow, (ItemStack)stack);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)bow, (ItemStack)stack);
            }
        }
        return ItemStack.f_41583_;
    }

    @Deprecated(forRemoval=true)
    public static ItemStack findAmmo(IToolStackView tool, ItemStack bow, Player player, Predicate<ItemStack> predicate) {
        return BowAmmoModifierHook.consumeAmmo(tool, bow, (LivingEntity)player, player, predicate);
    }

    public static ItemStack consumeAmmo(IToolStackView tool, ItemStack bow, LivingEntity living, @Nullable Player player, @Nullable Predicate<ItemStack> predicate) {
        int projectilesDesired = 1 + 2 * tool.getModifierLevel(TinkerModifiers.multishot.getId());
        Level level = living.m_9236_();
        boolean creative = player != null && player.m_150110_().f_35937_ || level.f_46443_;
        boolean skipInventoryAmmo = tool.getVolatileData().getBoolean(SKIP_INVENTORY_AMMO);
        ItemStack standardAmmo = skipInventoryAmmo ? ItemStack.f_41583_ : (predicate == null ? ForgeHooks.getProjectile((LivingEntity)living, (ItemStack)bow, (ItemStack)ItemStack.f_41583_) : living.m_6298_(bow));
        ItemStack resultStack = ItemStack.f_41583_;
        if (predicate != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                BowAmmoModifierHook hook = entry.getHook(ModifierHooks.BOW_AMMO);
                ItemStack ammo = hook.findAmmo(tool, entry, living, standardAmmo, predicate);
                if (ammo.m_41619_()) continue;
                if (creative) {
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)ammo, (int)projectilesDesired);
                }
                resultStack = ItemHandlerHelper.copyStackWithSize((ItemStack)ammo, (int)Math.min(projectilesDesired, ammo.m_41613_()));
                hook.shrinkAmmo(tool, entry, living, ammo, resultStack.m_41613_());
                break;
            }
        }
        if (resultStack.m_41619_()) {
            if (standardAmmo.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (creative) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)standardAmmo, (int)projectilesDesired);
            }
            resultStack = standardAmmo.m_41620_(projectilesDesired);
            if (standardAmmo.m_41619_() && player != null) {
                player.m_150109_().m_36057_(standardAmmo);
            }
        }
        if (resultStack.m_41613_() >= projectilesDesired || level.f_46443_) {
            return resultStack;
        }
        ItemStack match = resultStack;
        predicate = stack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)match);
        block1: do {
            if (!skipInventoryAmmo && standardAmmo.m_41619_()) {
                standardAmmo = BowAmmoModifierHook.findMatchingAmmo(bow, living, predicate);
            }
            int needed = projectilesDesired - resultStack.m_41613_();
            for (ModifierEntry entry : tool.getModifierList()) {
                BowAmmoModifierHook hook = entry.getHook(ModifierHooks.BOW_AMMO);
                ItemStack ammo = hook.findAmmo(tool, entry, living, standardAmmo, predicate);
                if (ammo.m_41619_()) continue;
                int gained = Math.min(needed, ammo.m_41613_());
                hook.shrinkAmmo(tool, entry, living, ammo, gained);
                resultStack.m_41769_(gained);
                continue block1;
            }
            if (standardAmmo.m_41619_()) break;
            if (needed > standardAmmo.m_41613_()) {
                resultStack.m_41769_(standardAmmo.m_41613_());
                if (player != null) {
                    player.m_150109_().m_36057_(standardAmmo);
                }
                standardAmmo = ItemStack.f_41583_;
                continue;
            }
            standardAmmo.m_41774_(needed);
            resultStack.m_41769_(needed);
            break;
        } while (resultStack.m_41613_() < projectilesDesired);
        return resultStack;
    }
}

