/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability.inventory;

import java.util.BitSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.SlotStackModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.modifiers.util.ModuleWithKey;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.inventory.InventorySlotMenuModule;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;

public class InventoryModule
implements ModifierModule,
ToolInventoryCapability.InventoryModifierHook,
VolatileDataModifierHook,
ValidateModifierHook,
ModifierRemovalHook,
ModuleWithKey,
ModifierCondition.ConditionalModule<IToolContext>,
SlotStackModifierHook {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolInventoryCapability.HOOK, ModifierHooks.VOLATILE_DATA, ModifierHooks.VALIDATE, ModifierHooks.REMOVE, ModifierHooks.SLOT_STACK);
    public static final BiFunction<CompoundTag, String, ListTag> GET_COMPOUND_LIST = (nbt, name) -> nbt.m_128437_(name, 10);
    private static final Component HAS_ITEMS = TConstruct.makeTranslation("modifier", "inventory_cannot_remove");
    public static final String TAG_SLOT = "Slot";
    protected static final LoadableField<ResourceLocation, InventoryModule> KEY_FIELD = Loadables.RESOURCE_LOCATION.nullableField("key", InventoryModule::key);
    protected static final LoadableField<LevelingInt, InventoryModule> SLOTS_FIELD = LevelingInt.LOADABLE.requiredField("slots", InventoryModule::slots);
    protected static final LoadableField<LevelingInt, InventoryModule> LIMIT_FIELD = LevelingInt.LOADABLE.defaultField("limit", (Object)LevelingInt.flat(64), InventoryModule::slotLimit);
    protected static final LoadableField<IJsonPredicate<Item>, InventoryModule> FILTER_FIELD = ItemPredicate.LOADER.defaultField("filter", InventoryModule::filter);
    protected static final LoadableField<Pattern, InventoryModule> PATTERN_FIELD = Pattern.PARSER.nullableField("pattern", InventoryModule::pattern);
    protected static final LoadableField<IntRange, InventoryModule> VALIDATION_FIELD = ModifierEntry.VALID_LEVEL.defaultField("validation_level", InventoryModule::validationLevel);
    public static final RecordLoadable<InventoryModule> LOADER = RecordLoadable.create(KEY_FIELD, SLOTS_FIELD, LIMIT_FIELD, FILTER_FIELD, PATTERN_FIELD, ModifierCondition.CONTEXT_FIELD, VALIDATION_FIELD, InventoryModule::new);
    @Nullable
    private final ResourceLocation key;
    private final LevelingInt slots;
    private final LevelingInt slotLimit;
    private final IJsonPredicate<Item> filter;
    @Nullable
    private final Pattern pattern;
    private final ModifierCondition<IToolContext> condition;
    private final IntRange validationLevel;

    public RecordLoadable<? extends InventoryModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private int getPotentialSlots(float level) {
        return Math.max(0, this.slots.computeForLevel(level));
    }

    @Override
    public int getSlots(IToolStackView tool, ModifierEntry modifier) {
        return this.condition.matches(tool, modifier) ? this.getPotentialSlots(modifier.getEffectiveLevel()) : 0;
    }

    @Override
    public void addVolatileData(IToolContext context, ModifierEntry modifier, ToolDataNBT volatileData) {
        if (this.condition.matches(context, modifier)) {
            ToolInventoryCapability.addSlots(volatileData, this.getPotentialSlots(modifier.getEffectiveLevel()));
        }
    }

    @Override
    public int getSlotLimit(IToolStackView tool, ModifierEntry modifier, int slot) {
        return this.slotLimit.compute(modifier.getEffectiveLevel());
    }

    @Override
    public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
        return this.condition.matches(tool, modifier) && this.filter.matches((Object)stack.m_41720_());
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
        return hasStack ? null : this.pattern;
    }

    @Override
    public ItemStack getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
        ModDataNBT modData = tool.getPersistentData();
        ResourceLocation key = this.getKey(modifier.getModifier());
        if (slot < this.getSlots(tool, modifier) && modData.contains(key, 9)) {
            ListTag list = tool.getPersistentData().get(key, GET_COMPOUND_LIST);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                if (compound.m_128451_(TAG_SLOT) != slot) continue;
                return ItemStack.m_41712_((CompoundTag)compound);
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
        if (slot < this.getSlots(tool, modifier)) {
            ListTag list;
            ResourceLocation key;
            ModDataNBT modData = tool.getPersistentData();
            if (modData.contains(key = this.getKey(modifier.getModifier()), 9)) {
                list = modData.get(key, GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag compound = list.m_128728_(i);
                    if (compound.m_128451_(TAG_SLOT) != slot) continue;
                    if (stack.m_41619_()) {
                        list.remove(i);
                    } else {
                        compound.m_128431_().clear();
                        InventoryModule.writeStack(stack, slot, compound);
                    }
                    return;
                }
            } else {
                if (stack.m_41619_()) {
                    return;
                }
                list = new ListTag();
                modData.put(key, (Tag)list);
            }
            if (!stack.m_41619_()) {
                list.add((Object)InventoryModule.writeStack(stack, slot, new CompoundTag()));
            }
        }
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        if (this.condition.tool().matches((Object)tool) && this.validationLevel.test(modifier.getLevel())) {
            ListTag listNBT;
            ModDataNBT persistentData = tool.getPersistentData();
            ResourceLocation key = this.getKey(modifier.getModifier());
            int maxSlots = this.getSlots(tool, modifier);
            if (persistentData.contains(key, 9) && !(listNBT = persistentData.get(key, GET_COMPOUND_LIST)).isEmpty()) {
                int i;
                if (maxSlots == 0) {
                    return HAS_ITEMS;
                }
                BitSet freeSlots = new BitSet(maxSlots);
                freeSlots.set(0, maxSlots, true);
                for (i = 0; i < listNBT.size(); ++i) {
                    freeSlots.set(listNBT.m_128728_(i).m_128451_(TAG_SLOT), false);
                }
                for (i = 0; i < listNBT.size(); ++i) {
                    CompoundTag compoundNBT = listNBT.m_128728_(i);
                    if (compoundNBT.m_128451_(TAG_SLOT) < maxSlots) continue;
                    int free = freeSlots.stream().findFirst().orElse(-1);
                    if (free == -1) {
                        return HAS_ITEMS;
                    }
                    freeSlots.set(free, false);
                    compoundNBT.m_128405_(TAG_SLOT, free);
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        ResourceLocation key;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(key = this.getKey(modifier), 9) && !persistentData.get(key, GET_COMPOUND_LIST).isEmpty()) {
            return HAS_ITEMS;
        }
        persistentData.remove(key);
        return null;
    }

    public static CompoundTag writeStack(ItemStack stack, int slot, CompoundTag compound) {
        stack.m_41739_(compound);
        compound.m_128405_(TAG_SLOT, slot);
        return compound;
    }

    @Override
    public ToolInventoryCapability.StackMatch findStack(IToolStackView tool, ModifierEntry modifier, Predicate<ItemStack> predicate) {
        ResourceLocation key;
        ModDataNBT persistentData;
        ListTag slots;
        int max = this.getSlots(tool, modifier);
        if (max > 0 && !(slots = (persistentData = tool.getPersistentData()).get(key = this.getKey(modifier.getModifier()), GET_COMPOUND_LIST)).isEmpty()) {
            for (int i = 0; i < slots.size(); ++i) {
                ItemStack stack;
                CompoundTag compound = slots.m_128728_(i);
                int slot = compound.m_128451_(TAG_SLOT);
                if (slot >= max || (stack = ItemStack.m_41712_((CompoundTag)compound)).m_41619_() || !predicate.test(stack)) continue;
                return new ToolInventoryCapability.StackMatch(stack, slot);
            }
        }
        return ToolInventoryCapability.StackMatch.EMPTY;
    }

    @Override
    public List<ItemStack> getAllStacks(IToolStackView tool, ModifierEntry entry, List<ItemStack> stackList) {
        ResourceLocation key;
        ModDataNBT modData;
        int max = this.getSlots(tool, entry);
        if (max > 0 && (modData = tool.getPersistentData()).contains(key = this.getKey(entry.getModifier()), 9)) {
            ListTag list = modData.get(key, GET_COMPOUND_LIST);
            ItemStack[] parsed = new ItemStack[max];
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.m_128728_(i);
                int slot = compound.m_128451_(TAG_SLOT);
                if (slot >= max) continue;
                parsed[slot] = ItemStack.m_41712_((CompoundTag)compound);
            }
            for (ItemStack stack : parsed) {
                if (stack == null || stack.m_41619_()) continue;
                stackList.add(stack);
            }
        }
        return stackList;
    }

    @Override
    public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
        if (this.getSlots(slotTool, modifier) > 0) {
            return InventorySlotMenuModule.INSTANCE.overrideOtherStackedOnMe(slotTool, modifier, held, slot, player, access);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nullable
    public ResourceLocation key() {
        return this.key;
    }

    public LevelingInt slots() {
        return this.slots;
    }

    public LevelingInt slotLimit() {
        return this.slotLimit;
    }

    public IJsonPredicate<Item> filter() {
        return this.filter;
    }

    @Nullable
    public Pattern pattern() {
        return this.pattern;
    }

    @Override
    public ModifierCondition<IToolContext> condition() {
        return this.condition;
    }

    public IntRange validationLevel() {
        return this.validationLevel;
    }

    protected InventoryModule(@Nullable ResourceLocation key, LevelingInt slots, LevelingInt slotLimit, IJsonPredicate<Item> filter, @Nullable Pattern pattern, ModifierCondition<IToolContext> condition, IntRange validationLevel) {
        this.key = key;
        this.slots = slots;
        this.slotLimit = slotLimit;
        this.filter = filter;
        this.pattern = pattern;
        this.condition = condition;
        this.validationLevel = validationLevel;
    }

    public static class Builder
    extends ModuleBuilder.Context<Builder> {
        @Nullable
        protected ResourceLocation key = null;
        protected LevelingInt slotLimit = LevelingInt.flat(64);
        protected IJsonPredicate<Item> filter = ItemPredicate.ANY;
        @Nullable
        protected Pattern pattern = null;
        protected IntRange validationLevel = ModifierEntry.VALID_LEVEL;

        protected Builder() {
        }

        public Builder flatLimit(int limit) {
            return this.slotLimit(LevelingInt.flat(limit));
        }

        public Builder limitPerLevel(int limit) {
            return this.slotLimit(LevelingInt.eachLevel(limit));
        }

        public InventoryModule slots(int base, int perLevel) {
            return new InventoryModule(this.key, new LevelingInt(base, perLevel), this.slotLimit, this.filter, this.pattern, this.condition, this.validationLevel);
        }

        public InventoryModule flatSlots(int slots) {
            return this.slots(slots, 0);
        }

        public InventoryModule slotsPerLevel(int slots) {
            return this.slots(0, slots);
        }

        public Builder key(@Nullable ResourceLocation key) {
            this.key = key;
            return this;
        }

        public Builder slotLimit(LevelingInt slotLimit) {
            this.slotLimit = slotLimit;
            return this;
        }

        public Builder filter(IJsonPredicate<Item> filter) {
            this.filter = filter;
            return this;
        }

        public Builder pattern(@Nullable Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder validationLevel(IntRange validationLevel) {
            this.validationLevel = validationLevel;
            return this;
        }
    }
}

