/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.CastingRecipeLookup;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.PartSwapCastingRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class ToolCastingRecipe
extends PartSwapCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    public static final RecordLoadable<ToolCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, (RecordField)ITEM_COST_FIELD, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.result), ToolCastingRecipe::new);
    private final IModifiable result;

    public ToolCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, IModifiable result) {
        super(serializer, id, group, cast, itemCost, -1);
        this.result = result;
        CastingRecipeLookup.registerCastable(result);
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        if (inv.getStack().m_41720_() != this.result.m_5456_()) {
            return MaterialCastingLookup.getCastingFluid(inv.getFluid());
        }
        return super.getFluidRecipe(inv);
    }

    @Override
    public boolean matches(ICastingContainer inv, Level level) {
        ItemStack cast = inv.getStack();
        if (cast.m_41720_() == this.result.m_5456_()) {
            return this.canPartSwap(inv);
        }
        if (!this.getCast().test(cast)) {
            return false;
        }
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
        int numRequirements = requirements.size();
        if (numRequirements < 1 || numRequirements > 2) {
            return false;
        }
        MaterialFluidRecipe recipe = this.getFluidRecipe(inv);
        return recipe != MaterialFluidRecipe.EMPTY && requirements.get(numRequirements - 1).canUseMaterial(recipe.getOutput().getId());
    }

    @Override
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    @Override
    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        ItemStack cast = inv.getStack();
        if (cast.m_41720_() == this.result) {
            return super.assemble(inv, access);
        }
        List<MaterialStatsId> stats = ToolMaterialHook.stats(this.result.getToolDefinition());
        MaterialVariant material = this.getFluidRecipe(inv).getOutput();
        MaterialNBT materials = stats.size() > 1 ? new MaterialNBT(List.of(MaterialVariant.of(IMaterialItem.getMaterialFromStack(cast)), material)) : new MaterialNBT(List.of(material));
        return ToolBuildHandler.buildItemFromMaterials(this.result, materials);
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.multiRecipes == null) {
            List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
            if (requirements.isEmpty()) {
                this.multiRecipes = List.of();
            } else {
                ItemStack partSwapDisplay;
                BiFunction<MaterialVariant, List, List> materials;
                MaterialStatsId requirement = requirements.get(requirements.size() - 1);
                MaterialVariant dummyRequirement = MaterialVariant.of(ToolBuildHandler.getRenderMaterial(0));
                if (requirements.size() > 1) {
                    MaterialVariant firstMaterial = MaterialVariant.of(MaterialRegistry.firstWithStatType(requirements.get(0)));
                    materials = (mat, casts) -> casts.stream().map(cast -> {
                        MaterialVariantId id = IMaterialItem.getMaterialFromStack(cast);
                        MaterialVariant variant = id == IMaterial.UNKNOWN_ID ? firstMaterial : MaterialVariant.of(id);
                        return ToolBuildHandler.buildItemFromMaterials(this.result, MaterialNBT.of(variant, mat));
                    }).toList();
                    partSwapDisplay = ToolBuildHandler.buildItemFromMaterials(this.result, MaterialNBT.of(firstMaterial, dummyRequirement));
                } else {
                    materials = (mat, casts) -> List.of(ToolBuildHandler.buildItemFromMaterials(this.result, MaterialNBT.of(mat)));
                    partSwapDisplay = ToolBuildHandler.buildItemFromMaterials(this.result, MaterialNBT.of(dummyRequirement));
                }
                partSwapDisplay.m_41784_().m_128379_("tic_display", true);
                List<ItemStack> casts2 = List.of(this.getCast().m_43908_());
                List castsWithTool = Streams.concat((Stream[])new Stream[]{casts2.stream(), Stream.of(partSwapDisplay)}).toList();
                this.multiRecipes = Stream.concat(MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> recipe.isVisible() && requirement.canUseMaterial(recipe.getOutput().getId())).map(recipe -> {
                    List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                    return new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), (List<ItemStack>)castsWithTool, fluids, (List)materials.apply(recipe.getOutput(), castsWithTool), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * ToolCastingRecipe.getFluidAmount(fluids)), this.isConsumed());
                }), MaterialCastingLookup.getAllCompositeFluids().stream().filter(recipe -> recipe.isVisible() && requirement.canUseMaterial(recipe.getOutput().getId())).map(recipe -> {
                    List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                    return new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), (List<ItemStack>)((List)materials.apply(recipe.getInput(), casts2)), fluids, (List)materials.apply(recipe.getOutput(), casts2), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * ToolCastingRecipe.getFluidAmount(fluids)), this.isConsumed());
                })).collect(Collectors.toList());
            }
        }
        return this.multiRecipes;
    }
}

