/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.IFluidContainer;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;

public class MeltingFuel
implements ICustomOutputRecipe<IFluidContainer> {
    public static final RecordLoadable<MeltingFuel> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)FluidIngredient.LOADABLE.defaultField("fluid", (Object)FluidIngredient.EMPTY, r -> r.input), (RecordField)IntLoadable.FROM_ONE.defaultField("duration", (Object)0, MeltingFuel::getDuration), (RecordField)IntLoadable.FROM_ONE.requiredField("temperature", MeltingFuel::getTemperature), (RecordField)IntLoadable.FROM_ONE.requiredField("rate", MeltingFuel::getRate), MeltingFuel::new).validate((fuel, error) -> {
        if (fuel.input != FluidIngredient.EMPTY && fuel.duration == 0) {
            throw error.create("Missing JSON field duration");
        }
        return fuel;
    });
    private final ResourceLocation id;
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;
    private final int rate;

    public MeltingFuel(ResourceLocation id, FluidIngredient input, int duration, int temperature, int rate) {
        this.id = id;
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
        this.rate = rate;
        MeltingFuelLookup.addFuel(this);
    }

    public boolean matches(IFluidContainer inv, Level worldIn) {
        return this.matches(inv.getFluid());
    }

    public boolean matches(Fluid fluid) {
        return this.input.test(fluid);
    }

    public int getAmount(IFluidContainer inv) {
        return this.getAmount(inv.getFluid());
    }

    public int getAmount(Fluid fluid) {
        return this.input.getAmount(fluid);
    }

    public List<FluidStack> getInputs() {
        return this.input.getFluids();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.FUEL.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.fuelSerializer.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public FluidIngredient getInput() {
        return this.input;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getRate() {
        return this.rate;
    }
}

