/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.combat;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.LauncherHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public enum ChannelingModule implements ModifierModule,
MeleeHitModifierHook,
LauncherHitModifierHook
{
    INSTANCE;

    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final RecordLoadable<ChannelingModule> LOADER;

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private static void tryStrike(Level level, @Nullable LivingEntity attacker, BlockPos target) {
        LightningBolt lightning;
        if (level instanceof ServerLevel && level.m_46470_() && level.m_45527_(target) && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
            lightning.m_20219_(Vec3.m_82539_((Vec3i)target));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                lightning.m_20879_(player);
            }
            level.m_7967_((Entity)lightning);
            level.m_5594_(null, target, SoundEvents.f_12521_, SoundSource.NEUTRAL, 5.0f, 1.0f);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            ChannelingModule.tryStrike(context.getLevel(), (LivingEntity)context.getPlayerAttacker(), context.getTarget().m_20183_());
        }
    }

    @Override
    public void onLauncherHitEntity(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity attacker, Entity target, @Nullable LivingEntity livingTarget, float damageDealt) {
        ChannelingModule.tryStrike(projectile.m_9236_(), attacker, target.m_20183_());
    }

    @Override
    public void onLauncherHitBlock(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity owner, BlockPos target) {
        ChannelingModule.tryStrike(projectile.m_9236_(), owner, target);
    }

    static {
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.LAUNCHER_HIT);
        LOADER = new SingletonLoader((Object)INSTANCE);
    }
}

