/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.spritetransformer.AnimatedGreyToSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.IRecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.utils.Util;

public class GreyToSpriteTransformer
implements IRecolorSpriteTransformer {
    public static final ResourceLocation NAME = TConstruct.getResource("grey_to_sprite");
    public static final Deserializer<GreyToSpriteTransformer> DESERIALIZER = new Deserializer<GreyToSpriteTransformer>((builder, json) -> builder.build());
    private static final String TEXTURE_FOLDER = "textures";
    @Nullable
    static AbstractSpriteReader READER = null;
    private static final List<SpriteMapping> MAPPINGS_TO_CLEAR = new ArrayList<SpriteMapping>();
    private final List<SpriteMapping> sprites;
    private final SpriteRange[] foundSpriteCache = new SpriteRange[256];
    private static final GreyToColorMapping.Interpolate<SpriteMapping, SpriteRange> SPRITE_RANGE = (first, second, grey) -> new SpriteRange((SpriteMapping)first, (SpriteMapping)second);
    private static final ToIntFunction<SpriteMapping> GET_GREY = SpriteMapping::getGrey;
    private static boolean init = false;

    protected SpriteRange getSpriteRange(int grey) {
        if (this.foundSpriteCache[grey] == null) {
            this.foundSpriteCache[grey] = GreyToColorMapping.getNearestByGrey(this.sprites, GET_GREY, grey, SPRITE_RANGE);
        }
        return this.foundSpriteCache[grey];
    }

    @Override
    public int getNewColor(int color, int x, int y, int f) {
        if (FastColor.ABGR32.m_266503_((int)color) == 0) {
            return 0;
        }
        int grey = GreyToColorMapping.getGrey(color);
        int newColor = this.getSpriteRange(grey).getColor(x, y, grey);
        return GreyToColorMapping.scaleColor(color, newColor, grey);
    }

    @Override
    public int getFallbackColor() {
        return this.getSpriteRange(216).getAverage(216);
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        JsonArray colors = new JsonArray();
        for (SpriteMapping mapping : this.sprites) {
            JsonObject pair = new JsonObject();
            pair.addProperty("grey", (Number)mapping.grey);
            if (mapping.color != -1 || mapping.path == null) {
                pair.addProperty("color", String.format("%08X", Util.translateColorBGR(mapping.color)));
            }
            if (mapping.path != null) {
                pair.addProperty("path", mapping.path.toString());
            }
            colors.add((JsonElement)pair);
        }
        object.add("palette", (JsonElement)colors);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromBlack() {
        return GreyToSpriteTransformer.builder().addABGR(0, -16777216);
    }

    public static void init() {
        if (!init) {
            init = true;
            ISpriteTransformer.SERIALIZER.registerDeserializer(NAME, DESERIALIZER);
            ISpriteTransformer.SERIALIZER.registerDeserializer(AnimatedGreyToSpriteTransformer.NAME, AnimatedGreyToSpriteTransformer.DESERIALIZER);
            MaterialPartTextureGenerator.registerCallback(GreyToSpriteTransformer::textureCallback);
        }
    }

    private static void textureCallback(@Nullable ExistingFileHelper existingFileHelper, @Nullable ResourceManager manager) {
        if (READER != null) {
            MAPPINGS_TO_CLEAR.forEach(mapping -> {
                mapping.image = null;
            });
            MAPPINGS_TO_CLEAR.clear();
            READER.closeAll();
            READER = null;
        }
        if (existingFileHelper != null) {
            READER = new DataGenSpriteReader(existingFileHelper, TEXTURE_FOLDER);
        } else if (manager != null) {
            READER = new ResourceManagerSpriteReader(manager, TEXTURE_FOLDER);
        }
    }

    protected GreyToSpriteTransformer(List<SpriteMapping> sprites) {
        this.sprites = sprites;
    }

    protected record SpriteRange(@Nullable SpriteMapping before, @Nullable SpriteMapping after) {
        public int getColor(int x, int y, int grey) {
            return this.getColor(x, y, -1, grey);
        }

        public int getColor(int x, int y, int frame, int grey) {
            if (this.before == null) {
                assert (this.after != null);
                return this.after.getColor(x, y, frame);
            }
            if (this.after == null || this.before.isSame(this.after)) {
                return this.before.getColor(x, y, frame);
            }
            return GreyToColorMapping.interpolateColors(this.before.getColor(x, y, frame), this.before.getGrey(), this.after.getColor(x, y, frame), this.after.getGrey(), grey);
        }

        public int getAverage(int grey) {
            if (this.before == null) {
                assert (this.after != null);
                return this.after.getAverage();
            }
            if (this.after == null || this.before.isSame(this.after)) {
                return this.before.getAverage();
            }
            return GreyToColorMapping.interpolateColors(this.before.getAverage(), this.before.getGrey(), this.after.getAverage(), this.after.getGrey(), grey);
        }
    }

    static class SpriteMapping {
        private final int grey;
        private final int color;
        @Nullable
        private final ResourceLocation path;
        private transient NativeImage image = null;

        @Nullable
        private NativeImage getImage() {
            if (this.path != null && this.image == null) {
                if (READER == null) {
                    throw new IllegalStateException("Cannot get image for a sprite without reader");
                }
                try {
                    this.image = READER.read(this.path);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to load required image", ex);
                }
                MAPPINGS_TO_CLEAR.add(this);
            }
            return this.image;
        }

        public int getColor(int x, int y, int frame) {
            NativeImage image;
            if (this.path != null && (image = this.getImage()) != null) {
                int spriteColor;
                if (frame == -1) {
                    spriteColor = image.m_84985_(x % image.m_84982_(), y % image.m_85084_());
                } else {
                    int width = image.m_84982_();
                    spriteColor = image.m_84985_(x % width, (y % width + frame * width) % image.m_85084_());
                }
                if (this.color != -1) {
                    spriteColor = GreyToColorMapping.scaleColor(spriteColor, this.color, 255);
                }
                return spriteColor;
            }
            return this.color;
        }

        public int getAverage() {
            NativeImage image;
            if (this.path != null && (image = this.getImage()) != null) {
                int red = 0;
                int green = 0;
                int blue = 0;
                int alpha = 0;
                for (int x = 0; x < image.m_84982_(); ++x) {
                    for (int y = 0; y < image.m_85084_(); ++y) {
                        int color = image.m_84985_(x, y);
                        red += FastColor.ABGR32.m_266313_((int)color);
                        green += FastColor.ABGR32.m_266446_((int)color);
                        blue += FastColor.ABGR32.m_266247_((int)color);
                        alpha += FastColor.ABGR32.m_266503_((int)color);
                    }
                }
                int pixels = image.m_84982_() * image.m_85084_();
                int spriteColor = FastColor.ABGR32.m_266248_((int)(alpha / pixels), (int)(blue / pixels), (int)(green / pixels), (int)(red / pixels));
                if (this.color != -1) {
                    spriteColor = GreyToColorMapping.scaleColor(spriteColor, this.color, 255);
                }
                return spriteColor;
            }
            return this.color;
        }

        public boolean isSame(SpriteMapping other) {
            return this == other || this.color == other.color && Objects.equals(this.path, other.path);
        }

        private SpriteMapping(int grey, int color, @Nullable ResourceLocation path) {
            this.grey = grey;
            this.color = color;
            this.path = path;
        }

        public int getGrey() {
            return this.grey;
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<SpriteMapping> builder = ImmutableList.builder();
        private int lastGrey = -1;

        private void checkGrey(int grey) {
            if (grey < 0 || grey > 255) {
                throw new IllegalArgumentException("Invalid grey value, must be between 0 and 255, inclusive");
            }
            if (grey <= this.lastGrey) {
                throw new IllegalArgumentException("Grey value must be greater than the previous value");
            }
            this.lastGrey = grey;
        }

        public Builder addABGR(int grey, int color) {
            this.checkGrey(grey);
            this.builder.add((Object)new SpriteMapping(grey, color, null));
            return this;
        }

        public Builder addARGB(int grey, int color) {
            return this.addABGR(grey, Util.translateColorBGR(color));
        }

        public Builder addTexture(int grey, ResourceLocation texture, int tint) {
            this.checkGrey(grey);
            this.builder.add((Object)new SpriteMapping(grey, Util.translateColorBGR(tint), texture));
            return this;
        }

        public Builder addTexture(int grey, ResourceLocation texture) {
            return this.addTexture(grey, texture, -1);
        }

        public GreyToSpriteTransformer build() {
            ImmutableList list = this.builder.build();
            if (list.size() < 2) {
                throw new IllegalStateException("Too few colors in palette, must have at least 2");
            }
            return new GreyToSpriteTransformer((List<SpriteMapping>)list);
        }

        public AnimatedGreyToSpriteTransformer animated(ResourceLocation metaPath, int frames) {
            ImmutableList list = this.builder.build();
            if (list.size() < 2) {
                throw new IllegalStateException("Too few colors in palette, must have at least 2");
            }
            return new AnimatedGreyToSpriteTransformer((List<SpriteMapping>)list, metaPath, frames);
        }
    }

    protected record Deserializer<T extends GreyToSpriteTransformer>(BiFunction<Builder, JsonObject, T> constructor) implements JsonDeserializer<T>
    {
        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            JsonArray palette = GsonHelper.m_13933_((JsonObject)object, (String)"palette");
            Builder paletteBuilder = GreyToSpriteTransformer.builder();
            for (int i = 0; i < palette.size(); ++i) {
                JsonObject palettePair = GsonHelper.m_13918_((JsonElement)palette.get(i), (String)("palette[" + i + "]"));
                int grey = GsonHelper.m_13927_((JsonObject)palettePair, (String)"grey");
                if (i == 0 && grey != 0) {
                    paletteBuilder.addABGR(0, -16777216);
                }
                int color = ColorLoadable.ALPHA.getOrWhite(palettePair, "color");
                if (palettePair.has("path")) {
                    paletteBuilder.addTexture(grey, JsonHelper.getResourceLocation((JsonObject)palettePair, (String)"path"), color);
                    continue;
                }
                paletteBuilder.addARGB(grey, color);
            }
            return (T)((GreyToSpriteTransformer)this.constructor.apply(paletteBuilder, object));
        }
    }
}

