/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.Mantle;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierManager;

public class TinkerTags {
    static boolean tagsLoaded = false;

    public static void init() {
        Blocks.init();
        Items.init();
        Fluids.init();
        EntityTypes.init();
        TileEntityTypes.init();
        Biomes.init();
        Modifiers.init();
        Materials.init();
        DamageTypes.init();
        MenuTypes.init();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TagsUpdatedEvent.class, event -> {
            tagsLoaded = true;
        });
    }

    private static <R> TagKey<R> hiddenFromRecipeViewers(ResourceKey<? extends Registry<R>> registry) {
        return TagKey.m_203882_(registry, (ResourceLocation)new ResourceLocation("c", "hidden_from_recipe_viewers"));
    }

    public static boolean isTagsLoaded() {
        return tagsLoaded;
    }

    public static class Blocks {
        public static final TagKey<Block> WORKBENCHES = Blocks.common("workbenches");
        public static final TagKey<Block> TABLES = Blocks.local("tables");
        public static final TagKey<Block> GLASS_PANES_SILICA = Blocks.common("glass_panes/silica");
        public static final TagKey<Block> STONE = Blocks.common("normal_stone");
        public static final TagKey<Block> GRANITE = Blocks.common("granite");
        public static final TagKey<Block> DIORITE = Blocks.common("diorite");
        public static final TagKey<Block> ANDESITE = Blocks.common("andesite");
        public static final TagKey<Block> BLACKSTONE = Blocks.common("blackstone");
        public static final TagKey<Block> DEEPSLATE = Blocks.common("deepslate");
        public static final TagKey<Block> BASALT = Blocks.common("basalt");
        public static final TagKey<Block> TRANSPARENT_OVERLAY = Blocks.local("transparent_overlay");
        public static final TagKey<Block> PLANKLIKE = Blocks.local("planklike");
        public static final TagKey<Block> WORKSTATION_ROCK = Blocks.local("workstation_rock");
        public static final TagKey<Block> ANVIL_METAL = Blocks.local("anvil_metal");
        public static final TagKey<Block> SMELTERY_BRICKS = Blocks.local("smeltery_bricks");
        public static final TagKey<Block> FOUNDRY_BRICKS = Blocks.local("foundry_bricks");
        public static final TagKey<Block> PLATFORM_CONNECTIONS = Blocks.local("platform_connections");
        public static final TagKey<Block> COPPER_PLATFORMS = Blocks.local("copper_platforms");
        public static final TagKey<Block> SKY_SLIME_SPAWN = Blocks.local("slime_spawn/sky");
        public static final TagKey<Block> EARTH_SLIME_SPAWN = Blocks.local("slime_spawn/earth");
        public static final TagKey<Block> ENDER_SLIME_SPAWN = Blocks.local("slime_spawn/ender");
        public static final TagKey<Block> SLIME_BLOCK = Blocks.local("slime_block");
        public static final TagKey<Block> CONGEALED_SLIME = Blocks.local("congealed_slime");
        public static final TagKey<Block> SLIMY_LOGS = Blocks.local("slimy_logs");
        public static final TagKey<Block> SLIMY_PLANKS = Blocks.local("slimy_planks");
        public static final TagKey<Block> SLIMY_LEAVES = Blocks.local("slimy_leaves");
        public static final TagKey<Block> SLIMY_VINES = Blocks.local("slimy_vines");
        public static final TagKey<Block> SLIMY_SAPLINGS = Blocks.local("slimy_saplings");
        public static final TagKey<Block> ENDERBARK_ROOTS = Blocks.local("enderbark/roots");
        public static final TagKey<Block> SLIMY_GRASS = Blocks.local("slimy_grass");
        public static final TagKey<Block> SLIMY_NYLIUM = Blocks.local("slimy_nylium");
        public static final TagKey<Block> SLIMY_SOIL = Blocks.local("slimy_soil");
        public static final TagKey<Block> ENDERBARK_LOGS_CAN_GROW_THROUGH = Blocks.local("enderbark/logs_can_grow_through");
        public static final TagKey<Block> ENDERBARK_ROOTS_CAN_GROW_THROUGH = Blocks.local("enderbark/roots_can_grow_through");
        public static final TagKey<Block> SLIMY_FUNGUS_CAN_GROW_THROUGH = Blocks.local("slimy_fungus_can_grow_through");
        public static final TagKey<Block> ORES_COBALT = Blocks.common("ores/cobalt");
        public static final TagKey<Block> RAW_BLOCK_COBALT = Blocks.common("storage_blocks/raw_cobalt");
        public static final TagKey<Block> SEARED_BLOCKS = Blocks.local("seared_blocks");
        public static final TagKey<Block> SEARED_BRICKS = Blocks.local("seared_bricks");
        public static final TagKey<Block> SEARED_TANKS = Blocks.local("seared_tanks");
        public static final TagKey<Block> SCORCHED_BLOCKS = Blocks.local("scorched_blocks");
        public static final TagKey<Block> SCORCHED_TANKS = Blocks.local("scorched_tanks");
        public static final TagKey<Block> HEATER_CONTROLLERS = Blocks.local("heater_controllers");
        public static final TagKey<Block> FUEL_TANKS = Blocks.local("fuel_tanks");
        public static final TagKey<Block> ALLOYER_TANKS = Blocks.local("alloyer_tanks");
        public static final TagKey<Block> STRUCTURE_AIR = Blocks.local("structure_air");
        public static final TagKey<Block> SMELTERY = Blocks.local("smeltery");
        public static final TagKey<Block> SMELTERY_TANKS = Blocks.local("smeltery/tanks");
        public static final TagKey<Block> SMELTERY_FLOOR = Blocks.local("smeltery/floor");
        public static final TagKey<Block> SMELTERY_WALL = Blocks.local("smeltery/wall");
        public static final TagKey<Block> FOUNDRY = Blocks.local("foundry");
        public static final TagKey<Block> FOUNDRY_TANKS = Blocks.local("foundry/tanks");
        public static final TagKey<Block> FOUNDRY_FLOOR = Blocks.local("foundry/floor");
        public static final TagKey<Block> FOUNDRY_WALL = Blocks.local("foundry/wall");
        public static final TagKey<Block> MINABLE_WITH_MATTOCK = Blocks.local("mineable/mattock");
        public static final TagKey<Block> MINABLE_WITH_PICKADZE = Blocks.local("mineable/pickadze");
        public static final TagKey<Block> MINABLE_WITH_HAND_AXE = Blocks.local("mineable/hand_axe");
        public static final TagKey<Block> MINABLE_WITH_SCYTHE = Blocks.local("mineable/scythe");
        public static final TagKey<Block> MINABLE_WITH_SWORD = Blocks.common("mineable/sword");
        public static final TagKey<Block> MINABLE_WITH_SHEARS = Blocks.common("mineable/shears");
        public static final TagKey<Block> MINABLE_WITH_DAGGER = Blocks.local("mineable/dagger");
        public static final TagKey<Block> MINEABLE_MELTING_BLACKLIST = Blocks.local("mineable/melting_blacklist");
        public static final TagKey<Block> UNREPLACABLE_BY_LIQUID = Blocks.local("unreplacable_by_liquid");
        public static final TagKey<Block> HARVESTABLE = Blocks.local("harvestable");
        public static final TagKey<Block> HARVESTABLE_CROPS = Blocks.local("harvestable/crops");
        public static final TagKey<Block> HARVESTABLE_INTERACT = Blocks.local("harvestable/interact");
        public static final TagKey<Block> HARVESTABLE_STACKABLE = Blocks.local("harvestable/stackable");
        public static final TagKey<Block> TREE_LOGS = Blocks.local("tree_log");
        public static final TagKey<Block> CHRYSOPHILITE_ORES = Blocks.local("chrysophilite_ores");
        public static final TagKey<Block> BUDDING = Blocks.common("budding");
        public static final TagKey<Block> CISTERN_CONNECTIONS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("ceramics", "cistern_connections"));

        private static void init() {
        }

        private static TagKey<Block> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)TConstruct.getResource(name));
        }

        private static TagKey<Block> common(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)Mantle.commonResource((String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> WORKBENCHES = Items.common("workbenches");
        public static final TagKey<Item> TABLES = Items.local("tables");
        public static final TagKey<Item> GLASS_PANES_SILICA = Items.common("glass_panes/silica");
        public static final TagKey<Item> STONE = Items.common("normal_stone");
        public static final TagKey<Item> GRANITE = Items.common("granite");
        public static final TagKey<Item> DIORITE = Items.common("diorite");
        public static final TagKey<Item> ANDESITE = Items.common("andesite");
        public static final TagKey<Item> BLACKSTONE = Items.common("blackstone");
        public static final TagKey<Item> DEEPSLATE = Items.common("deepslate");
        public static final TagKey<Item> BASALT = Items.common("basalt");
        public static final TagKey<Item> PLANKLIKE = Items.local("planklike");
        public static final TagKey<Item> WORKSTATION_ROCK = Items.local("workstation_rock");
        public static final TagKey<Item> ANVIL_METAL = Items.local("anvil_metal");
        public static final TagKey<Item> SMELTERY_BRICKS = Items.local("smeltery_bricks");
        public static final TagKey<Item> FOUNDRY_BRICKS = Items.local("foundry_bricks");
        public static final TagKey<Item> COPPER_PLATFORMS = Items.local("copper_platforms");
        public static final TagKey<Item> VARIANT_PLANKS = Items.local("wood_variants/planks");
        public static final TagKey<Item> VARIANT_LOGS = Items.local("wood_variants/logs");
        public static final TagKey<Item> SLIME_BLOCK = Items.local("slime_block");
        public static final TagKey<Item> CONGEALED_SLIME = Items.local("congealed_slime");
        public static final TagKey<Item> SLIMY_LOGS = Items.local("slimy_logs");
        public static final TagKey<Item> SLIMY_PLANKS = Items.local("slimy_planks");
        public static final TagKey<Item> SLIMY_LEAVES = Items.local("slimy_leaves");
        public static final TagKey<Item> SLIMY_VINES = Items.local("slimy_vines");
        public static final TagKey<Item> SLIMY_SAPLINGS = Items.local("slimy_saplings");
        public static final TagKey<Item> ENDERBARK_ROOTS = Items.local("enderbark/roots");
        public static final TagKey<Item> SEARED_BLOCKS = Items.local("seared_blocks");
        public static final TagKey<Item> SEARED_BRICKS = Items.local("seared_bricks");
        public static final TagKey<Item> SCORCHED_BLOCKS = Items.local("scorched_blocks");
        public static final TagKey<Item> SMELTERY = Items.local("smeltery");
        public static final TagKey<Item> FOUNDRY = Items.local("foundry");
        public static final TagKey<Item> ORES_COBALT = Items.common("ores/cobalt");
        public static final TagKey<Item> RAW_BLOCK_COBALT = Items.common("storage_blocks/raw_cobalt");
        public static final TagKey<Item> RAW_COBALT = Items.common("raw_materials/cobalt");
        public static final TagKey<Item> NUGGETS_NETHERITE = Items.common("nuggets/netherite");
        public static final TagKey<Item> INGOTS_NETHERITE_SCRAP = Items.common("ingots/netherite_scrap");
        public static final TagKey<Item> NUGGETS_NETHERITE_SCRAP = Items.common("nuggets/netherite_scrap");
        public static final TagKey<Item> NUGGETS_COPPER = Items.common("nuggets/copper");
        public static final TagKey<Item> CASTS = Items.local("casts");
        public static final TagKey<Item> GOLD_CASTS = Items.local("casts/gold");
        public static final TagKey<Item> SAND_CASTS = Items.local("casts/sand");
        public static final TagKey<Item> RED_SAND_CASTS = Items.local("casts/red_sand");
        public static final TagKey<Item> SINGLE_USE_CASTS = Items.local("casts/single_use");
        public static final TagKey<Item> MULTI_USE_CASTS = Items.local("casts/multi_use");
        public static final TagKey<Item> BLANK_SINGLE_USE_CASTS = Items.local("casts/single_use/blank");
        public static final TagKey<Item> TABLE_EMPTY_CASTS = Items.local("casts/empty/table");
        public static final TagKey<Item> BASIN_EMPTY_CASTS = Items.local("casts/empty/basin");
        public static final TagKey<Item> PROXY_TANK_BLACKLIST = Items.local("proxy_tank_blacklist");
        public static final TagKey<Item> PATTERNS = Items.local("patterns");
        public static final TagKey<Item> DEFAULT_PATTERNS = Items.local("patterns/default");
        public static final TagKey<Item> REUSABLE_PATTERNS = Items.local("patterns/reusable");
        public static final TagKey<Item> SEARED_TANKS = Items.local("seared_tanks");
        public static final TagKey<Item> SCORCHED_TANKS = Items.local("scorched_tanks");
        public static final TagKey<Item> TANKS = Items.local("tanks");
        public static final TagKey<Item> BONES = Items.local("bones");
        public static final TagKey<Item> WITHER_BONES = Items.common("wither_bones");
        public static final TagKey<Item> WEIRD_WITHER_BONES_TAG = Items.common("bones/wither");
        public static final TagKey<Item> BOOKS = Items.common("books");
        public static final TagKey<Item> GUIDEBOOKS = Items.common("books/guide");
        public static final TagKey<Item> TINKERS_GUIDES = Items.local("guides");
        public static final TagKey<Item> GENERAL_STRUCTURE_DEBUG = Items.local("structure_debug/general");
        public static final TagKey<Item> SMELTERY_DEBUG = Items.local("structure_debug/smeltery");
        public static final TagKey<Item> FOUNDRY_DEBUG = Items.local("structure_debug/foundry");
        public static final TagKey<Item> DUCT_CONTAINERS = Items.local("duct_containers");
        public static final TagKey<Item> SEEDS = Items.local("seeds");
        public static final TagKey<Item> SLIMY_SEEDS = Items.local("slimy_grass_seeds");
        public static final TagKey<Item> STONESHIELDS = Items.local("stoneshields");
        public static final TagKey<Item> FIREBALLS = Items.local("fireballs");
        public static final TagKey<Item> TOOL_INVENTORY_BLACKLIST = Items.local("inventory_blacklist");
        public static final TagKey<Item> CHRYSOPHILITE_ORES = Items.local("chrysophilite_ores");
        public static final TagKey<Item> NON_SINGULAR_ORE_RATES = Items.local("non_singular_ore_rates");
        public static final TagKey<Item> AUTOSMELT_BLACKLIST = Items.local("autosmelt_blacklist");
        public static final TagKey<Item> AUTOSMELT_PLUS_BLACKLIST = Items.common("autosmelt_plus_blacklist");
        public static final TagKey<Item> CHEST_PARTS = Items.local("chest_parts");
        public static final TagKey<Item> TOOL_PARTS = Items.local("parts");
        public static final TagKey<Item> BARTERED_PARTS = Items.local("parts/bartered");
        public static final TagKey<Item> MODIFIABLE = Items.local("modifiable");
        public static final TagKey<Item> BONUS_SLOTS = Items.local("modifiable/bonus_slots");
        public static final TagKey<Item> MULTIPART_TOOL = Items.local("modifiable/multipart");
        public static final TagKey<Item> SINGLEPART_TOOL = Items.local("modifiable/multipart/single");
        public static final TagKey<Item> AOE = Items.local("modifiable/aoe");
        public static final TagKey<Item> DURABILITY = Items.local("modifiable/durability");
        public static final TagKey<Item> SMALL_TOOLS = Items.local("modifiable/small");
        public static final TagKey<Item> BROAD_TOOLS = Items.local("modifiable/broad");
        public static final TagKey<Item> SPECIAL_TOOLS = Items.local("modifiable/special");
        public static final TagKey<Item> ANCIENT_TOOLS = Items.local("modifiable/ancient");
        public static final TagKey<Item> TRADER_TOOLS = Items.local("modifiable/wandering_trader");
        public static final TagKey<Item> LOOT_CAPABLE_TOOL = Items.local("modifiable/loot_capable_tool");
        public static final TagKey<Item> HELD = Items.local("modifiable/held");
        public static final TagKey<Item> INTERACTABLE = Items.local("modifiable/interactable");
        public static final TagKey<Item> INTERACTABLE_RIGHT = Items.local("modifiable/interactable/right");
        public static final TagKey<Item> INTERACTABLE_CHARGE = Items.local("modifiable/interactable/charge");
        public static final TagKey<Item> INTERACTABLE_CHARGE_MODIFIER = Items.local("modifiable/interactable/charge/modifier");
        public static final TagKey<Item> INTERACTABLE_LEFT = Items.local("modifiable/interactable/left");
        public static final TagKey<Item> INTERACTABLE_ARMOR = Items.local("modifiable/interactable/armor");
        public static final TagKey<Item> INTERACTABLE_DUAL = Items.local("modifiable/interactable/dual");
        public static final TagKey<Item> MELEE = Items.local("modifiable/melee");
        public static final TagKey<Item> MELEE_WEAPON = Items.local("modifiable/melee/weapon");
        public static final TagKey<Item> MELEE_PRIMARY = Items.local("modifiable/melee/primary");
        public static final TagKey<Item> SWORD = Items.local("modifiable/melee/sword");
        public static final TagKey<Item> UNARMED = Items.local("modifiable/melee/unarmed");
        public static final TagKey<Item> PARRY = Items.local("modifiable/melee/parry");
        public static final TagKey<Item> HARVEST = Items.local("modifiable/harvest");
        public static final TagKey<Item> HARVEST_PRIMARY = Items.local("modifiable/harvest/primary");
        public static final TagKey<Item> STONE_HARVEST = Items.local("modifiable/harvest/stone");
        public static final TagKey<Item> ARMOR = Items.local("modifiable/armor");
        public static final TagKey<Item> BOOTS = Items.local("modifiable/armor/boots");
        public static final TagKey<Item> LEGGINGS = Items.local("modifiable/armor/leggings");
        public static final TagKey<Item> CHESTPLATES = Items.local("modifiable/armor/chestplate");
        public static final TagKey<Item> HELMETS = Items.local("modifiable/armor/helmets");
        public static final TagKey<Item> WORN_ARMOR = Items.local("modifiable/armor/worn");
        public static final TagKey<Item> HELD_ARMOR = Items.local("modifiable/armor/held");
        public static final TagKey<Item> SHIELDS = Items.local("modifiable/shields");
        @Deprecated(forRemoval=true)
        public static final TagKey<Item> GOLDEN_ARMOR = Items.local("modifiable/armor/golden");
        public static final TagKey<Item> BOOK_ARMOR = Items.local("modifiable/book_armor");
        public static final TagKey<Item> BASIC_ARMOR = Items.local("modifiable/book_armor/materials_and_you");
        public static final TagKey<Item> PUNY_ARMOR = Items.local("modifiable/book_armor/puny_smelting");
        public static final TagKey<Item> MIGHTY_ARMOR = Items.local("modifiable/book_armor/mighty_smelting");
        public static final TagKey<Item> FANTASTIC_ARMOR = Items.local("modifiable/book_armor/fantastic_foundry");
        public static final TagKey<Item> GADGETRY_ARMOR = Items.local("modifiable/book_armor/tinkers_gadgetry");
        public static final TagKey<Item> RANGED = Items.local("modifiable/ranged");
        public static final TagKey<Item> LAUNCHERS = Items.local("modifiable/ranged/launcher");
        public static final TagKey<Item> BOWS = Items.local("modifiable/ranged/bows");
        public static final TagKey<Item> LONGBOWS = Items.local("modifiable/ranged/longbows");
        public static final TagKey<Item> CROSSBOWS = Items.local("modifiable/ranged/crossbows");
        public static final TagKey<Item> STAFFS = Items.local("modifiable/staffs");
        public static final TagKey<Item> FISHING_RODS = Items.local("modifiable/fishing_rods");
        public static final TagKey<Item> EMBELLISHMENT_WOOD = Items.local("modifiable/embellishment/wood");
        public static final TagKey<Item> EMBELLISHMENT_SLIME = Items.local("modifiable/embellishment/slime");
        public static final TagKey<Item> DYEABLE = Items.local("modifiable/dyeable");
        public static final TagKey<Item> TRIM = Items.local("modifiable/armor/trim");
        public static final TagKey<Item> UNRECYCLABLE = Items.local("modifiable/unrecyclable");
        public static final TagKey<Item> UNSALVAGABLE = Items.local("modifiable/unsalvageable");
        public static final TagKey<Item> SCYTHES = Items.common("tools/scythe");
        public static final TagKey<Item> SPLASH_BOTTLE = Items.common("bottles/splash");
        public static final TagKey<Item> LINGERING_BOTTLE = Items.common("bottles/lingering");
        public static final TagKey<Item> URANIUM_INGOTS = Items.common("ingots/uranium");
        public static final TagKey<Item> BOSS_TROPHIES = Items.local("boss_trophies");
        public static final TagKey<Item> HIDDEN_IN_RECIPE_VIEWERS = TinkerTags.hiddenFromRecipeViewers(Registries.f_256913_);

        private static void init() {
        }

        private static TagKey<Item> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)TConstruct.getResource(name));
        }

        private static TagKey<Item> common(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Mantle.commonResource((String)name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> SLIME = Fluids.local("slime");
        public static final TagKey<Fluid> SLIME_TOOLTIPS = Fluids.local("tooltips/slime");
        public static final TagKey<Fluid> BOTTLE_TOOLTIPS = Fluids.local("tooltips/bottle");
        public static final TagKey<Fluid> CLAY_TOOLTIPS = Fluids.local("tooltips/clay");
        public static final TagKey<Fluid> METAL_TOOLTIPS = Fluids.local("tooltips/metal");
        public static final TagKey<Fluid> LARGE_GEM_TOOLTIPS = Fluids.local("tooltips/gem_large");
        public static final TagKey<Fluid> SMALL_GEM_TOOLTIPS = Fluids.local("tooltips/gem_small");
        public static final TagKey<Fluid> GLASS_TOOLTIPS = Fluids.local("tooltips/glass");
        @Deprecated(forRemoval=true)
        public static final TagKey<Fluid> SOUP_TOOLTIPS = Fluids.local("tooltips/soup");
        @Deprecated(forRemoval=true)
        public static final TagKey<Fluid> CLAY_SPILLING = Fluids.local("spilling/clay");
        @Deprecated(forRemoval=true)
        public static final TagKey<Fluid> GLASS_SPILLING = Fluids.local("spilling/glass");
        @Deprecated(forRemoval=true)
        public static final TagKey<Fluid> CHEAP_METAL_SPILLING = Fluids.local("spilling/metal/cheap");
        @Deprecated(forRemoval=true)
        public static final TagKey<Fluid> AVERAGE_METAL_SPILLING = Fluids.local("spilling/metal/average");
        @Deprecated(forRemoval=true)
        public static final TagKey<Fluid> EXPENSIVE_METAL_SPILLING = Fluids.local("spilling/metal/expensive");
        public static final TagKey<Fluid> HIDE_IN_CREATIVE_TANKS = Fluids.local("hide_in_creative_tanks");
        public static final TagKey<Fluid> HIDDEN_IN_RECIPE_VIEWERS = TinkerTags.hiddenFromRecipeViewers(Registries.f_256808_);
        public static final TagKey<Fluid> CHEMTHROWER_BLOCK_EFFECTS = Fluids.local("chemthrower_effects/block");
        public static final TagKey<Fluid> CHEMTHROWER_ENTITY_EFFECTS = Fluids.local("chemthrower_effects/entity");
        public static final TagKey<Fluid> CHEMTHROWER_BOTH_EFFECTS = Fluids.local("chemthrower_effects/both");

        private static void init() {
        }

        private static TagKey<Fluid> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)TConstruct.getResource(name));
        }
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> SLIMES = EntityTypes.common("slimes");
        public static final TagKey<EntityType<?>> BACON_PRODUCER = EntityTypes.local("bacon_producer");
        public static final TagKey<EntityType<?>> MELTING_SHOW = EntityTypes.local("melting/show_in_default");
        public static final TagKey<EntityType<?>> MELTING_HIDE = EntityTypes.local("melting/hide_in_default");
        public static final TagKey<EntityType<?>> PIGGYBACKPACK_BLACKLIST = EntityTypes.local("piggybackpack_blacklist");
        public static final TagKey<EntityType<?>> CREEPERS = EntityTypes.common("creepers");
        public static final TagKey<EntityType<?>> VILLAGERS = EntityTypes.common("villagers");
        public static final TagKey<EntityType<?>> ILLAGERS = EntityTypes.common("illagers");
        public static final TagKey<EntityType<?>> PIGLINS = EntityTypes.common("piglins");
        public static final TagKey<EntityType<?>> KILLAGERS = EntityTypes.local("killagers");
        public static final TagKey<EntityType<?>> RARE_MOBS = EntityTypes.local("rare_mobs");
        public static final TagKey<EntityType<?>> SMALL_ARMOR = EntityTypes.common("small_armor");
        public static final TagKey<EntityType<?>> COLLECTABLES = EntityTypes.common("collectables");
        public static final TagKey<EntityType<?>> REFLECTING_BLACKLIST = EntityTypes.common("reflecting/blacklist");
        public static final TagKey<EntityType<?>> REFLECTING_PRESERVE_OWNER = EntityTypes.common("reflecting/preserve_owner");

        private static void init() {
        }

        private static TagKey<EntityType<?>> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)TConstruct.getResource(name));
        }

        private static TagKey<EntityType<?>> common(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Mantle.commonResource((String)name));
        }
    }

    public static class TileEntityTypes {
        public static final TagKey<BlockEntityType<?>> SIDE_INVENTORIES = TileEntityTypes.local("side_inventories");

        private static void init() {
        }

        private static TagKey<BlockEntityType<?>> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256922_, (ResourceLocation)TConstruct.getResource(name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> EARTHSLIME_ISLANDS = Biomes.local("islands/earthslime");
        public static final TagKey<Biome> SKYSLIME_ISLANDS = Biomes.local("islands/skyslime");
        public static final TagKey<Biome> CLAY_ISLANDS = Biomes.local("islands/clay");
        public static final TagKey<Biome> BLOOD_ISLANDS = Biomes.local("islands/blood");
        public static final TagKey<Biome> ENDERSLIME_ISLANDS = Biomes.local("islands/enderslime");

        private static void init() {
        }

        private static TagKey<Biome> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)TConstruct.getResource(name));
        }
    }

    public static class Modifiers {
        public static final TagKey<Modifier> GEMS = Modifiers.local("gems");
        public static final TagKey<Modifier> INVISIBLE_INK_BLACKLIST = Modifiers.local("invisible_ink_blacklist");
        public static final TagKey<Modifier> EXTRACT_MODIFIER_BLACKLIST = Modifiers.local("extract_blacklist/tools");
        public static final TagKey<Modifier> EXTRACT_SLOTLESS_BLACKLIST = Modifiers.local("extract_blacklist/slotless");
        public static final TagKey<Modifier> EXTRACT_UPGRADE_BLACKLIST = Modifiers.local("extract_blacklist/upgrade");
        public static final TagKey<Modifier> BLOCK_WHILE_CHARGING = Modifiers.local("block_while_charging");
        public static final TagKey<Modifier> DUAL_INTERACTION = Modifiers.local("dual_interaction");
        public static final TagKey<Modifier> SLIME_DEFENSE = Modifiers.local("slime_defense");
        public static final TagKey<Modifier> OVERSLIME_FRIEND = Modifiers.local("overslime_friend");
        public static final TagKey<Modifier> AOE_INTERACTION = Modifiers.local("aoe_interaction");
        public static final TagKey<Modifier> CHARGE_EMPTY_BOW_WITH_DRAWTIME = Modifiers.local("charge_empty_bow/with_drawtime");
        public static final TagKey<Modifier> CHARGE_EMPTY_BOW_WITHOUT_DRAWTIME = Modifiers.local("charge_empty_bow/without_drawtime");
        public static final TagKey<Modifier> UPGRADES = Modifiers.local("upgrades");
        public static final TagKey<Modifier> GENERAL_UPGRADES = Modifiers.local("upgrades/general");
        public static final TagKey<Modifier> MELEE_UPGRADES = Modifiers.local("upgrades/melee");
        public static final TagKey<Modifier> DAMAGE_UPGRADES = Modifiers.local("upgrades/damage");
        public static final TagKey<Modifier> HARVEST_UPGRADES = Modifiers.local("upgrades/harvest");
        public static final TagKey<Modifier> RANGED_UPGRADES = Modifiers.local("upgrades/ranged");
        public static final TagKey<Modifier> ARMOR_UPGRADES = Modifiers.local("upgrades/armor");
        public static final TagKey<Modifier> GENERAL_ARMOR_UPGRADES = Modifiers.local("upgrades/armor/general");
        public static final TagKey<Modifier> HELMET_UPGRADES = Modifiers.local("upgrades/armor/helmet");
        public static final TagKey<Modifier> CHESTPLATE_UPGRADES = Modifiers.local("upgrades/armor/chestplate");
        public static final TagKey<Modifier> LEGGING_UPGRADES = Modifiers.local("upgrades/armor/leggings");
        public static final TagKey<Modifier> BOOT_UPGRADES = Modifiers.local("upgrades/armor/boots");
        public static final TagKey<Modifier> ABILITIES = Modifiers.local("abilities");
        public static final TagKey<Modifier> GENERAL_ABILITIES = Modifiers.local("abilities/general");
        public static final TagKey<Modifier> INTERACTION_ABILITIES = Modifiers.local("abilities/interaction");
        public static final TagKey<Modifier> MELEE_ABILITIES = Modifiers.local("abilities/melee");
        public static final TagKey<Modifier> HARVEST_ABILITIES = Modifiers.local("abilities/harvest");
        public static final TagKey<Modifier> RANGED_ABILITIES = Modifiers.local("abilities/ranged");
        public static final TagKey<Modifier> ARMOR_ABILITIES = Modifiers.local("abilities/armor");
        public static final TagKey<Modifier> GENERAL_ARMOR_ABILITIES = Modifiers.local("abilities/armor/general");
        public static final TagKey<Modifier> HELMET_ABILITIES = Modifiers.local("abilities/armor/helmet");
        public static final TagKey<Modifier> CHESTPLATE_ABILITIES = Modifiers.local("abilities/armor/chestplate");
        public static final TagKey<Modifier> LEGGING_ABILITIES = Modifiers.local("abilities/armor/leggings");
        public static final TagKey<Modifier> BOOT_ABILITIES = Modifiers.local("abilities/armor/boots");
        public static final TagKey<Modifier> SHIELD_ABILITIES = Modifiers.local("abilities/armor/shield");
        public static final TagKey<Modifier> DEFENSE = Modifiers.local("defense");
        public static final TagKey<Modifier> PROTECTION_DEFENSE = Modifiers.local("defense/protection");
        public static final TagKey<Modifier> SPECIAL_DEFENSE = Modifiers.local("defense/special");
        public static final TagKey<Modifier> SLOTLESS = Modifiers.local("slotless");
        public static final TagKey<Modifier> GENERAL_SLOTLESS = Modifiers.local("slotless/general");
        public static final TagKey<Modifier> BONUS_SLOTLESS = Modifiers.local("slotless/bonus");
        public static final TagKey<Modifier> HIDDEN_FROM_RECIPE_VIEWERS = TinkerTags.hiddenFromRecipeViewers(ModifierManager.REGISTRY_KEY);

        private static void init() {
        }

        private static TagKey<Modifier> local(String name) {
            return ModifierManager.getTag(TConstruct.getResource(name));
        }
    }

    public static class Materials {
        public static final TagKey<IMaterial> NETHER = Materials.local("nether");
        public static final TagKey<IMaterial> BARTERED = Materials.local("bartered");
        public static final TagKey<IMaterial> EXCLUDE_FROM_LOOT = Materials.local("exclude_from_loot");
        public static final TagKey<IMaterial> GENERAL = Materials.local("melee_harvest/general");
        public static final TagKey<IMaterial> MELEE = Materials.local("melee_harvest/melee");
        public static final TagKey<IMaterial> HARVEST = Materials.local("melee_harvest/harvest");
        public static final TagKey<IMaterial> BALANCED = Materials.local("ranged/balanced");
        public static final TagKey<IMaterial> LIGHT = Materials.local("ranged/light");
        public static final TagKey<IMaterial> HEAVY = Materials.local("ranged/heavy");

        private static void init() {
        }

        private static TagKey<IMaterial> local(String name) {
            return MaterialManager.getTag(TConstruct.getResource(name));
        }
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> MELEE_PROTECTION = DamageTypes.local("protection/melee");
        public static final TagKey<DamageType> PROJECTILE_PROTECTION = DamageTypes.local("protection/projectile");
        public static final TagKey<DamageType> FIRE_PROTECTION = DamageTypes.local("protection/fire");
        public static final TagKey<DamageType> BLAST_PROTECTION = DamageTypes.local("protection/blast");
        public static final TagKey<DamageType> MAGIC_PROTECTION = DamageTypes.local("protection/magic");
        public static final TagKey<DamageType> FALL_PROTECTION = DamageTypes.local("protection/fall");

        private static void init() {
        }

        private static TagKey<DamageType> local(String name) {
            return TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)TConstruct.getResource(name));
        }
    }

    public static class MenuTypes {
        public static final TagKey<MenuType<?>> TOOL_INVENTORY_REPLACEMENTS = TagKey.m_203882_((ResourceKey)Registries.f_256798_, (ResourceLocation)TConstruct.getResource("tool_inventory_replacements"));

        private static void init() {
        }
    }
}

