/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.entity.CombatFishingHook;

public enum FishingModule implements ModifierModule,
GeneralInteractionModifierHook,
ToolActionModifierHook,
EquipmentChangeModifierHook,
DisplayNameModifierHook
{
    INSTANCE;

    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final RecordLoadable<FishingModule> LOADER;

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        return InteractionSource.formatModifierName(tool, entry.getModifier(), name);
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return toolAction == ToolActions.FISHING_ROD_CAST;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source != InteractionSource.ARMOR && !tool.isBroken() && tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            Level level = player.m_9236_();
            if (player.f_36083_ != null) {
                int damage;
                ItemStack stack = player.m_21120_(hand);
                if (!level.f_46443_ && (damage = player.f_36083_.m_37156_(stack)) > 0) {
                    ToolDamageUtil.damageAnimated(tool, damage, (LivingEntity)player, Util.getSlotType(hand));
                    player.m_36335_().m_41524_(tool.getItem(), (int)(20.0f / ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED)));
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                player.m_146850_(GameEvent.f_223697_);
            } else {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                if (!level.f_46443_) {
                    float luck = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.SEA_LUCK);
                    float lure = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.LURE);
                    float velocity = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.VELOCITY);
                    float inaccuracy = ModifierUtil.getInaccuracy(tool, (LivingEntity)player);
                    CombatFishingHook hook = new CombatFishingHook(player, level, (int)luck, (int)lure, velocity, inaccuracy);
                    hook.setPower(ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.PROJECTILE_DAMAGE));
                    ModifierNBT modifiers = tool.getModifiers();
                    hook.getCapability(EntityModifierCapability.CAPABILITY).ifPresent(cap -> cap.setModifiers(modifiers));
                    ModDataNBT arrowData = PersistentDataCapability.getOrWarn((Entity)hook);
                    for (ModifierEntry entry : modifiers.getModifiers()) {
                        entry.getHook(ModifierHooks.PROJECTILE_LAUNCH).onProjectileLaunch(tool, entry, (LivingEntity)player, ItemStack.f_41583_, (Projectile)hook, null, arrowData, true);
                    }
                    level.m_7967_((Entity)hook);
                    ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, hand);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
                player.m_146850_(GameEvent.f_223698_);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        LivingEntity livingEntity = context.getEntity();
        if (livingEntity instanceof Player) {
            IToolStackView replacement;
            Player player = (Player)livingEntity;
            if (!(player.f_36083_ == null || (replacement = context.getReplacementTool()) != null && replacement.getModifiers().equals(tool.getModifiers()))) {
                player.f_36083_.m_146870_();
            }
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context, EquipmentSlot slotType) {
        LivingEntity livingEntity;
        if (slotType == EquipmentSlot.OFFHAND && context.getChangedSlot() == EquipmentSlot.MAINHAND && (livingEntity = context.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_36083_ != null && !context.getOriginal().canPerformAction(ToolActions.FISHING_ROD_CAST) && context.getReplacement().canPerformAction(ToolActions.FISHING_ROD_CAST)) {
                player.f_36083_.m_146870_();
            }
        }
    }

    static {
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_ACTION, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.DISPLAY_NAME);
        LOADER = new SingletonLoader((Object)INSTANCE);
    }
}

