/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.ToolActions;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.modules.technical.SlotInChargeModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public record KnockbackCounterModule(TinkerDataCapability.TinkerDataKey<SlotInChargeModule.SlotInCharge> slotInCharge, LevelingValue chance, LevelingValue flat, LevelingValue random, int durabilityUsage, IJsonPredicate<LivingEntity> defender, IJsonPredicate<LivingEntity> attacker, ModifierCondition<IToolStackView> condition) implements CounterModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ON_ATTACKED);
    public static final RecordLoadable<KnockbackCounterModule> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.mappedField((id, error) -> TinkerDataCapability.TinkerDataKey.of(id)), CounterModule.CHANCE_FIELD, (RecordField)LevelingValue.LOADABLE.defaultField("flat_knockback", (Object)LevelingValue.ZERO, KnockbackCounterModule::flat), (RecordField)LevelingValue.LOADABLE.defaultField("random_knockback", (Object)LevelingValue.ZERO, KnockbackCounterModule::random), CounterModule.DURABILITY_FIELD, CounterModule.DEFENDER_FIELD, CounterModule.ATTACKER_FIELD, ModifierCondition.TOOL_FIELD, KnockbackCounterModule::new);

    public static CounterModule.Builder<KnockbackCounterModule> builder() {
        return new CounterModule.Builder<KnockbackCounterModule>((chance, flat, random, durabilityUsage, defender, attacker, condition) -> new KnockbackCounterModule(TConstruct.createKey("dummy"), (LevelingValue)chance, (LevelingValue)flat, (LevelingValue)random, (int)durabilityUsage, (IJsonPredicate<LivingEntity>)defender, (IJsonPredicate<LivingEntity>)attacker, (ModifierCondition<IToolStackView>)condition));
    }

    @Override
    public LevelingValue constant() {
        return this.flat;
    }

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addModules(ModuleHookMap.Builder builder) {
        builder.addModule(new SlotInChargeModule(this.slotInCharge));
    }

    @Override
    @Deprecated
    public void applyEffect(IToolStackView tool, ModifierEntry modifier, float value, EquipmentContext context, Entity attacker, DamageSource source, float damageDealt) {
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float damageDealt, boolean isDirectDamage) {
        LivingEntity attacker;
        Entity entity;
        LivingEntity defender = context.getEntity();
        if (isDirectDamage && !defender.m_9236_().f_46443_ && this.condition.matches(tool, modifier) && this.defender.matches((Object)defender) && (entity = source.m_7639_()) instanceof LivingEntity && this.attacker.matches((Object)(attacker = (LivingEntity)entity)) && SlotInChargeModule.isInCharge(context.getTinkerData(), this.slotInCharge, slotType)) {
            EquipmentSlot checkSlot;
            IToolStackView iToolStackView;
            EquipmentSlot blockingSlot = null;
            if (defender.m_6117_() && (iToolStackView = context.getValidTool(checkSlot = Util.getSlotType(defender.m_7655_()))) != null && ModifierUtil.canPerformAction(iToolStackView, ToolActions.SHIELD_BLOCK) && defender.m_6844_(checkSlot).m_41779_() - defender.m_21212_() >= 5) {
                blockingSlot = checkSlot;
            }
            float bestBonus = 0.0f;
            for (EquipmentSlot bouncingSlot : EquipmentSlot.values()) {
                IToolStackView bouncingTool = context.getToolInSlot(bouncingSlot);
                if (bouncingTool == null || bouncingTool.isBroken() || !bouncingTool.hasTag(TinkerTags.Items.ARMOR)) continue;
                float level = modifier.getEffectiveLevel();
                if (bouncingSlot == blockingSlot) {
                    level *= 2.0f;
                }
                if (!(TConstruct.RANDOM.nextFloat() < this.chance.compute(level))) continue;
                float newBonus = LevelingValue.applyRandom(level, this.flat, this.random);
                if (newBonus > bestBonus) {
                    bestBonus = newBonus;
                }
                if (this.durabilityUsage <= 0 || !(newBonus > 0.0f)) continue;
                ToolDamageUtil.damageAnimated(tool, this.durabilityUsage, defender, bouncingSlot);
            }
            if (bestBonus > 0.0f) {
                float f = attacker.m_146908_() * (float)Math.PI / 180.0f;
                attacker.m_147240_((double)bestBonus, (double)(-Mth.m_14031_((float)f)), (double)Mth.m_14089_((float)f));
            }
        }
    }
}

