/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.LauncherHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.ability.fluid.UseFluidOnHitModifier;

public record SpillingModule(LevelingValue level, ModifierCondition<IToolStackView> condition) implements ModifierModule,
MeleeHitModifierHook,
LauncherHitModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.LAUNCHER_HIT);
    public static final RecordLoadable<SpillingModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.directField(SpillingModule::level), ModifierCondition.TOOL_FIELD, SpillingModule::new);

    public RecordLoadable<SpillingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private void applyEffect(IToolStackView tool, ModifierEntry modifier, LivingEntity attacker, @Nullable Player playerAttacker, Entity target, @Nullable LivingEntity livingTarget) {
        int consumed;
        FluidEffects recipe;
        FluidStack fluid;
        if (this.condition.matches(tool, modifier) && !(fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEntityEffects() && (consumed = recipe.applyToEntity(fluid, this.level.compute(modifier.getEffectiveLevel()), FluidEffectContext.builder(attacker.m_9236_()).user(attacker, playerAttacker).target(target, livingTarget), IFluidHandler.FluidAction.EXECUTE)) > 0 && (playerAttacker == null || !playerAttacker.m_7500_())) {
            UseFluidOnHitModifier.spawnParticles(target, fluid);
            fluid.shrink(consumed);
            ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (damageDealt > 0.0f && context.isFullyCharged()) {
            this.applyEffect(tool, modifier, context.getAttacker(), context.getPlayerAttacker(), context.getTarget(), context.getLivingTarget());
        }
    }

    @Override
    public void onToolProjectileHit(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity attacker, Entity target, @Nullable LivingEntity livingTarget, float damageDealt) {
        if (damageDealt > 0.0f) {
            this.applyEffect(tool, modifier, attacker, ModifierUtil.asPlayer((Entity)attacker), target, livingTarget);
        }
    }
}

