/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class ThrownTool
extends ThrownTrident {
    protected static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(ThrownTool.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Nullable
    private IToolStackView tool = null;
    private float charge = 1.0f;

    public ThrownTool(EntityType<? extends ThrownTrident> type, Level level) {
        super(type, level);
    }

    public ThrownTool(Level level, LivingEntity shooter, ItemStack stack, IToolStackView tool, float charge) {
        this((EntityType<? extends ThrownTrident>)((EntityType)TinkerTools.thrownTool.get()), level);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        this.f_37555_ = stack.m_255036_(1);
        this.f_19804_.m_135381_(STACK, (Object)this.f_37555_);
        this.f_19804_.m_135381_(f_37558_, (Object)((byte)tool.getModifiers().getLevel(ModifierIds.loyalty)));
        this.f_19804_.m_135381_(f_37554_, (Object)tool.getVolatileData().getBoolean(ModifiableItem.SHINY));
        this.charge = charge;
    }

    public boolean m_150194_() {
        return false;
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || this.f_37555_.m_41619_()) {
            ++this.f_36697_;
            if (this.f_36697_ >= 1200) {
                this.m_146870_();
            }
        } else if ((Byte)this.f_19804_.m_135370_(f_37558_) == 0 && this.getTool().getVolatileData().getBoolean(IndestructibleItemEntity.INDESTRUCTIBLE_ENTITY)) {
            ++this.f_36697_;
            if (this.f_36697_ >= 6000) {
                this.m_146870_();
            }
        }
    }

    private IToolStackView getTool() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.f_37555_);
        }
        return this.tool;
    }

    public void m_8119_() {
        if (!this.f_37556_ && this.f_36704_ > 4) {
            if (!this.f_37555_.m_41619_()) {
                LivingEntity l;
                Entity entity;
                ToolDamageUtil.damage(this.getTool(), 1, (entity = this.m_19749_()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null, this.f_37555_);
            }
            this.f_37556_ = true;
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity;
        this.f_37556_ = true;
        if (!this.f_37555_.m_41619_() && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Entity target = pResult.m_82443_();
            ItemStack offhand = owner.m_21206_();
            owner.m_21008_(InteractionHand.OFF_HAND, this.f_37555_);
            IToolStackView tool = this.getTool();
            if (ToolAttackUtil.attackEntity(tool, owner, InteractionHand.OFF_HAND, target, () -> this.charge, false, EquipmentSlot.OFFHAND, (Projectile)this)) {
                if (target.m_6095_() == EntityType.f_20566_ && tool.getModifiers().getLevel(TinkerModifiers.enderference.getId()) == 0) {
                    owner.m_21008_(InteractionHand.OFF_HAND, offhand);
                    return;
                }
                if (target instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)target;
                    this.m_7761_(living);
                }
            }
            owner.m_21008_(InteractionHand.OFF_HAND, offhand);
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
            this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
    }

    public ItemStack getToolItem() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Trident", 10)) {
            this.f_19804_.m_135381_(STACK, (Object)this.f_37555_);
            this.f_19804_.m_135381_(f_37558_, (Object)((byte)ModifierUtil.getModifierLevel(this.f_37555_, ModifierIds.loyalty)));
        }
    }
}

