/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import slimeknights.mantle.util.CombatHelper;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithKnockback;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;

public class CombatFishingHook
extends FishingHook
implements ProjectileWithKnockback,
ProjectileWithPower {
    private static final float PI = (float)Math.PI;
    private static final float GRAPPLE_STRENGTH = 0.58f;
    private static final EntityDataAccessor<Boolean> GRAPPLE = SynchedEntityData.m_135353_(CombatFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float power = 0.0f;
    private float knockback = 0.0f;
    private double impactVelocity = 1.0;
    private BlockState wallState = null;

    public CombatFishingHook(EntityType<? extends FishingHook> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setGrapple(false);
    }

    public CombatFishingHook(Player player, Level level, int luck, int lure, float velocity, float inaccuracy) {
        super((EntityType)TinkerTools.fishingHook.get(), level, luck, lure);
        this.setGrapple(false);
        this.m_5602_((Entity)player);
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        float yAngle = -yRot * (float)Math.PI / 180.0f - (float)Math.PI;
        float dz = Mth.m_14089_((float)yAngle);
        float dx = Mth.m_14031_((float)yAngle);
        this.m_7678_(player.m_20185_() - (double)dx * 0.3, player.m_20188_(), player.m_20189_() - (double)dz * 0.3, yRot, xRot);
        float xAngle = -xRot * ((float)Math.PI / 180);
        float yCos = -Mth.m_14089_((float)xAngle);
        float ySin = Mth.m_14031_((float)xAngle);
        Vec3 deltaMovement = new Vec3((double)(-dx), (double)Mth.m_14036_((float)(-ySin / yCos), (float)-5.0f, (float)5.0f), (double)(-dz));
        double length = deltaMovement.m_82553_();
        double maxRandom = 0.03 * (double)inaccuracy * (double)inaccuracy;
        deltaMovement = deltaMovement.m_82542_((double)velocity / length + this.f_19796_.m_216328_(0.5, maxRandom), (double)velocity / length + this.f_19796_.m_216328_(0.5, maxRandom), (double)velocity / length + this.f_19796_.m_216328_(0.5, maxRandom));
        this.m_20256_(deltaMovement);
        this.m_146922_((float)(Mth.m_14136_((double)deltaMovement.f_82479_, (double)deltaMovement.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)deltaMovement.f_82480_, (double)deltaMovement.m_165924_()) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GRAPPLE, (Object)false);
    }

    @Override
    public void addKnockback(float amount) {
        this.knockback += amount;
    }

    public void setGrapple(boolean value) {
        this.f_19804_.m_135381_(GRAPPLE, (Object)value);
    }

    public boolean isGrapple() {
        return (Boolean)this.f_19804_.m_135370_(GRAPPLE);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.impactVelocity = this.m_20184_().m_82553_();
    }

    protected void m_150155_(Entity target) {
        Entity owner = this.m_19749_();
        if (owner != null) {
            if (this.power > 0.0f && !(target instanceof ItemEntity)) {
                float oldHealth;
                if (owner instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)owner;
                    living.m_21335_(target);
                }
                float damage = (float)Mth.m_14165_((double)Mth.m_14008_((double)(this.impactVelocity * (double)this.power * 10.0), (double)0.0, (double)2.147483647E9)) / 10.0f;
                DamageSource source = CombatHelper.damageSource(TinkerDamageTypes.FISHING_HOOK, (Entity)this, (Entity)owner);
                LivingEntity targetLiving = ToolAttackUtil.getLivingEntity(target);
                AttributeInstance knockback = ToolAttackUtil.disableKnockback(targetLiving);
                float f = oldHealth = targetLiving != null ? targetLiving.m_21223_() : 0.0f;
                if (target.m_6469_(source, damage) && !this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    LivingEntity ownerLiving = (LivingEntity)owner;
                    if (targetLiving != null) {
                        EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)owner);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)ownerLiving, (Entity)target);
                    ItemStack stack = ownerLiving.m_21205_();
                    if ((stack.canPerformAction(ToolActions.FISHING_ROD_CAST) || (stack = ownerLiving.m_21206_()).canPerformAction(ToolActions.FISHING_ROD_CAST)) && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                        float damageDealt = damage;
                        if (targetLiving != null) {
                            damageDealt = oldHealth - targetLiving.m_21223_();
                        }
                        ToolStack tool = ToolStack.from(stack);
                        for (ModifierEntry modifier : tool.getModifiers()) {
                            modifier.getHook(ModifierHooks.TOOL_PROJECTILE_HIT).onToolProjectileHit(tool, modifier, (Projectile)this, ownerLiving, target, targetLiving, damageDealt);
                        }
                    }
                }
                ToolAttackUtil.enableKnockback(knockback);
            }
            Vec3 knockback = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20186_() - this.m_20186_(), owner.m_20189_() - this.m_20189_());
            float scale = 0.1f;
            if (this.knockback > 0.0f) {
                scale = (float)((double)scale + (double)(this.knockback * 0.25f) * Mth.m_264555_((double)knockback.m_82556_()));
            }
            target.m_20256_(target.m_20184_().m_82549_(knockback.m_82490_((double)scale)));
        }
    }

    public int m_37156_(ItemStack stack) {
        Entity owner = this.m_19749_();
        if (this.isGrapple() && (this.m_20096_() || this.wallState != null) && owner != null) {
            Vec3 knockback = new Vec3(this.m_20185_() - owner.m_20185_(), this.m_20186_() - owner.m_20186_(), this.m_20189_() - owner.m_20189_());
            knockback = knockback.m_82490_((double)0.58f * Math.pow(knockback.m_82556_(), -0.25));
            owner.m_5997_(knockback.f_82479_, knockback.f_82480_, knockback.f_82481_);
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(player.m_19879_(), player.m_20184_()));
            }
            return Math.max(2, super.m_37156_(stack));
        }
        return super.m_37156_(stack);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.isGrapple()) {
            this.m_6853_(true);
            this.wallState = this.m_9236_().m_8055_(result.m_82425_());
            Vec3 hit = result.m_82450_();
            Vec3 offset = hit.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20256_(offset);
            this.m_20343_(hit.f_82479_, hit.f_82480_, hit.f_82481_);
        }
    }

    private boolean shouldFall() {
        return this.wallState != null && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.wallState = null;
        Vec3 velocity = this.m_20184_();
        this.m_20256_(velocity.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
        this.f_37103_ = 0;
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        if (type == MoverType.SELF && this.wallState != null) {
            if (this.wallState != this.m_9236_().m_8055_(this.m_20183_()) && this.shouldFall()) {
                this.startFalling();
            } else {
                return;
            }
        }
        super.m_6478_(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void m_8119_() {
        int oldLife = this.f_37103_;
        super.m_8119_();
        if (this.wallState != null && !this.m_9236_().f_46443_) {
            this.f_37103_ = oldLife + 1;
            if (this.f_37103_ >= 1200) {
                this.m_146870_();
            }
        }
    }

    @Override
    public float getPower() {
        return this.power;
    }

    @Override
    public void setPower(float power) {
        this.power = power;
    }
}

