/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.BlockEntityHelper;

public class FluidUpdatePacket
implements IThreadsafePacket {
    protected final BlockPos pos;
    protected final FluidStack fluid;

    public FluidUpdatePacket(BlockPos pos, FluidStack fluid) {
        this.pos = pos;
        this.fluid = fluid;
    }

    public FluidUpdatePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.fluid = buffer.readFluidStack();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeFluidStack(this.fluid);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(FluidUpdatePacket packet) {
            BlockEntityHelper.get(IFluidPacketReceiver.class, (BlockGetter)Minecraft.m_91087_().f_91073_, (BlockPos)packet.pos).ifPresent(te -> te.updateFluidTo(packet.fluid));
        }
    }

    public static interface IFluidPacketReceiver {
        public void updateFluidTo(FluidStack var1);
    }
}

