/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.recipe.casting.CastDuplicationRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ItemCastingRecipeBuilder
extends AbstractRecipeBuilder<ItemCastingRecipeBuilder> {
    private final ItemOutput result;
    private final TypeAwareRecipeSerializer<? extends ItemCastingRecipe> recipeSerializer;
    private Ingredient cast = Ingredient.f_43901_;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = -1;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static ItemCastingRecipeBuilder basinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (TypeAwareRecipeSerializer<? extends ItemCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder retexturedBasinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (TypeAwareRecipeSerializer<? extends ItemCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.retexturedBasinRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder basinRecipe(ItemLike resultIn) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromItem((ItemLike)resultIn));
    }

    public static ItemCastingRecipeBuilder basinRecipe(TagKey<Item> result) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromTag(result));
    }

    public static ItemCastingRecipeBuilder basinDuplication() {
        return ItemCastingRecipeBuilder.castingRecipe(ItemOutput.EMPTY, (TypeAwareRecipeSerializer<? extends ItemCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinDuplicationRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (TypeAwareRecipeSerializer<? extends ItemCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder retexturedTableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (TypeAwareRecipeSerializer<? extends ItemCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.retexturedTableRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ItemLike resultIn) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromItem((ItemLike)resultIn));
    }

    public static ItemCastingRecipeBuilder tableRecipe(TagKey<Item> result) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromTag(result));
    }

    public static ItemCastingRecipeBuilder tableDuplication() {
        return ItemCastingRecipeBuilder.castingRecipe(ItemOutput.EMPTY, (TypeAwareRecipeSerializer<? extends ItemCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableDuplicationRecipeSerializer.get()));
    }

    public ItemCastingRecipeBuilder setFluid(Fluid fluid, int amount) {
        return this.setFluid((FluidIngredient)FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    public ItemCastingRecipeBuilder setFluid(TagKey<Fluid> tagIn, int amount) {
        return this.setFluid((FluidIngredient)FluidIngredient.of(tagIn, (int)amount));
    }

    public ItemCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public ItemCastingRecipeBuilder setCoolingTime(int temperature, int amount) {
        return this.setCoolingTime(ICastingRecipe.calcCoolingTime(temperature, amount));
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of((FluidStack)fluidStack);
        if (this.coolingTime == -1) {
            this.coolingTime = ICastingRecipe.calcCoolingTime(fluidStack);
        }
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, int amount) {
        this.setFluid(fluid.ingredient(amount));
        this.setCoolingTime(IMeltingRecipe.getTemperature(fluid), amount);
        return this;
    }

    public ItemCastingRecipeBuilder setCast(TagKey<Item> tagIn, boolean consumed) {
        return this.setCast(Ingredient.m_204132_(tagIn), consumed);
    }

    public ItemCastingRecipeBuilder setCast(ItemLike itemIn, boolean consumed) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}), consumed);
    }

    public ItemCastingRecipeBuilder setCast(Ingredient ingredient, boolean consumed) {
        this.cast = ingredient;
        this.consumed = consumed;
        return this;
    }

    public ItemCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, BuiltInRegistries.f_257033_.m_7981_((Object)this.result.get().m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        if (this.result == ItemOutput.EMPTY) {
            if (this.consumed) {
                throw new IllegalStateException("Cannot consume cast on a duplication recipe");
            }
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new CastDuplicationRecipe(this.recipeSerializer, id, this.group, this.cast, this.fluid, this.coolingTime), CastDuplicationRecipe.LOADER, advancementId));
        } else {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ItemCastingRecipe(this.recipeSerializer, id, this.group, this.cast, this.fluid, this.result, this.coolingTime, this.consumed && this.cast != Ingredient.f_43901_, this.switchSlots), ItemCastingRecipe.LOADER, advancementId));
        }
    }

    private ItemCastingRecipeBuilder(ItemOutput result, TypeAwareRecipeSerializer<? extends ItemCastingRecipe> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static ItemCastingRecipeBuilder castingRecipe(ItemOutput result, TypeAwareRecipeSerializer<? extends ItemCastingRecipe> recipeSerializer) {
        return new ItemCastingRecipeBuilder(result, recipeSerializer);
    }

    public ItemCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }
}

