/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.capacity.CapacitySourceModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record LootToCapacityModule(Ingredient consume, int amount, LevelingValue chance, @Nullable ModifierId owner, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ProcessLootModifierHook,
CapacitySourceModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROCESS_LOOT);
    public static final RecordLoadable<LootToCapacityModule> LOADER = RecordLoadable.create((RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("consume", LootToCapacityModule::consume), (RecordField)IntLoadable.FROM_ONE.requiredField("amount", LootToCapacityModule::amount), (RecordField)LevelingValue.LOADABLE.requiredField("chance", LootToCapacityModule::chance), (RecordField)OWNER_FIELD, ModifierCondition.TOOL_FIELD, LootToCapacityModule::new);

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        if (!this.condition.matches(tool, modifier)) {
            return;
        }
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        int addedShield = 0;
        float chance = this.chance.compute(modifier.getEffectiveLevel());
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!this.consume.test(stack)) continue;
            if (chance >= 1.0f) {
                addedShield += stack.m_41613_();
                iterator.remove();
                continue;
            }
            int reduced = 0;
            for (int i = 0; i < stack.m_41613_(); ++i) {
                if (!(TConstruct.RANDOM.nextFloat() < chance)) continue;
                ++reduced;
            }
            if (reduced == stack.m_41613_()) {
                iterator.remove();
            } else {
                stack.m_41774_(reduced);
            }
            addedShield += reduced;
        }
        if (addedShield > 0) {
            ModifierEntry barModifier = this.barModifier(tool, modifier);
            barModifier.getHook(ModifierHooks.CAPACITY_BAR).addAmount(tool, barModifier, addedShield * this.amount);
        }
    }

    public static Builder consume(Ingredient consume) {
        return new Builder(consume);
    }

    public static class Builder
    extends CapacitySourceModule.Builder<Builder>
    implements LevelingValue.Builder<LootToCapacityModule> {
        private final Ingredient consume;
        private int amount;

        @Override
        public LootToCapacityModule amount(float flat, float eachLevel) {
            return new LootToCapacityModule(this.consume, this.amount, new LevelingValue(flat, eachLevel), this.owner, this.condition);
        }

        private Builder(Ingredient consume) {
            this.consume = consume;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }
    }
}

