/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface UsingToolModifierHook {
    default public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
    }

    default public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
    }

    default public void afterStopUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
    }

    public static void afterStopUsing(IToolStackView tool, LivingEntity living, int timeLeft) {
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier(tool);
        int duration = activeModifier.getHook(ModifierHooks.GENERAL_INTERACT).getUseDuration(tool, activeModifier);
        for (ModifierEntry entry : tool.getModifiers()) {
            entry.getHook(ModifierHooks.TOOL_USING).afterStopUsing(tool, entry, living, duration, timeLeft, activeModifier);
        }
    }

    public record AllMerger(Collection<UsingToolModifierHook> modules) implements UsingToolModifierHook
    {
        @Override
        public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
            for (UsingToolModifierHook module : this.modules) {
                module.onUsingTick(tool, modifier, entity, useDuration, timeLeft, activeModifier);
            }
        }

        @Override
        public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
            for (UsingToolModifierHook module : this.modules) {
                module.beforeReleaseUsing(tool, modifier, entity, useDuration, timeLeft, activeModifier);
            }
        }

        @Override
        public void afterStopUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
            for (UsingToolModifierHook module : this.modules) {
                module.afterStopUsing(tool, modifier, entity, useDuration, timeLeft, activeModifier);
            }
        }
    }
}

