/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public interface IMaterial
extends Comparable<IMaterial> {
    public static final MaterialId UNKNOWN_ID = new MaterialId("tconstruct", "unknown");
    public static final IMaterial UNKNOWN = new Material(UNKNOWN_ID, false, true);

    public MaterialId getIdentifier();

    public boolean isCraftable();

    public boolean isHidden();

    public int getTier();

    public int getSortOrder();

    @Override
    default public int compareTo(IMaterial other) {
        if (this.getTier() != other.getTier()) {
            return Integer.compare(this.getTier(), other.getTier());
        }
        if (this.getSortOrder() != other.getSortOrder()) {
            return Integer.compare(this.getSortOrder(), other.getSortOrder());
        }
        return this.getIdentifier().compareTo(other.getIdentifier());
    }

    default public boolean matches(IMaterial other) {
        return this == other || this.getIdentifier().matches(other);
    }
}

