/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.loot.equipment;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.mantle.util.typed.TypedMapBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.loot.equipment.MobEquipment;

public class MobEquipmentManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "tinkering/mob_equipment";
    private static final MobEquipmentManager INSTANCE = new MobEquipmentManager();
    private static final Loadable<List<EntityType<?>>> ENTITY_LIST = Loadables.ENTITY_TYPE.list(1);
    private Map<EntityType<?>, List<MobEquipment>> replacements = Map.of();
    private ICondition.IContext context = ICondition.IContext.EMPTY;

    private MobEquipmentManager() {
        super(JsonHelper.DEFAULT_GSON, FOLDER);
    }

    @ApiStatus.Internal
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, MobSpawnEvent.FinalizeSpawn.class, INSTANCE::finalizeSpawn);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profiler) {
        long time = System.nanoTime();
        int loaded = 0;
        HashMap<EntityType, List> parsed = new HashMap<EntityType, List>();
        Function<EntityType, List> ifAbsent = type -> new ArrayList();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)key.toString());
                if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)this.context)) continue;
                List equipment = (List)MobEquipment.LIST_LOADABLE.getIfPresent(json, "equip", TypedMapBuilder.builder().put((TypedMap.Key)ContextKey.ID, (Object)key).put((TypedMap.Key)ContextKey.DEBUG, (Object)("Mob Equipment " + key)).build());
                JsonElement entityElement = JsonHelper.getElement((JsonObject)json, (String)"entity");
                if (entityElement.isJsonPrimitive()) {
                    String type2 = entityElement.getAsString();
                    if (type2.charAt(0) == '#') {
                        TagKey tag = (TagKey)Loadables.ENTITY_TYPE_TAG.parseString(type2.substring(1), "entity");
                        for (Holder holder : this.context.getTag(tag)) {
                            parsed.computeIfAbsent((EntityType)holder.get(), ifAbsent).addAll(equipment);
                        }
                    } else {
                        parsed.computeIfAbsent((EntityType)Loadables.ENTITY_TYPE.parseString(type2, "entity"), ifAbsent).addAll(equipment);
                    }
                } else if (entityElement.isJsonArray()) {
                    for (EntityType type3 : (List)ENTITY_LIST.convert(entityElement, "entity")) {
                        parsed.computeIfAbsent(type3, ifAbsent).addAll(equipment);
                    }
                } else {
                    throw new JsonSyntaxException("Expected entity to be either a string or an array");
                }
                ++loaded;
            }
            catch (Exception e2) {
                TConstruct.LOG.error("Failed to replacement from {}", (Object)key, (Object)e2);
            }
        }
        this.replacements = parsed.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().sorted(Comparator.comparing(MobEquipment::priority).reversed()).toList()));
        TConstruct.LOG.info("Loaded {} mob equipment replacements targeting {} mobs in {} ms", (Object)loaded, (Object)this.replacements.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public List<MobEquipment> get(EntityType<?> type) {
        return this.replacements.getOrDefault(type, List.of());
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
        this.context = event.getConditionContext();
    }

    private void finalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        List<MobEquipment> equipment = this.get(mob.m_6095_());
        if (!equipment.isEmpty() && MobEquipment.apply(equipment, mob, event)) {
            event.setCanceled(true);
        }
    }
}

