/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.enchantment.Enchantment;
import slimeknights.mantle.data.registry.IdAwareComponentRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ElytraFlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.MaterialRepairModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.RepairFactorModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.RequirementsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.AreaOfEffectHighlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.SlotStackModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class ModifierHooks {
    public static final IdAwareComponentRegistry<ModuleHook<?>> LOADER = new IdAwareComponentRegistry("Unknown Modifier Hook");
    public static final ModuleHook<ConditionalStatModifierHook> CONDITIONAL_STAT = ModifierHooks.register("conditional_stat", ConditionalStatModifierHook.class, ConditionalStatModifierHook.AllMerger::new, (tool, modifier, living, stat, baseValue, multiplier) -> baseValue);
    public static final ModuleHook<ToolActionModifierHook> TOOL_ACTION = ModifierHooks.register("tool_action", ToolActionModifierHook.class, ToolActionModifierHook.AnyMerger::new, (tool, modifier, toolAction) -> false);
    public static final ModuleHook<EquipmentChangeModifierHook> EQUIPMENT_CHANGE = ModifierHooks.register("equipment_change", EquipmentChangeModifierHook.class, EquipmentChangeModifierHook.AllMerger::new, new EquipmentChangeModifierHook(){});
    public static final ModuleHook<RepairFactorModifierHook> REPAIR_FACTOR = ModifierHooks.register("repair_factor", RepairFactorModifierHook.class, RepairFactorModifierHook.ComposeMerger::new, (tool, entry, factor) -> factor);
    public static final ModuleHook<MaterialRepairModifierHook> MATERIAL_REPAIR = ModifierHooks.register("material_repair", MaterialRepairModifierHook.class, MaterialRepairModifierHook.MaxMerger::new, new MaterialRepairModifierHook(){

        @Override
        public boolean isRepairMaterial(IToolStackView tool, ModifierEntry modifier, MaterialId material) {
            return false;
        }

        @Override
        public float getRepairAmount(IToolStackView tool, ModifierEntry modifier, MaterialId material) {
            return 0.0f;
        }
    });
    public static final ModuleHook<ToolDamageModifierHook> TOOL_DAMAGE = ModifierHooks.register("tool_damage", ToolDamageModifierHook.class, ToolDamageModifierHook.Merger::new, (tool, modifier, amount, holder) -> amount);
    public static final ModuleHook<InventoryTickModifierHook> INVENTORY_TICK = ModifierHooks.register("inventory_tick", InventoryTickModifierHook.class, InventoryTickModifierHook.AllMerger::new, (tool, modifier, world, holder, itemSlot, isSelected, isCorrectSlot, stack) -> {});
    public static final ModuleHook<CapacityBarHook> CAPACITY_BAR = ModifierHooks.register("capacity_bar", CapacityBarHook.class, new CapacityBarHook(){

        @Override
        public int getAmount(IToolStackView tool) {
            return 0;
        }

        @Override
        public int getCapacity(IToolStackView tool, ModifierEntry entry) {
            return 0;
        }

        @Override
        public void setAmount(IToolStackView tool, ModifierEntry entry, int amount) {
        }
    });
    public static final ModuleHook<DisplayNameModifierHook> DISPLAY_NAME = ModifierHooks.register("display_name", DisplayNameModifierHook.class, DisplayNameModifierHook.ComposeMerger::new, (tool, entry, name, access) -> name);
    public static final ModuleHook<TooltipModifierHook> TOOLTIP = ModifierHooks.register("tooltip", TooltipModifierHook.class, TooltipModifierHook.AllMerger::new, (tool, modifier, player, tooltip, tooltipKey, tooltipFlag) -> {});
    public static final ModuleHook<DurabilityDisplayModifierHook> DURABILITY_DISPLAY = ModifierHooks.register("durability_display", DurabilityDisplayModifierHook.class, DurabilityDisplayModifierHook.FirstMerger::new, new DurabilityDisplayModifierHook(){

        @Override
        @Nullable
        public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
            return null;
        }

        @Override
        public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
            return 0;
        }

        @Override
        public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
            return -1;
        }
    });
    public static final ModuleHook<RequirementsModifierHook> REQUIREMENTS = ModifierHooks.register("requirements", RequirementsModifierHook.class, RequirementsModifierHook.FirstMerger::new, new RequirementsModifierHook(){});
    public static final ModuleHook<ToolStatsModifierHook> TOOL_STATS = ModifierHooks.register("modifier_stats", ToolStatsModifierHook.class, ToolStatsModifierHook.AllMerger::new, (context, modifier, builder) -> {});
    public static final ModuleHook<AttributesModifierHook> ATTRIBUTES = ModifierHooks.register("attributes", AttributesModifierHook.class, AttributesModifierHook.AllMerger::new, (tool, modifier, slot, consumer) -> {});
    public static final ModuleHook<EnchantmentModifierHook> ENCHANTMENTS = ModifierHooks.register("enchantments", EnchantmentModifierHook.class, EnchantmentModifierHook.AllMerger::new, new EnchantmentModifierHook(){

        @Override
        public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            return level;
        }

        @Override
        public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
        }
    });
    public static final ModuleHook<VolatileDataModifierHook> VOLATILE_DATA = ModifierHooks.register("volatile_data", VolatileDataModifierHook.class, VolatileDataModifierHook.AllMerger::new, (context, modifier, volatileData) -> {});
    public static final ModuleHook<RawDataModifierHook> RAW_DATA = ModifierHooks.register("raw_data", RawDataModifierHook.class, RawDataModifierHook.AllMerger::new, new RawDataModifierHook(){

        @Override
        public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
        }

        @Override
        public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
        }
    });
    public static final ModuleHook<ValidateModifierHook> VALIDATE = ModifierHooks.register("validate", ValidateModifierHook.class, ValidateModifierHook.AllMerger::new, (tool, modifier) -> null);
    public static final ModuleHook<ModifierRemovalHook> REMOVE = ModifierHooks.register("remove", ModifierRemovalHook.class, ModifierRemovalHook.FirstMerger::new, (tool, modifier) -> null);
    public static final ModuleHook<ModifierTraitHook> MODIFIER_TRAITS = ModifierHooks.register("modifier_traits", ModifierTraitHook.class, ModifierTraitHook.AllMerger::new, (context, modifier, builder, firstEncounter) -> {});
    public static final ModuleHook<MeleeDamageModifierHook> MELEE_DAMAGE = ModifierHooks.register("melee_damage", MeleeDamageModifierHook.class, MeleeDamageModifierHook.AllMerger::new, (tool, modifier, context, baseDamage, damage) -> damage);
    public static final ModuleHook<MeleeHitModifierHook> MELEE_HIT = ModifierHooks.register("melee_hit", MeleeHitModifierHook.class, MeleeHitModifierHook.AllMerger::new, new MeleeHitModifierHook(){});
    public static final ModuleHook<ProtectionModifierHook> PROTECTION = ModifierHooks.register("protection", ProtectionModifierHook.class, ProtectionModifierHook.AllMerger::new, (tool, modifier, context, slotType, source, modifierValue) -> modifierValue);
    public static final ModuleHook<DamageBlockModifierHook> DAMAGE_BLOCK = ModifierHooks.register("damage_block", DamageBlockModifierHook.class, DamageBlockModifierHook.AnyMerger::new, (tool, modifier, context, slotType, source, amount) -> false);
    public static final ModuleHook<OnAttackedModifierHook> ON_ATTACKED = ModifierHooks.register("on_attacked", OnAttackedModifierHook.class, OnAttackedModifierHook.AllMerger::new, (tool, modifier, context, slotType, source, amount, isDirectDamage) -> {});
    public static final ModuleHook<ModifyDamageModifierHook> MODIFY_HURT;
    public static final ModuleHook<ModifyDamageModifierHook> MODIFY_DAMAGE;
    public static final ModuleHook<DamageDealtModifierHook> DAMAGE_DEALT;
    public static final ModuleHook<ProcessLootModifierHook> PROCESS_LOOT;
    public static final ModuleHook<LootingModifierHook> WEAPON_LOOTING;
    public static final ModuleHook<ArmorLootingModifierHook> ARMOR_LOOTING;
    public static final ModuleHook<HarvestEnchantmentsModifierHook> HARVEST_ENCHANTMENTS;
    public static final ModuleHook<BreakSpeedModifierHook> BREAK_SPEED;
    public static final ModuleHook<RemoveBlockModifierHook> REMOVE_BLOCK;
    public static final ModuleHook<BlockBreakModifierHook> BLOCK_BREAK;
    public static final ModuleHook<BlockHarvestModifierHook> BLOCK_HARVEST;
    public static final ModuleHook<ProjectileLaunchModifierHook> PROJECTILE_LAUNCH;
    public static final ModuleHook<ProjectileHitModifierHook> PROJECTILE_HIT;
    public static final ModuleHook<BowAmmoModifierHook> BOW_AMMO;
    public static final ModuleHook<ElytraFlightModifierHook> ELYTRA_FLIGHT;
    public static final ModuleHook<ArmorWalkModifierHook> BOOT_WALK;
    public static final ModuleHook<GeneralInteractionModifierHook> GENERAL_INTERACT;
    public static final ModuleHook<UsingToolModifierHook> TOOL_USING;
    public static final ModuleHook<BlockInteractionModifierHook> BLOCK_INTERACT;
    public static final ModuleHook<EntityInteractionModifierHook> ENTITY_INTERACT;
    public static final ModuleHook<KeybindInteractModifierHook> ARMOR_INTERACT;
    public static final ModuleHook<AreaOfEffectHighlightModifierHook> AOE_HIGHLIGHT;
    public static final ModuleHook<SlotStackModifierHook> SLOT_STACK;
    public static final ModuleHook<PlantHarvestModifierHook> PLANT_HARVEST;
    public static final ModuleHook<ShearsModifierHook> SHEAR_ENTITY;
    public static final ModuleHook<BlockTransformModifierHook> BLOCK_TRANSFORM;

    ModifierHooks() {
    }

    public static void init() {
    }

    public static <T> ModuleHook<T> register(ResourceLocation name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return (ModuleHook)LOADER.register(new ModuleHook<T>(name, filter, merger, defaultInstance));
    }

    public static <T> ModuleHook<T> register(ResourceLocation name, Class<T> filter, T defaultInstance) {
        return ModifierHooks.register(name, filter, null, defaultInstance);
    }

    private static <T> ModuleHook<T> register(String name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return ModifierHooks.register(TConstruct.getResource(name), filter, merger, defaultInstance);
    }

    private static <T> ModuleHook<T> register(String name, Class<T> filter, T defaultInstance) {
        return ModifierHooks.register(name, filter, null, defaultInstance);
    }

    static {
        Function<Collection, ModifyDamageModifierHook> merger = ModifyDamageModifierHook.AllMerger::new;
        ModifyDamageModifierHook fallback = (tool, modifier, context, slotType, source, amount, isDirectDamage) -> amount;
        MODIFY_HURT = ModifierHooks.register("modify_hurt", ModifyDamageModifierHook.class, merger, fallback);
        MODIFY_DAMAGE = ModifierHooks.register("modify_damage", ModifyDamageModifierHook.class, merger, fallback);
        DAMAGE_DEALT = ModifierHooks.register("damage_dealt", DamageDealtModifierHook.class, DamageDealtModifierHook.AllMerger::new, (tool, modifier, context, slotType, target, source, amount, isDirectDamage) -> {});
        PROCESS_LOOT = ModifierHooks.register("process_loot", ProcessLootModifierHook.class, ProcessLootModifierHook.AllMerger::new, (tool, modifier, loot, context) -> {});
        WEAPON_LOOTING = ModifierHooks.register("weapon_looting", LootingModifierHook.class, LootingModifierHook.ComposeMerger::new, (tool, modifier, context, looting) -> looting);
        ARMOR_LOOTING = ModifierHooks.register("armor_looting", ArmorLootingModifierHook.class, ArmorLootingModifierHook.ComposeMerger::new, (tool, modifier, context, equipment, slot, looting) -> looting);
        HARVEST_ENCHANTMENTS = ModifierHooks.register("harvest_enchantments", HarvestEnchantmentsModifierHook.class, HarvestEnchantmentsModifierHook.AllMerger::new, (tool, modifier, context, equipment, slot, map) -> {});
        BREAK_SPEED = ModifierHooks.register("break_speed", BreakSpeedModifierHook.class, BreakSpeedModifierHook.AllMerger::new, (tool, modifier, event, sideHit, isEffective, miningSpeedModifier) -> {});
        REMOVE_BLOCK = ModifierHooks.register("remove_block", RemoveBlockModifierHook.class, RemoveBlockModifierHook.FirstMerger::new, (tool, modifier, context) -> null);
        BLOCK_BREAK = ModifierHooks.register("block_break", BlockBreakModifierHook.class, BlockBreakModifierHook.AllMerger::new, (tool, modifier, context) -> {});
        BLOCK_HARVEST = ModifierHooks.register("block_harvest", BlockHarvestModifierHook.class, BlockHarvestModifierHook.AllMerger::new, (tool, modifier, context, didHarvest) -> {});
        PROJECTILE_LAUNCH = ModifierHooks.register("projectile_launch", ProjectileLaunchModifierHook.class, ProjectileLaunchModifierHook.AllMerger::new, (tool, modifier, shooter, projectile, arrow, persistentData, primary) -> {});
        PROJECTILE_HIT = ModifierHooks.register("projectile_hit", ProjectileHitModifierHook.class, ProjectileHitModifierHook.AllMerger::new, new ProjectileHitModifierHook(){});
        BOW_AMMO = ModifierHooks.register("bow_ammo", BowAmmoModifierHook.class, BowAmmoModifierHook.EMPTY);
        ELYTRA_FLIGHT = ModifierHooks.register("elytra_flight", ElytraFlightModifierHook.class, ElytraFlightModifierHook.FirstMerger::new, (tool, modifier, entity, flightTicks) -> false);
        BOOT_WALK = ModifierHooks.register("boot_walk", ArmorWalkModifierHook.class, ArmorWalkModifierHook.AllMerger::new, (tool, modifier, living, prevPos, newPos) -> {});
        GENERAL_INTERACT = ModifierHooks.register("general_interact", GeneralInteractionModifierHook.class, GeneralInteractionModifierHook.FirstMerger::new, (tool, modifier, player, hand, source) -> InteractionResult.PASS);
        TOOL_USING = ModifierHooks.register("tool_using", UsingToolModifierHook.class, UsingToolModifierHook.AllMerger::new, new UsingToolModifierHook(){});
        BLOCK_INTERACT = ModifierHooks.register("block_interact", BlockInteractionModifierHook.class, BlockInteractionModifierHook.FirstMerger::new, new BlockInteractionModifierHook(){});
        ENTITY_INTERACT = ModifierHooks.register("entity_interact", EntityInteractionModifierHook.class, EntityInteractionModifierHook.FirstMerger::new, new EntityInteractionModifierHook(){});
        ARMOR_INTERACT = ModifierHooks.register("armor_interact", KeybindInteractModifierHook.class, KeybindInteractModifierHook.InteractMerger::new, new KeybindInteractModifierHook(){});
        AOE_HIGHLIGHT = ModifierHooks.register("aoe_highlight", AreaOfEffectHighlightModifierHook.class, AreaOfEffectHighlightModifierHook.AnyMerger::new, (tool, modifier, context, pos, state) -> false);
        SLOT_STACK = ModifierHooks.register("slot_stack", SlotStackModifierHook.class, SlotStackModifierHook.FirstMerger::new, new SlotStackModifierHook(){});
        PLANT_HARVEST = ModifierHooks.register("plant_harvest", PlantHarvestModifierHook.class, PlantHarvestModifierHook.AllMerger::new, (tool, modifier, context, world, state, pos) -> {});
        SHEAR_ENTITY = ModifierHooks.register("shear_entity", ShearsModifierHook.class, ShearsModifierHook.AllMerger::new, (tool, modifier, player, entity, isTarget) -> {});
        BLOCK_TRANSFORM = ModifierHooks.register("block_transform", BlockTransformModifierHook.class, BlockTransformModifierHook.AllMerger::new, (tool, modifier, context, state, pos, action) -> {});
    }
}

