/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InteractionHandler {
    public static final EquipmentSlot[] HAND_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    private static final TinkerDataCapability.ComputableDataKey<LastTick> LAST_TICK = TConstruct.createKey("last_tick", LastTick::new);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    static void beforeEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        InteractionSource source = InteractionSource.RIGHT_CLICK;
        if (!stack.m_204117_(TinkerTags.Items.HELD)) {
            if (!stack.m_41619_()) return;
            stack = player.m_6844_(EquipmentSlot.CHEST);
            if (!stack.m_204117_(TinkerTags.Items.INTERACTABLE_ARMOR)) return;
            source = InteractionSource.ARMOR;
        }
        if (player.m_36335_().m_41519_(stack.m_41720_())) return;
        ToolStack tool = ToolStack.from(stack);
        Entity target = event.getTarget();
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = entry.getHook(ModifierHooks.ENTITY_INTERACT).beforeEntityUse(tool, entry, player, target, hand, source);
            if (!result.m_19077_()) continue;
            event.setCanceled(true);
            event.setCancellationResult(result);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void afterEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack chestplate;
        Player player = event.getEntity();
        if (event.getItemStack().m_41619_() && !player.m_5833_() && (chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.INTERACTABLE_ARMOR) && !player.m_36335_().m_41519_(chestplate.m_41720_())) {
            event.setCanceled(true);
            ToolStack tool = ToolStack.from(chestplate);
            Entity target = event.getTarget();
            InteractionHand hand = event.getHand();
            InteractionResult result = target.m_6096_(player, hand);
            if (result.m_19077_()) {
                event.setCancellationResult(result);
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                for (ModifierEntry entry : tool.getModifierList()) {
                    result = entry.getHook(ModifierHooks.ENTITY_INTERACT).afterEntityUse(tool, entry, player, livingTarget, hand, InteractionSource.ARMOR);
                    if (!result.m_19077_()) continue;
                    event.setCanceled(true);
                    event.setCancellationResult(result);
                    return;
                }
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            event.setCancellationResult(result);
        }
    }

    private static InteractionResult onBlockUse(UseOnContext context, IToolStackView tool, ItemStack stack, Function<ModifierEntry, InteractionResult> callback) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockInWorld info = new BlockInWorld((LevelReader)world, context.m_8083_(), false);
        if (player != null && !player.m_150110_().f_35938_ && !stack.m_204121_((Registry)BuiltInRegistries.f_256975_, info)) {
            return InteractionResult.PASS;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = callback.apply(entry);
            if (!result.m_19077_()) continue;
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void chestplateInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack chestplate;
        Player player = event.getEntity();
        if (event.getItemStack().m_41619_() && !player.m_5833_() && (chestplate = player.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.INTERACTABLE_ARMOR) && !player.m_36335_().m_41519_(chestplate.m_41720_())) {
            InteractionResult result;
            InteractionResult result2;
            InteractionResult result3;
            ToolStack tool = ToolStack.from(chestplate);
            InteractionHand hand = event.getHand();
            BlockHitResult trace = event.getHitVec();
            UseOnContext context = new UseOnContext(player, hand, trace);
            if (event.getUseItem() != Event.Result.DENY && (result3 = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getHook(ModifierHooks.BLOCK_INTERACT).beforeBlockUse(tool, (ModifierEntry)entry, context, InteractionSource.ARMOR))).m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(result3);
                return;
            }
            BlockPos pos = event.getPos();
            Event.Result useBlock = event.getUseBlock();
            Level level = player.m_9236_();
            if ((useBlock == Event.Result.ALLOW || useBlock != Event.Result.DENY && (!player.m_36341_() || player.m_21120_(Util.getOpposite(hand)).doesSneakBypassUse((LevelReader)level, pos, player))) && (result2 = level.m_8055_(pos).m_60664_(level, player, hand, trace)).m_19077_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, ItemStack.f_41583_);
                }
                event.setCanceled(true);
                event.setCancellationResult(result2);
                return;
            }
            Event.Result useItem = event.getUseItem();
            event.setCancellationResult(InteractionResult.PASS);
            if (useItem != Event.Result.DENY && (useItem == Event.Result.ALLOW || !player.m_36335_().m_41519_(chestplate.m_41720_())) && (result = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getHook(ModifierHooks.BLOCK_INTERACT).afterBlockUse(tool, (ModifierEntry)entry, context, InteractionSource.ARMOR))).m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, ItemStack.f_41583_);
                }
                return;
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static InteractionResult onChestplateUse(Player player, ItemStack chestplate, InteractionHand hand) {
        if (player.m_36335_().m_41519_(chestplate.m_41720_())) {
            return InteractionResult.PASS;
        }
        ToolStack tool = ToolStack.from(chestplate);
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = entry.getHook(ModifierHooks.GENERAL_INTERACT).onToolUse(tool, entry, player, hand, InteractionSource.ARMOR);
            if (!result.m_19077_()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void onChestplateAttack(AttackEntityEvent event) {
        ToolStack tool;
        ItemStack chestplate;
        Player attacker;
        if (event.getClass() == AttackEntityEvent.class && (attacker = event.getEntity()).m_21205_().m_41619_() && (chestplate = attacker.m_6844_(EquipmentSlot.CHEST)).m_204117_(TinkerTags.Items.UNARMED) && !(tool = ToolStack.from(chestplate)).isBroken()) {
            ToolAttackUtil.attackEntity(tool, (LivingEntity)attacker, InteractionHand.MAIN_HAND, event.getTarget(), ToolAttackUtil.getCooldownFunction(attacker, InteractionHand.MAIN_HAND), false, EquipmentSlot.CHEST);
            event.setCanceled(true);
        }
    }

    public static boolean startArmorInteract(Player player, EquipmentSlot slotType, TooltipKey modifierKey) {
        ItemStack helmet;
        if (!player.m_5833_() && (helmet = player.m_6844_(slotType)).m_204117_(TinkerTags.Items.ARMOR)) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                if (entry.getHook(ModifierHooks.ARMOR_INTERACT).startInteract(tool, entry, player, slotType, modifierKey)) break;
            }
            return true;
        }
        return false;
    }

    public static boolean stopArmorInteract(Player player, EquipmentSlot slotType) {
        ItemStack helmet;
        if (!player.m_5833_() && (helmet = player.m_6844_(slotType)).m_204117_(TinkerTags.Items.ARMOR)) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.ARMOR_INTERACT).stopInteract(tool, entry, player, slotType);
            }
            return true;
        }
        return false;
    }

    private static InteractionResult onLeftClickInteraction(IToolStackView tool, Player player, InteractionHand hand) {
        for (ModifierEntry entry : tool.getModifierList()) {
            InteractionResult result = entry.getHook(ModifierHooks.GENERAL_INTERACT).onToolUse(tool, entry, player, hand, InteractionSource.LEFT_CLICK);
            if (!result.m_19077_()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onLeftClickInteraction(Player player, ItemStack held, InteractionHand hand) {
        if (player.m_36335_().m_41519_(held.m_41720_())) {
            return InteractionResult.PASS;
        }
        return InteractionHandler.onLeftClickInteraction(ToolStack.from(held), player, hand);
    }

    private static void setLeftClickEventResult(PlayerInteractEvent event, InteractionResult result) {
        if (result.m_19077_()) {
            if (result == InteractionResult.SUCCESS) {
                event.getEntity().m_6674_(event.getHand());
            }
            event.setCancellationResult(result);
            if (event.getEntity().m_150110_().f_35937_) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        InteractionResult result;
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCapability(TinkerDataCapability.CAPABILITY).filter(data -> ((LastTick)data.computeIfAbsent(LAST_TICK)).update(player)).isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.m_204117_(TinkerTags.Items.INTERACTABLE_LEFT) || player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        InteractionHand hand = event.getHand();
        BlockPos pos = event.getPos();
        Direction direction = event.getFace();
        if (direction == null) {
            direction = player.m_6350_().m_122424_();
        }
        UseOnContext context = new UseOnContext(player, hand, new BlockHitResult(Util.toHitVec(pos, direction), direction, pos, false));
        ToolStack tool = ToolStack.from(stack);
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            result = entry.getHook(ModifierHooks.BLOCK_INTERACT).beforeBlockUse(tool, entry, context, InteractionSource.LEFT_CLICK);
            if (!result.m_19077_()) continue;
            InteractionHandler.setLeftClickEventResult((PlayerInteractEvent)event, result);
            event.setCanceled(true);
            return;
        }
        for (ModifierEntry entry : modifiers) {
            result = entry.getHook(ModifierHooks.BLOCK_INTERACT).afterBlockUse(tool, entry, context, InteractionSource.LEFT_CLICK);
            if (!result.m_19077_()) continue;
            InteractionHandler.setLeftClickEventResult((PlayerInteractEvent)event, result);
            event.setCanceled(true);
            return;
        }
        InteractionResult result2 = InteractionHandler.onLeftClickInteraction(tool, player, hand);
        if (result2.m_19077_()) {
            InteractionHandler.setLeftClickEventResult((PlayerInteractEvent)event, result2);
        }
    }

    public static boolean canBlock(LivingEntity holder, @Nullable Vec3 sourcePosition, IToolStackView tool) {
        if (sourcePosition == null) {
            return false;
        }
        float blockAngle = ConditionalStatModifierHook.getModifiedStat(tool, holder, ToolStats.BLOCK_ANGLE) / 2.0f;
        Vec3 viewVector = holder.m_20252_(1.0f);
        Vec3 entityPosition = holder.m_20182_();
        Vec3 direction = new Vec3(entityPosition.f_82479_ - sourcePosition.f_82479_, 0.0, entityPosition.f_82481_ - sourcePosition.f_82481_);
        double length = viewVector.m_82553_() * direction.m_82553_();
        if (length < 1.0E-4) {
            return false;
        }
        double angle = Math.abs(180.0 - Math.acos(direction.m_82526_(viewVector) / length) * 57.2957763671875);
        return (double)blockAngle >= angle;
    }

    @SubscribeEvent
    static void onBlock(ShieldBlockEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack activeStack = entity.m_21211_();
        if (!activeStack.m_41619_() && activeStack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = ToolStack.from(activeStack);
            if (!tool.isBroken() && InteractionHandler.canBlock(event.getEntity(), event.getDamageSource().m_7270_(), tool)) {
                event.setBlockedDamage(Math.min(event.getBlockedDamage(), tool.getStats().get(ToolStats.BLOCK_AMOUNT).floatValue()));
                if (entity instanceof Player) {
                    float damage;
                    Player player = (Player)entity;
                    event.setShieldTakesDamage(false);
                    if (!entity.m_9236_().f_46443_) {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
                    }
                    if ((damage = event.getBlockedDamage()) >= 3.0f) {
                        InteractionHand usingHand = entity.m_7655_();
                        if (ToolDamageUtil.damageAnimated((IToolStackView)tool, 1 + Mth.m_14143_((float)damage), entity, usingHand)) {
                            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)activeStack, (InteractionHand)usingHand);
                            entity.m_5810_();
                            entity.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + entity.m_9236_().f_46441_.m_188501_() * 0.4f);
                        }
                    }
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    private static class LastTick {
        private long lastTick = 0L;

        private LastTick() {
        }

        private boolean update(Player player) {
            if ((long)player.f_19797_ >= this.lastTick + 4L) {
                this.lastTick = player.f_19797_;
                return true;
            }
            return false;
        }
    }
}

