/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeLookup;

public record MeltBlockFluidEffect(IJsonPredicate<BlockState> validBlocks, int minAmount, int temperature) implements FluidEffect<FluidEffectContext.Block>
{
    public static final RecordLoadable<MeltBlockFluidEffect> LOADER = RecordLoadable.create((RecordField)BlockPredicate.LOADER.defaultField("blocks", MeltBlockFluidEffect::validBlocks), (RecordField)IntLoadable.FROM_ONE.requiredField("min_amount", MeltBlockFluidEffect::minAmount), (RecordField)IntLoadable.FROM_ONE.requiredField("temperature", MeltBlockFluidEffect::temperature), MeltBlockFluidEffect::new);

    @Override
    public RecordLoadable<MeltBlockFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        BlockPos pos;
        BlockState state = context.getBlockState();
        if (state.m_60795_() || !this.validBlocks.matches((Object)state) || !level.isFull()) {
            return 0.0f;
        }
        Level world = context.getLevel();
        float requirement = state.m_60800_((BlockGetter)world, pos = context.getBlockPos());
        if (requirement < 0.0f || context.breakRestricted()) {
            return 0.0f;
        }
        Item item = state.m_60734_().m_5456_();
        if (item == Items.f_41852_) {
            return 0.0f;
        }
        FluidStack result = MeltingRecipeLookup.findResult((ItemLike)item, this.temperature);
        if (result.isEmpty()) {
            return 0.0f;
        }
        if (action.execute() && !world.f_46443_) {
            BlockState toPlace = Blocks.f_50016_.m_49966_();
            if (result.getAmount() >= this.minAmount) {
                toPlace = result.getFluid().m_76145_().m_76188_();
            } else {
                Fluid fluid2 = result.getFluid();
                if (fluid2 instanceof FlowingFluid) {
                    FlowingFluid flowing = (FlowingFluid)fluid2;
                    int fluidLevel = result.getAmount() * 8 / this.minAmount;
                    if (fluidLevel > 0) {
                        toPlace = flowing.m_75953_(fluidLevel, false).m_76188_();
                    }
                }
            }
            if (world.m_46597_(pos, toPlace)) {
                world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            }
        }
        return 1.0f;
    }
}

