/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.command.RemoveRecipesCommand;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.shared.command.subcommand.GenerateMeltingRecipesCommand;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ConfigurationDataProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, JsonObject> configuration = new LinkedHashMap<ResourceLocation, JsonObject>();

    public ConfigurationDataProvider(PackOutput output) {
        super(output, PackOutput.Target.DATA_PACK, "");
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        JsonObject meltingRecipes = this.config(GenerateMeltingRecipesCommand.MELTING_CONFIGURATION);
        ConfigurationDataProvider.item(meltingRecipes, "melt", (IJsonPredicate<Item>)ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag(TinkerTags.Items.MODIFIABLE), ItemPredicate.tag(TinkerTags.Items.BOOKS), ItemPredicate.tag((TagKey)Tags.Items.DYES), TinkerPredicate.HAS_CONTAINER}).inverted());
        ConfigurationDataProvider.item(meltingRecipes, "inputs", (IJsonPredicate<Item>)ItemPredicate.ANY);
        ConfigurationDataProvider.item(meltingRecipes, "ignore", (IJsonPredicate<Item>)ItemPredicate.ANY);
        meltingRecipes.add("skip_recipes", (JsonElement)new JsonArray());
        JsonObject removeIngots = this.removePreset("ingot_smelting");
        ConfigurationDataProvider.item(removeIngots, "result", (IJsonPredicate<Item>)ItemPredicate.and((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag((TagKey)Tags.Items.INGOTS), ItemPredicate.set((Item[])new Item[]{Items.f_42460_, (Item)TinkerSmeltery.searedBrick.get(), (Item)TinkerSmeltery.scorchedBrick.get()}).inverted(), TinkerPredicate.CASTABLE}));
        ConfigurationDataProvider.item(removeIngots, "input", (IJsonPredicate<Item>)ItemPredicate.ANY);
        ConfigurationDataProvider.recipeType(removeIngots, RecipeType.f_44108_, RecipeType.f_44109_);
        JsonObject removeVanillaTools = this.removePreset("vanilla_tools");
        ConfigurationDataProvider.item(removeVanillaTools, "result", (IJsonPredicate<Item>)ItemPredicate.and((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.or((IJsonPredicate[])new IJsonPredicate[]{ItemPredicate.tag((TagKey)ItemTags.f_271360_), ItemPredicate.tag((TagKey)ItemTags.f_271207_), ItemPredicate.tag((TagKey)ItemTags.f_271138_), ItemPredicate.tag((TagKey)ItemTags.f_271388_), ItemPredicate.tag((TagKey)ItemTags.f_271298_), ItemPredicate.tag((TagKey)Tags.Items.TOOLS_SHIELDS), ItemPredicate.tag((TagKey)Tags.Items.TOOLS_BOWS), ItemPredicate.tag((TagKey)Tags.Items.TOOLS_CROSSBOWS), ItemPredicate.tag((TagKey)Tags.Items.ARMORS), ItemPredicate.set((Item[])new Item[]{Items.f_42409_, Items.f_42574_, Items.f_271356_})}), ItemPredicate.tag(TinkerTags.Items.MODIFIABLE).inverted()}));
        ConfigurationDataProvider.item(removeVanillaTools, "input", (IJsonPredicate<Item>)ItemPredicate.ANY);
        ConfigurationDataProvider.recipeType(removeVanillaTools, RecipeType.f_44107_);
        JsonObject removeNetheriteSmithing = this.removePreset("netherite_smithing");
        ConfigurationDataProvider.item(removeNetheriteSmithing, "result", (IJsonPredicate<Item>)ItemPredicate.set((Item[])new Item[]{Items.f_42395_, Items.f_42396_, Items.f_42394_, Items.f_42393_, Items.f_42397_, Items.f_42480_, Items.f_42481_, Items.f_42482_, Items.f_42483_}));
        ConfigurationDataProvider.item(removeNetheriteSmithing, "input", (IJsonPredicate<Item>)ItemPredicate.ANY);
        ConfigurationDataProvider.recipeType(removeNetheriteSmithing, RecipeType.f_44113_);
        return ConfigurationDataProvider.allOf(this.configuration.entrySet().stream().map(entry -> this.saveJson(output, (ResourceLocation)entry.getKey(), entry.getValue())));
    }

    public String m_6055_() {
        return "Tinkers' Construct Configuration Data Provider";
    }

    private JsonObject config(ResourceLocation location) {
        String path = location.m_135815_();
        return this.configuration.computeIfAbsent(location.m_247449_(path.substring(0, path.length() - ".json".length())), p -> new JsonObject());
    }

    private JsonObject removePreset(String name) {
        return this.config(RemoveRecipesCommand.PRESETS.m_245698_(TConstruct.getResource(name)));
    }

    private static void item(JsonObject json, String key, IJsonPredicate<Item> value) {
        json.add(key, ItemPredicate.LOADER.serialize(value));
    }

    private static void recipeType(JsonObject json, RecipeType<?> ... types) {
        json.add("recipe_type", RemoveRecipesCommand.RECIPE_TYPES.serialize(List.of(types)));
    }
}

