/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.loot.equipment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public record MobEquipment(EquipmentSlot slot, IJsonPredicate<Item> match, ItemOutput tool, List<RandomMaterial> materials, Fluid fluid, float chance, int priority) {
    public static final RecordLoadable<MobEquipment> LOADABLE = RecordLoadable.create((RecordField)TinkerLoadables.EQUIPMENT_SLOT.requiredField("slot", MobEquipment::slot), (RecordField)ItemPredicate.LOADER.defaultField("match", MobEquipment::match), (RecordField)ItemOutput.Loadable.REQUIRED_STACK.requiredField("tool", MobEquipment::tool), (RecordField)RandomMaterial.LOADER.list(0).defaultField("materials", List.of(), false, MobEquipment::materials), (RecordField)Loadables.FLUID.defaultField("fluid", (Object)Fluids.f_76191_, false, MobEquipment::fluid), (RecordField)FloatLoadable.PERCENT.defaultField("chance", (Object)Float.valueOf(0.05f), true, MobEquipment::chance), (RecordField)IntLoadable.FROM_ZERO.defaultField("priority", (Object)100, true, MobEquipment::priority), MobEquipment::new);
    public static final Loadable<List<MobEquipment>> LIST_LOADABLE = LOADABLE.list(-1);

    public static Builder builder() {
        return new Builder();
    }

    public static boolean apply(List<MobEquipment> replace, Mob mob, MobSpawnEvent.FinalizeSpawn event) {
        RandomSource random = mob.m_217043_();
        ArrayList<MobEquipment> apply = new ArrayList<MobEquipment>(replace.size());
        for (MobEquipment slot : replace) {
            if (!(random.m_188501_() < slot.chance())) continue;
            apply.add(slot);
        }
        if (!apply.isEmpty()) {
            ServerLevelAccessor level = event.getLevel();
            mob.m_6518_(level, level.m_6436_(mob.m_20183_()), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
            for (MobEquipment slot : apply) {
                slot.apply(mob);
            }
            return true;
        }
        return false;
    }

    public void apply(Mob mob) {
        if (this.match.matches((Object)mob.m_6844_(this.slot).m_41720_())) {
            ItemStack replacement = this.tool.copy();
            if (replacement.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                ToolStack tool = ToolStack.from(replacement);
                ToolDefinition definition = tool.getDefinition();
                if (definition.hasMaterials() && !this.materials.isEmpty()) {
                    tool.setMaterials(RandomMaterial.build(ToolMaterialHook.stats(definition), this.materials, mob.m_217043_()));
                } else {
                    tool.rebuildStats();
                }
                if (this.fluid != Fluids.f_76191_) {
                    int capacity = ToolTankHelper.TANK_HELPER.getCapacity(tool);
                    int amount = mob.m_217043_().m_188503_(capacity + 1);
                    if (amount > 0) {
                        ToolTankHelper.TANK_HELPER.setFluid(tool, new FluidStack(this.fluid, amount));
                    }
                }
            }
            mob.m_8061_(this.slot, replacement);
        }
    }

    public static class Builder {
        private final List<SlotBuilder> replace = new ArrayList<SlotBuilder>();

        private Builder() {
        }

        public SlotBuilder slot(EquipmentSlot slot) {
            SlotBuilder builder = new SlotBuilder(slot);
            this.replace.add(builder);
            return builder;
        }

        public List<MobEquipment> build() {
            return this.replace.stream().map(SlotBuilder::build).toList();
        }

        public class SlotBuilder {
            private final EquipmentSlot slot;
            private IJsonPredicate<Item> match = ItemPredicate.ANY;
            private ItemOutput tool = null;
            private final List<RandomMaterial> materials = new ArrayList<RandomMaterial>();
            private Fluid fluid = Fluids.f_76191_;
            private float chance = 0.05f;
            private int priority = 100;

            public SlotBuilder tool(ItemOutput tool) {
                this.tool = tool;
                return this;
            }

            public SlotBuilder tool(ItemLike tool) {
                return this.tool(ItemOutput.fromItem((ItemLike)tool));
            }

            public SlotBuilder material(RandomMaterial material) {
                this.materials.add(material);
                return this;
            }

            public SlotBuilder material(RandomMaterial ... materials) {
                Collections.addAll(this.materials, materials);
                return this;
            }

            private MobEquipment build() {
                return new MobEquipment(this.slot, this.match, this.tool, this.materials, this.fluid, this.chance, this.priority);
            }

            public Builder end() {
                return Builder.this;
            }

            public SlotBuilder match(IJsonPredicate<Item> match) {
                this.match = match;
                return this;
            }

            public SlotBuilder fluid(Fluid fluid) {
                this.fluid = fluid;
                return this;
            }

            public SlotBuilder chance(float chance) {
                this.chance = chance;
                return this;
            }

            public SlotBuilder priority(int priority) {
                this.priority = priority;
                return this;
            }

            private SlotBuilder(EquipmentSlot slot) {
                this.slot = slot;
            }
        }
    }
}

