/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public enum MinimapModule implements ModifierModule,
EquipmentChangeModifierHook,
KeybindInteractModifierHook,
InventoryTickModifierHook,
ModifierRemovalHook
{
    INSTANCE;

    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final RecordLoadable<MinimapModule> LOADER;
    public static final TinkerDataCapability.TinkerDataKey<ItemStack> MAP;
    private static final ResourceLocation SELECTED_SLOT;
    private static final Component DISABLED;
    private static final String SELECTED;

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public Integer getPriority() {
        return 30;
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        TinkerDataCapability.Holder data;
        if (context.getChangedSlot() == EquipmentSlot.HEAD && (data = (TinkerDataCapability.Holder)LogicHelper.orElseNull(context.getTinkerData())) != null) {
            ItemStack map = modifier.getHook(ToolInventoryCapability.HOOK).getStack(tool, modifier, tool.getPersistentData().getInt(SELECTED_SLOT));
            if (!map.m_41619_()) {
                data.put(MAP, map);
            } else {
                data.remove(MAP);
            }
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        TinkerDataCapability.Holder data;
        if (context.getChangedSlot() == EquipmentSlot.HEAD && (data = (TinkerDataCapability.Holder)LogicHelper.orElseNull(context.getTinkerData())) != null) {
            data.remove(MAP);
        }
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ItemStack map;
        TinkerDataCapability.Holder data;
        if (isCorrectSlot && !world.f_46443_ && (data = TinkerDataCapability.getData(holder)) != null && !(map = data.get(MAP, ItemStack.f_41583_)).m_41619_()) {
            ItemStack held = holder.m_21206_();
            holder.m_21008_(InteractionHand.OFF_HAND, map);
            map.m_41666_(world, (Entity)holder, 40, true);
            holder.m_21008_(InteractionHand.OFF_HAND, held);
            if (holder instanceof ServerPlayer) {
                Packet packet;
                ServerPlayer player = (ServerPlayer)holder;
                MapItemSavedData mapData = MapItem.m_42853_((ItemStack)map, (Level)world);
                Integer id = MapItem.m_151131_((ItemStack)map);
                if (mapData != null && id != null && (packet = mapData.m_164796_(id.intValue(), (Player)player)) != null) {
                    player.f_8906_.m_9829_(packet);
                }
            }
        }
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
        if (keyModifier == TooltipKey.NORMAL || keyModifier == TooltipKey.CONTROL) {
            int newSelected;
            ModDataNBT data = tool.getPersistentData();
            ToolInventoryCapability.InventoryModifierHook inventory = modifier.getHook(ToolInventoryCapability.HOOK);
            int totalSlots = inventory.getSlots(tool, modifier);
            int current = data.getInt(SELECTED_SLOT);
            for (newSelected = (current + 1) % (totalSlots + 1); newSelected < totalSlots && inventory.getStack(tool, modifier, newSelected).m_41619_(); ++newSelected) {
            }
            if (newSelected != current) {
                if (!player.m_9236_().f_46443_) {
                    data.putInt(SELECTED_SLOT, newSelected);
                    if (newSelected == totalSlots) {
                        player.m_5661_(DISABLED, true);
                    } else {
                        ItemStack selectedStack = inventory.getStack(tool, modifier, newSelected);
                        player.m_5661_((Component)Component.m_237110_((String)SELECTED, (Object[])new Object[]{selectedStack.m_41786_(), MapItem.m_151131_((ItemStack)selectedStack), newSelected + 1}), true);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(SELECTED_SLOT);
        return null;
    }

    static {
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.ARMOR_INTERACT, ModifierHooks.INVENTORY_TICK, ModifierHooks.REMOVE);
        LOADER = new SingletonLoader((Object)INSTANCE);
        MAP = TConstruct.createKey("current_map");
        SELECTED_SLOT = TConstruct.getResource("minimap_selected");
        DISABLED = TConstruct.makeTranslation("modifier", "minimap.disabled");
        SELECTED = TConstruct.makeTranslationKey("modifier", "minimap.selected");
    }
}

