/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.MobDisguiseModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ArmorUtil;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.tools.TinkerModifiers;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEvents {
    @SubscribeEvent
    static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        double armorMultiplier;
        List<ModifierEntry> modifiers;
        ToolStack tool;
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (stack.m_204117_(TinkerTags.Items.HARVEST) && !(tool = ToolStack.from(stack)).isBroken() && !(modifiers = tool.getModifierList()).isEmpty()) {
            float miningSpeedModifier = Modifier.getMiningModifier((LivingEntity)player);
            boolean isEffective = stack.m_41735_(event.getState());
            Direction direction = BlockSideHitListener.getSideHit(player);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.BREAK_SPEED).onBreakSpeed(tool, entry, event, direction, isEffective, miningSpeedModifier);
                if (!event.isCanceled()) continue;
                return;
            }
        }
        if ((armorMultiplier = player.m_21133_((Attribute)TinkerAttributes.MINING_SPEED_MULTIPLIER.get()) + (double)ArmorStatModule.getStat((Entity)player, TinkerDataKeys.MINING_SPEED)) >= 0.0) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * armorMultiplier));
        }
    }

    @SubscribeEvent
    static void onHarvest(TinkerToolEvent.ToolHarvestEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.m_60734_();
        ServerLevel world = event.getWorld();
        BlockPos pos = event.getPos();
        if (block == Blocks.f_50133_) {
            Direction facing = event.getContext().m_43719_();
            if (facing.m_122434_() == Direction.Axis.Y) {
                facing = event.getContext().m_8125_().m_122424_();
            }
            world.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, (BlockState)Blocks.f_50143_.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)facing), 11);
            ItemEntity itemEntity = new ItemEntity((Level)world, (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_() * 0.65, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_() * 0.65, new ItemStack((ItemLike)Items.f_42577_, 4));
            itemEntity.m_20334_(0.05 * (double)facing.m_122429_() + world.f_46441_.m_188500_() * 0.02, 0.05, 0.05 * (double)facing.m_122431_() + world.f_46441_.m_188500_() * 0.02);
            world.m_7967_((Entity)itemEntity);
            event.setResult(Event.Result.ALLOW);
        }
        if (block instanceof BeehiveBlock) {
            BeehiveBlock beehive = (BeehiveBlock)block;
            int level = (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_);
            if (level >= 5) {
                world.m_5594_(null, pos, SoundEvents.f_11697_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42784_, 3));
                if (!CampfireBlock.m_51248_((Level)world, (BlockPos)pos)) {
                    if (beehive.m_49654_((Level)world, pos)) {
                        beehive.m_49649_((Level)world, pos);
                    }
                    beehive.m_49594_((Level)world, state, pos, event.getPlayer(), BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                } else {
                    beehive.m_49590_((Level)world, state, pos);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void livingAttack(LivingAttackEvent event) {
        LivingEntity livingAttacker;
        Entity attacker;
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_() || entity.m_21224_()) {
            return;
        }
        DamageSource source = event.getSource();
        if (entity.m_6673_(source)) {
            return;
        }
        boolean isDirectDamage = OnAttackedModifierHook.isDirectDamage(source);
        EquipmentContext context = new EquipmentContext(entity);
        float amount = event.getAmount();
        if (context.hasModifiableArmor()) {
            for (EquipmentSlot slotType : EquipmentSlot.values()) {
                IToolStackView toolStack;
                if (!ModifierUtil.validArmorSlot(entity, slotType) || (toolStack = context.getToolInSlot(slotType)) == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    if (!entry.getHook(ModifierHooks.DAMAGE_BLOCK).isDamageBlocked(toolStack, entry, context, slotType, source, amount)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
            OnAttackedModifierHook.handleAttack(ModifierHooks.ON_ATTACKED, context, source, amount, isDirectDamage);
        }
        if ((attacker = source.m_7639_()) instanceof LivingEntity && (context = new EquipmentContext(livingAttacker = (LivingEntity)attacker)).hasModifiableArmor()) {
            for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IToolStackView toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getHook(ModifierHooks.DAMAGE_DEALT).onDamageDealt(toolStack, entry, context, slotType, entity, source, amount, isDirectDamage);
                }
            }
        }
    }

    private static int getArmorDamage(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            return 1;
        }
        return (int)damage;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void livingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        EquipmentContext context = new EquipmentContext(entity);
        int vanillaModifier = 0;
        float modifierValue = 0.0f;
        float originalDamage = event.getAmount();
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker.m_6047_()) {
            double crouchMultiplier;
            if (attacker instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)attacker;
                v0 = living.m_21133_((Attribute)TinkerAttributes.CROUCH_DAMAGE_MULTIPLIER.get());
            } else {
                v0 = crouchMultiplier = 1.0;
            }
            if ((crouchMultiplier += (double)ArmorStatModule.getStat(attacker, TinkerDataKeys.CROUCH_DAMAGE)) != 0.0) {
                originalDamage = (float)((double)originalDamage * crouchMultiplier);
            }
        }
        if (context.hasModifiableArmor()) {
            originalDamage = ModifyDamageModifierHook.modifyDamageTaken(ModifierHooks.MODIFY_HURT, context, source, originalDamage, OnAttackedModifierHook.isDirectDamage(source));
            event.setAmount(originalDamage);
            if (originalDamage <= 0.0f) {
                event.setCanceled(true);
                return;
            }
            if (DamageSourcePredicate.CAN_PROTECT.matches((Object)source)) {
                vanillaModifier = EnchantmentHelper.m_44856_((Iterable)entity.m_6168_(), (DamageSource)source);
                modifierValue = vanillaModifier;
            }
            for (EquipmentSlot slotType : EquipmentSlot.values()) {
                IToolStackView tool;
                if (!ModifierUtil.validArmorSlot(entity, slotType) || (tool = context.getToolInSlot(slotType)) == null || tool.isBroken()) continue;
                for (ModifierEntry entry : tool.getModifierList()) {
                    modifierValue = entry.getHook(ModifierHooks.PROTECTION).getProtectionModifier(tool, entry, context, slotType, source, modifierValue);
                }
            }
            if (entity.m_6095_().m_204039_(TinkerTags.EntityTypes.SMALL_ARMOR)) {
                modifierValue *= 4.0f;
            }
        } else if (DamageSourcePredicate.CAN_PROTECT.matches((Object)source) && entity.m_6095_().m_204039_(TinkerTags.EntityTypes.SMALL_ARMOR)) {
            vanillaModifier = EnchantmentHelper.m_44856_((Iterable)entity.m_6168_(), (DamageSource)source);
            modifierValue = vanillaModifier * 4;
        }
        float cap = 20.0f;
        if (modifierValue > 0.0f) {
            cap = (float)ProtectionModifierHook.getProtectionCap(entity, context.getTinkerData());
        }
        if ((float)vanillaModifier != modifierValue || cap > 20.0f && vanillaModifier > 20 || cap < 20.0f && (float)vanillaModifier > cap) {
            int damageMissed;
            float armor = 0.0f;
            float toughness = 0.0f;
            if (!source.m_269533_(DamageTypeTags.f_268490_)) {
                armor = entity.m_21230_();
                toughness = (float)entity.m_21133_(Attributes.f_22285_);
            }
            float finalDamage = ArmorUtil.getDamageForEvent(originalDamage, armor, toughness, vanillaModifier, modifierValue, cap);
            event.setAmount(finalDamage);
            if (!source.m_269533_(DamageTypeTags.f_268490_) && (damageMissed = ToolEvents.getArmorDamage(originalDamage) - ToolEvents.getArmorDamage(finalDamage)) > 0 && entity instanceof Player) {
                for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                    IToolStackView tool = context.getToolInSlot(slotType);
                    if (!(tool == null || source.m_269533_(DamageTypeTags.f_268745_) && tool.getItem().m_41475_())) {
                        if (tool.getModifierLevel(TinkerModifiers.tanned.getId()) != 0) continue;
                        ToolDamageUtil.damageAnimated(tool, damageMissed, entity, slotType);
                        continue;
                    }
                    ItemStack armorStack = entity.m_6844_(slotType);
                    if (armorStack.m_41619_() || source.m_269533_(DamageTypeTags.f_268745_) && armorStack.m_41720_().m_41475_() || !(armorStack.m_41720_() instanceof ArmorItem)) continue;
                    armorStack.m_41622_(damageMissed, entity, e -> e.m_21166_(slotType));
                }
            }
        }
    }

    @SubscribeEvent
    static void livingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        EquipmentContext context = new EquipmentContext(entity);
        if (context.hasModifiableArmor()) {
            float amount = ModifyDamageModifierHook.modifyDamageTaken(ModifierHooks.MODIFY_DAMAGE, context, source, event.getAmount(), OnAttackedModifierHook.isDirectDamage(source));
            event.setAmount(amount);
            if (amount <= 0.0f) {
                event.setCanceled(true);
                return;
            }
        }
        if (((Boolean)Config.COMMON.dropDragonScales.get()).booleanValue() && entity.m_6095_() == EntityType.f_20565_ && event.getAmount() > 0.0f && source.m_269533_(DamageTypeTags.f_268415_) && source.m_7639_() != null && source.m_7639_().m_6095_() == EntityType.f_20532_) {
            ModifierUtil.dropItem((Entity)entity, new ItemStack(TinkerModifiers.dragonScale, 1 + entity.m_9236_().f_46441_.m_188503_(8)));
        }
    }

    @SubscribeEvent
    static void livingWalk(LivingEvent.LivingTickEvent event) {
        ItemStack boots;
        LivingEntity living = event.getEntity();
        BlockPos pos = living.m_20183_();
        if (!living.m_5833_() && !living.m_9236_().m_5776_() && living.m_6084_() && !Objects.equals(living.f_20956_, pos) && !(boots = living.m_6844_(EquipmentSlot.FEET)).m_41619_() && boots.m_204117_(TinkerTags.Items.BOOTS)) {
            ToolStack tool = ToolStack.from(boots);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.BOOT_WALK).onWalk(tool, entry, living, living.f_20956_, pos);
            }
        }
    }

    @SubscribeEvent
    static void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        int count;
        Multiset<EntityType<?>> disguises;
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        LivingEntity living = event.getEntity();
        TinkerDataCapability.Holder data = TinkerDataCapability.getData(living);
        if (data != null && (disguises = data.get(MobDisguiseModule.DISGUISES)) != null && (count = disguises.count((Object)lookingEntity.m_6095_())) > 0) {
            event.modifyVisibility(1.0 / Math.pow(2.0, count) * event.getVisibilityModifier());
        }
    }

    @SubscribeEvent
    static void projectileHit(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        ModifierNBT modifiers = EntityModifierCapability.getOrEmpty((Entity)projectile);
        if (!modifiers.isEmpty()) {
            LivingEntity l;
            ModDataNBT nbt = PersistentDataCapability.getOrWarn((Entity)projectile);
            HitResult hit = event.getRayTraceResult();
            HitResult.Type type = hit.m_6662_();
            Entity entity = projectile.m_19749_();
            LivingEntity attacker = entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null;
            block0 : switch (type) {
                case ENTITY: {
                    EntityHitResult entityHit = (EntityHitResult)hit;
                    if (entityHit.m_82443_().m_6095_() == EntityType.f_20566_ && modifiers.getLevel(TinkerModifiers.enderference.getId()) <= 0) break;
                    LivingEntity target = ToolAttackUtil.getLivingEntity(entityHit.m_82443_());
                    for (ModifierEntry entry : modifiers.getModifiers()) {
                        if (!entry.getHook(ModifierHooks.PROJECTILE_HIT).onProjectileHitEntity(modifiers, nbt, entry, projectile, entityHit, attacker, target)) continue;
                        event.setCanceled(true);
                        break block0;
                    }
                    break;
                }
                case BLOCK: {
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    for (ModifierEntry entry : modifiers.getModifiers()) {
                        entry.getHook(ModifierHooks.PROJECTILE_HIT).onProjectileHitBlock(modifiers, nbt, entry, projectile, blockHit, attacker);
                    }
                    break;
                }
            }
        }
    }
}

