/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.fluids.fluids.PotionFluidType;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.material.ShapedMaterialRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.MoldingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.ShapedMaterialExtension;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.ToolBuildingCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingBasinCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingTableCategory;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.entity.SeveringCategory;
import slimeknights.tconstruct.plugin.jei.melting.FoundryCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierBookmarkIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientHelper;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierRecipeCategory;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierWorktableCategory;
import slimeknights.tconstruct.plugin.jei.modifiers.SlotIngredientHelper;
import slimeknights.tconstruct.plugin.jei.modifiers.SlotIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.plugin.jei.partbuilder.PartBuilderCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientHelper;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.transfer.CraftingStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.transfer.TinkerStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.util.GuiContainerTankHandler;
import slimeknights.tconstruct.plugin.jei.util.ToolPartSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.util.ToolSubtypeInterpreter;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.client.screen.AlloyerScreen;
import slimeknights.tconstruct.smeltery.client.screen.HeatingStructureScreen;
import slimeknights.tconstruct.smeltery.client.screen.MelterScreen;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.ToolContainerScreen;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IModIdHelper modIdHelper;

    public ResourceLocation getPluginUid() {
        return TConstructJEIConstants.PLUGIN;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingBasinCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingTableCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MoldingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EntityMeltingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FoundryCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SeveringCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ToolBuildingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PartBuilderCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierWorktableCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        List<Object> modifiers = Collections.emptyList();
        if (((Boolean)Config.CLIENT.showModifiersInJEI.get()).booleanValue()) {
            modifiers = ModifierRecipeLookup.getRecipeModifierList();
        }
        registration.register(TConstructJEIConstants.MODIFIER_TYPE, modifiers, (IIngredientHelper)new ModifierIngredientHelper(), (IIngredientRenderer)ModifierBookmarkIngredientRenderer.INSTANCE);
        registration.register(TConstructJEIConstants.PATTERN_TYPE, Collections.emptyList(), (IIngredientHelper)new PatternIngredientHelper(), (IIngredientRenderer)PatternIngredientRenderer.INSTANCE);
        List<SlotType.SlotCount> slots = SlotType.getAllSlotTypes().stream().map(type -> new SlotType.SlotCount((SlotType)type, 1)).toList();
        SlotIngredientRenderer.clearCache();
        registration.register(TConstructJEIConstants.SLOT_TYPE, slots, (IIngredientHelper)new SlotIngredientHelper(), (IIngredientRenderer)SlotIngredientRenderer.INGREDIENT);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registry) {
        registry.getCraftingCategory().addCategoryExtension(ShapedMaterialRecipe.class, ShapedMaterialExtension::new);
    }

    public void registerRecipes(IRecipeRegistration register) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        RegistryAccess access = level.m_9598_();
        RecipeManager manager = level.m_7465_();
        List castingBasinRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.CASTING_BASIN.get()), IDisplayableCastingRecipe.class);
        register.addRecipes(TConstructJEIConstants.CASTING_BASIN, castingBasinRecipes);
        List castingTableRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.CASTING_TABLE.get()), IDisplayableCastingRecipe.class);
        register.addRecipes(TConstructJEIConstants.CASTING_TABLE, castingTableRecipes);
        List meltingRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MELTING.get()), MeltingRecipe.class);
        register.addRecipes(TConstructJEIConstants.MELTING, meltingRecipes);
        register.addRecipes(TConstructJEIConstants.FOUNDRY, meltingRecipes);
        MeltingFuelHandler.setMeltngFuels(RecipeHelper.getRecipes((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.FUEL.get()), MeltingFuel.class));
        List entityMeltingRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.ENTITY_MELTING.get()), EntityMeltingRecipe.class);
        entityMeltingRecipes.add(new DefaultEntityMeltingRecipe(entityMeltingRecipes));
        register.addRecipes(TConstructJEIConstants.ENTITY_MELTING, entityMeltingRecipes);
        List alloyRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.ALLOYING.get()), AlloyRecipe.class);
        register.addRecipes(TConstructJEIConstants.ALLOY, alloyRecipes);
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()), MoldingRecipe.class)).addAll((Iterable)RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()), MoldingRecipe.class)).build();
        register.addRecipes(TConstructJEIConstants.MOLDING, (List)moldingRecipes);
        List modifierRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().sorted((r1, r2) -> {
            SlotType t1 = r1.getSlotType();
            SlotType t2 = r2.getSlotType();
            String n1 = t1 == null ? "zzzzzzzzzz" : t1.getName();
            String n2 = t2 == null ? "zzzzzzzzzz" : t2.getName();
            return n1.compareTo(n2);
        }).collect(Collectors.toList());
        register.addRecipes(TConstructJEIConstants.MODIFIERS, modifierRecipes);
        List severingRecipes = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.SEVERING.get()), SeveringRecipe.class);
        register.addRecipes(TConstructJEIConstants.SEVERING, severingRecipes);
        List<ToolBuildingRecipe> toolBuilding = RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.TINKER_STATION.get()), ToolBuildingRecipe.class).stream().sorted(Comparator.comparingInt(r -> StationSlotLayoutLoader.getInstance().get(r.getLayoutSlotId()).getSortIndex())).toList();
        register.addRecipes(TConstructJEIConstants.TOOL_BUILDING, toolBuilding);
        MaterialItemList.setRecipes(List.of());
        register.addRecipes(TConstructJEIConstants.PART_BUILDER, RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.PART_BUILDER.get()), IDisplayPartBuilderRecipe.class));
        register.addRecipes(TConstructJEIConstants.MODIFIER_WORKTABLE, RecipeHelper.getJEIRecipes((RegistryAccess)access, (RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MODIFIER_WORKTABLE.get()), IModifierWorktableRecipe.class));
    }

    private static <T extends Recipe<C>, C extends Container> void addCastingCatalyst(IRecipeCatalystRegistration registry, ItemLike item, RecipeType<IDisplayableCastingRecipe> ownCategory, net.minecraft.world.item.crafting.RecipeType<MoldingRecipe> type) {
        ItemStack stack = new ItemStack(item);
        registry.addRecipeCatalyst(stack, new RecipeType[]{ownCategory});
        assert (Minecraft.m_91087_().f_91073_ != null);
        if (!Minecraft.m_91087_().f_91073_.m_7465_().m_44054_(type).isEmpty()) {
            registry.addRecipeCatalyst(stack, new RecipeType[]{TConstructJEIConstants.MOLDING});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.partBuilder), new RecipeType[]{TConstructJEIConstants.PART_BUILDER});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.tinkerStation), new RecipeType[]{TConstructJEIConstants.MODIFIERS, TConstructJEIConstants.TOOL_BUILDING});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.tinkersAnvil), new RecipeType[]{TConstructJEIConstants.MODIFIERS, TConstructJEIConstants.TOOL_BUILDING});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.scorchedAnvil), new RecipeType[]{TConstructJEIConstants.MODIFIERS, TConstructJEIConstants.TOOL_BUILDING});
        registry.addRecipeCatalyst(new ItemStack(TinkerTables.modifierWorktable), new RecipeType[]{TConstructJEIConstants.MODIFIER_WORKTABLE});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.searedMelter), new RecipeType[]{TConstructJEIConstants.MELTING});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.searedHeater), new RecipeType[]{RecipeTypes.FUELING});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedTable, TConstructJEIConstants.CASTING_TABLE, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()));
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedBasin, TConstructJEIConstants.CASTING_BASIN, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.smelteryController), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ALLOY, TConstructJEIConstants.ENTITY_MELTING});
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.scorchedAlloyer), new RecipeType[]{TConstructJEIConstants.ALLOY});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedTable, TConstructJEIConstants.CASTING_TABLE, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()));
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedBasin, TConstructJEIConstants.CASTING_BASIN, (net.minecraft.world.item.crafting.RecipeType<MoldingRecipe>)((net.minecraft.world.item.crafting.RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addRecipeCatalyst(new ItemStack(TinkerSmeltery.foundryController), new RecipeType[]{TConstructJEIConstants.FOUNDRY});
        registry.addRecipeCatalyst(TConstructJEIConstants.MODIFIER_TYPE, (Object)new ModifierEntry(TinkerModifiers.severing, 1), new RecipeType[]{TConstructJEIConstants.SEVERING});
        registry.addRecipeCatalyst(TConstructJEIConstants.MODIFIER_TYPE, (Object)new ModifierEntry(TinkerModifiers.melting, 1), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ENTITY_MELTING});
        for (Holder item : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.MODIFIABLE)) {
            Object object = item.get();
            if (!(object instanceof IModifiableDisplay)) continue;
            IModifiableDisplay modifiable = (IModifiableDisplay)object;
            ModifierNBT traits = ToolTraitHook.getTraits(modifiable.getToolDefinition(), MaterialNBT.EMPTY);
            if (traits.getLevel(TinkerModifiers.severing.getId()) > 0) {
                registry.addRecipeCatalyst(modifiable.getRenderTool(), new RecipeType[]{TConstructJEIConstants.SEVERING});
            }
            if (traits.getLevel(TinkerModifiers.melting.getId()) <= 0) continue;
            if (item.containsTag(TinkerTags.Items.MELEE)) {
                registry.addRecipeCatalyst(modifiable.getRenderTool(), new RecipeType[]{TConstructJEIConstants.MELTING, TConstructJEIConstants.ENTITY_MELTING});
                continue;
            }
            registry.addRecipeCatalyst(modifiable.getRenderTool(), new RecipeType[]{TConstructJEIConstants.MELTING});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter tables = (stack, context) -> {
            if (context == UidContext.Ingredient) {
                return RetexturedHelper.getTextureName((ItemStack)stack);
            }
            return "";
        };
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.craftingStation.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.partBuilder.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.tinkerStation.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.tinkersAnvil.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.modifierWorktable.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerTables.scorchedAnvil.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.smelteryController.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedDrain.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedDuct.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedChute.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.foundryController.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedDrain.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedDuct.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedChute.m_5456_(), tables);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerFluids.potion.m_5456_(), ItemStack::m_41783_);
        registry.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)TinkerFluids.potion.get(), FluidStack::getTag);
        for (Holder item : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.TOOL_PARTS)) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)item.m_203334_()), (IIngredientSubtypeInterpreter)ToolPartSubtypeInterpreter.INSTANCE);
        }
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.MULTIPART_TOOL)) {
            Item item = (Item)holder.m_203334_();
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item, (IIngredientSubtypeInterpreter)(holder.m_203656_(TinkerTags.Items.SINGLEPART_TOOL) ? ToolSubtypeInterpreter.ALWAYS : ToolSubtypeInterpreter.INGREDIENT));
        }
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)TinkerSmeltery.copperCan.get()), (stack, context) -> CopperCanItem.getSubtype(stack));
        IIngredientSubtypeInterpreter tankInterpreter = (stack, context) -> TankItem.getSubtype(stack);
        for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((SearedTankBlock)TinkerSmeltery.searedTank.get((Enum)type)).m_5456_(), tankInterpreter);
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((SearedTankBlock)TinkerSmeltery.scorchedTank.get((Enum)type)).m_5456_(), tankInterpreter);
        }
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedLantern.m_5456_(), tankInterpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedLantern.m_5456_(), tankInterpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.searedFluidCannon.m_5456_(), tankInterpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)TinkerSmeltery.scorchedFluidCannon.m_5456_(), tankInterpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)TinkerModifiers.creativeSlotItem.get()), (stack, context) -> {
            SlotType slotType = CreativeSlotItem.getSlot(stack);
            return slotType != null ? slotType.getName() : "";
        });
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)TinkerModifiers.modifierCrystal.get()), (stack, context) -> {
            ModifierId id = ModifierCrystalItem.getModifier(stack);
            return id == null ? "" : id.toString();
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(MelterScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(AlloyerScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(HeatingStructureScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(ToolContainerScreen.class, new GuiContainerTankHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationTransferInfo());
        registration.addRecipeTransferHandler(new TinkerStationTransferInfo<IDisplayModifierRecipe>(TConstructJEIConstants.MODIFIERS));
        registration.addRecipeTransferHandler(new TinkerStationTransferInfo<ToolBuildingRecipe>(TConstructJEIConstants.TOOL_BUILDING));
    }

    private static void removeFluid(IIngredientManager manager, Fluid fluid) {
        manager.removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singleton(new FluidStack(fluid, 1000)));
    }

    private static boolean tagExists(String name) {
        Optional tag = BuiltInRegistries.f_257033_.m_203431_(ItemTags.create((ResourceLocation)Mantle.commonResource((String)name)));
        return tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0;
    }

    private static void cleanupRetexturedBlock(Predicate<ItemStack> remover, boolean showAll, ItemLike item, TagKey<Item> tag) {
        if (showAll) {
            remover.test(new ItemStack(item));
        } else {
            RetexturedHelper.addTagVariants(remover, (ItemLike)item, tag);
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        String showOnlyTools;
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        ArrayList<ItemStack> removeItems = new ArrayList<ItemStack>();
        Consumer<ItemStack> removeItem = removeItems::add;
        ArrayList<ItemStack> addItems = new ArrayList<ItemStack>();
        Consumer<ItemStack> addItem = addItems::add;
        removeItems.add(new ItemStack(TinkerModifiers.modifierCrystal));
        ModifierCrystalItem.addVariants(removeItem);
        removeItems.add(new ItemStack(TinkerModifiers.creativeSlotItem));
        ((CreativeSlotItem)TinkerModifiers.creativeSlotItem.get()).addVariants(removeItem);
        if (!((Boolean)Config.CLIENT.showFilledFluidTanks.get()).booleanValue()) {
            CopperCanItem.addFilledVariants(removeItem);
            TankItem.addFilledVariants(removeItem);
            addItems.add(TankItem.fillTank(TinkerSmeltery.searedTank, SearedTankBlock.TankType.FUEL_TANK, (Fluid)Fluids.f_76195_));
            addItems.add(TankItem.fillTank(TinkerSmeltery.searedTank, SearedTankBlock.TankType.FUEL_TANK, TinkerFluids.blazingBlood.get()));
            addItems.add(TankItem.fillTank(TinkerSmeltery.scorchedTank, SearedTankBlock.TankType.FUEL_TANK, (Fluid)Fluids.f_76195_));
            addItems.add(TankItem.fillTank(TinkerSmeltery.scorchedTank, SearedTankBlock.TankType.FUEL_TANK, TinkerFluids.blazingBlood.get()));
        }
        if (!(showOnlyTools = (String)Config.CLIENT.showOnlyToolMaterial.get()).isEmpty()) {
            for (Object item : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.MODIFIABLE)) {
                Object object = item.get();
                if (!(object instanceof IModifiable)) continue;
                IModifiable modifiable = (IModifiable)object;
                ToolBuildHandler.addVariants(removeItem, modifiable, "");
                ToolBuildHandler.addVariants(addItem, modifiable, showOnlyTools);
            }
        }
        String showOnlyParts = (String)Config.CLIENT.showOnlyPartMaterial.get();
        if (!showOnlyTools.isEmpty()) {
            for (Holder item : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.TOOL_PARTS)) {
                Object object = item.get();
                if (!(object instanceof IMaterialItem)) continue;
                IMaterialItem part = (IMaterialItem)object;
                part.addVariants(removeItem, "");
                part.addVariants(addItem, showOnlyParts);
            }
        }
        Predicate<ItemStack> cleanupItem = stack -> {
            removeItems.add((ItemStack)stack);
            return false;
        };
        boolean showTables = (Boolean)Config.CLIENT.showAllTableVariants.get();
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showTables, TinkerTables.craftingStation, (TagKey<Item>)ItemTags.f_13182_);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showTables, TinkerTables.partBuilder, (TagKey<Item>)ItemTags.f_13168_);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showTables, TinkerTables.tinkerStation, (TagKey<Item>)ItemTags.f_13168_);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showTables, TinkerTables.modifierWorktable, TinkerTags.Items.WORKSTATION_ROCK);
        boolean showAnvils = (Boolean)Config.CLIENT.showAllAnvilVariants.get();
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showAnvils, TinkerTables.tinkersAnvil, TinkerTags.Items.ANVIL_METAL);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showAnvils, TinkerTables.scorchedAnvil, TinkerTags.Items.ANVIL_METAL);
        boolean showSmeltery = (Boolean)Config.CLIENT.showAllSmelteryVariants.get();
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.smelteryController, TinkerTags.Items.SEARED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.searedDrain, TinkerTags.Items.SEARED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.searedDuct, TinkerTags.Items.SEARED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.searedChute, TinkerTags.Items.SEARED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.foundryController, TinkerTags.Items.SCORCHED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.scorchedDrain, TinkerTags.Items.SCORCHED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.scorchedDuct, TinkerTags.Items.SCORCHED_BLOCKS);
        JEIPlugin.cleanupRetexturedBlock(cleanupItem, showSmeltery, TinkerSmeltery.scorchedChute, TinkerTags.Items.SCORCHED_BLOCKS);
        if (!removeItems.isEmpty()) {
            manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, removeItems);
        }
        if (!addItems.isEmpty()) {
            manager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, addItems);
        }
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (JEIPlugin.tagExists("ingots/" + compat.getName()) || !compat.getAltTag().isEmpty() && JEIPlugin.tagExists("ingots/" + compat.getAltTag())) continue;
            JEIPlugin.removeFluid(manager, compat.getFluid().get());
        }
        if (!ModList.get().isLoaded("ceramics")) {
            JEIPlugin.removeFluid(manager, TinkerFluids.moltenPorcelain.get());
        }
        if (((Boolean)Config.CLIENT.showPotionFluidInJEI.get()).booleanValue()) {
            manager.addIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, BuiltInRegistries.f_256980_.m_203611_().filter(holder -> {
                Potion potion = (Potion)holder.get();
                return potion != Potions.f_43598_ && potion != Potions.f_43599_;
            }).map(holder -> PotionFluidType.potionFluid((ResourceKey<Potion>)holder.m_205785_(), 1000)).toList());
        }
        JEIPlugin.removeFluid(manager, TinkerFluids.potion.get());
        modIdHelper = jeiRuntime.getJeiHelpers().getModIdHelper();
    }
}

